/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.help.common.SimpleMap;
import oracle.help.common.TopicNameConvention;

public class ConventionBasedMap
extends SimpleMap {
    private TopicNameConvention _convention;
    private ArrayList _topicPrefixes = new ArrayList(1);
    private Set _misses = new HashSet();

    public ConventionBasedMap(HashMap hashMap, HashMap hashMap2, TopicNameConvention topicNameConvention, String string) {
        super(hashMap, hashMap2);
        this._convention = topicNameConvention;
        if (string != null) {
            if ((string = string.trim()).equals("")) {
                this._topicPrefixes.add(new String(""));
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    this._topicPrefixes.add(string2);
                }
            }
        } else {
            this._topicPrefixes.add(new String(""));
        }
    }

    public URL mapIDToURL(String string) {
        URL uRL = super.mapIDToURL(string);
        if (uRL != null) {
            return uRL;
        }
        if (!this._misses.contains(string)) {
            for (String string2 : this._topicPrefixes) {
                URL uRL2;
                if (!string.startsWith(string2) || !this._exists(uRL2 = this._convention.convertToURL(string))) continue;
                this.addIDMapping(string, uRL2);
                return uRL2;
            }
            this._misses.add(string);
        }
        return null;
    }

    private boolean _exists(URL uRL) {
        if (uRL != null) {
            try {
                InputStream inputStream = uRL.openStream();
                if (inputStream != null) {
                    inputStream.close();
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

