/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.jdk12;

import ice.debug.Debug;
import ice.util.Defs;
import ice.util.io.IOKit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;

public final class URLClassLoader_jdk12
extends URLClassLoader {
    private static final String[] substClasses = new String[]{"netscape.javascript.JSObject", "netscape.javascript.JSException"};
    private boolean javaPluginMode = false;

    public URLClassLoader_jdk12(URL[] urls, ClassLoader pp) {
        super(urls, pp);
        String tmp = Defs.sysProperty("browser");
        if (tmp != null && tmp.indexOf("plugin") != -1) {
            this.javaPluginMode = true;
        }
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null && this.javaPluginMode) {
            c = this.loadSubstClass(name, resolve);
        }
        if (c == null) {
            try {
                c = super.loadClass(name, resolve);
            }
            catch (LinkageError ex) {
                if (Debug.trace) {
                    Debug.trace("Assuming ClassNotFoundException for " + ex);
                }
                throw new ClassNotFoundException(ex.toString());
            }
        }
        return c;
    }

    private Class doDefineClass(String name, byte[] b, int off, int len) {
        return super.defineClass(name, b, off, len);
    }

    private Class loadSubstClass(String name, boolean resolve) {
        Class c = null;
        for (int i = 0; i < substClasses.length; ++i) {
            if (!name.equals(substClasses[i])) continue;
            byte[] data = this.getClassBytes(name);
            if (data != null) {
                c = this.doDefineClass(name, data, 0, data.length);
            }
            if (c == null || !resolve) break;
            this.resolveClass(c);
            break;
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassBytes(String name) {
        block9: {
            String resource = "/" + name.replace('.', '/') + ".bin";
            InputStream is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                if (Debug.trace) {
                    Debug.trace("WARNING: failed to load resource: " + resource);
                }
            } else {
                try {
                    byte[] data;
                    try {
                        data = IOKit.readAll(is);
                    }
                    finally {
                        is.close();
                    }
                    return data;
                }
                catch (IOException ex) {
                    if (!Debug.ex) break block9;
                    Debug.ex(ex);
                }
            }
        }
        return null;
    }
}

