/*
 * Decompiled with CFR 0.152.
 */
package ice.util.net;

import ice.util.ParseDate;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;

public class Cookie
implements Serializable {
    String name;
    String value;
    String comment;
    String domain;
    int maxAge;
    String path;
    boolean secure;
    Date expires;
    String version;
    private int size = 0;
    private long lastAccess;

    public Cookie() {
    }

    Cookie(URL url) {
        int idx;
        this.version = null;
        this.comment = null;
        this.value = null;
        this.name = null;
        this.maxAge = 0;
        this.secure = false;
        this.expires = null;
        this.domain = url.getHost();
        this.path = url.getFile();
        if (!this.path.endsWith("/") && (idx = this.path.lastIndexOf(47)) >= 0) {
            this.path = this.path.substring(0, idx + 1);
        }
    }

    public Cookie(String nameIn, String valueIn, String commentIn, String domainIn, int maxAgeIn, String pathIn, boolean secureIn, Date expiresIn, String versionIn) {
        this.name = nameIn;
        this.value = valueIn;
        this.comment = commentIn;
        this.domain = domainIn;
        this.maxAge = maxAgeIn;
        this.path = pathIn;
        this.secure = secureIn;
        this.expires = expiresIn;
        this.version = versionIn;
    }

    public String toString() {
        String str = "Cookie: " + this.name + "=" + this.value + "; Comment=" + this.comment + "; Domain=" + this.domain + "Max-Age=" + this.maxAge + "; Path=" + this.path + "; Version=" + this.version + "; Secure=" + this.secure;
        return str;
    }

    public static Cookie parseFromString(URL url, String str) {
        Cookie c = new Cookie(url);
        StringTokenizer st = new StringTokenizer(str, ";", false);
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String token = st.nextToken();
            int idx = token.indexOf(61);
            if (idx > 0) {
                name = token.substring(0, idx);
                value = token.substring(idx + 1);
            } else {
                name = token;
                value = "";
            }
            name = name.trim();
            value = value.trim();
            if (name.equalsIgnoreCase("comment")) {
                c.comment = value;
                continue;
            }
            if (name.equalsIgnoreCase("domain")) {
                c.domain = value;
                continue;
            }
            if (name.equalsIgnoreCase("path")) {
                c.path = value;
                continue;
            }
            if (name.equalsIgnoreCase("version")) {
                c.version = value;
                continue;
            }
            if (name.equalsIgnoreCase("expires")) {
                c.expires = ParseDate.parseDate(value);
                continue;
            }
            if (name.equalsIgnoreCase("secure")) {
                c.secure = true;
                continue;
            }
            if (name.equalsIgnoreCase("max-age")) {
                c.maxAge = Integer.parseInt(value);
                c.expires = new Date(System.currentTimeMillis() + (long)(c.maxAge * 1000));
                continue;
            }
            c.name = name;
            c.value = value;
        }
        if (c.name == null || c.value == null) {
            c = null;
        }
        if (c != null) {
            c.setSize(str.length());
        }
        return c;
    }

    private void setSize(int size) {
        this.size = size;
    }

    public boolean isExpired() {
        return this.expires != null && this.expires.before(new Date());
    }

    public boolean isSessionCookie() {
        return this.expires == null;
    }

    public String use() {
        this.lastAccess = System.currentTimeMillis();
        return this.name + "=" + this.value;
    }

    public long lastUsed() {
        return this.lastAccess;
    }

    public int size() {
        return this.size;
    }

    public Date expirationDate() {
        return new Date(this.expires.getTime());
    }

    public void setExpirationDate(Date expiresIn) {
        this.expires = expiresIn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nameIn) {
        this.name = nameIn;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String valueIn) {
        this.value = valueIn;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String pathIn) {
        this.path = pathIn;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domainIn) {
        this.domain = domainIn;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secureIn) {
        this.secure = secureIn;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String commentIn) {
        this.comment = commentIn;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String versionIn) {
        this.version = versionIn;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int maxAgeIn) {
        this.maxAge = maxAgeIn;
    }
}

