/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.DocPane;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Scripter;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.UrlMaster;
import ice.storm.Viewport;
import ice.util.Defs;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.Vector;

public abstract class Pilot {
    StormBase base;
    Viewport viewport;

    public StormBase getStorm() {
        return this.base;
    }

    public void init(String componentToolkitName) {
        if (Debug.trace) {
            Debug.trace(this.getClass().getName() + " (" + componentToolkitName + ") in " + this.getViewportId());
        }
    }

    public void dispose() {
    }

    protected void setZoom(int zoom) {
    }

    public boolean isDetached() {
        return false;
    }

    public void clear(String contentType) {
    }

    public void parse(ContentLoader cl) throws IOException {
    }

    public void gotoRef(String ref) {
    }

    public boolean refExists(String ref) {
        return false;
    }

    public void stopLoading() {
    }

    public void modifiedByScript() {
    }

    public void suspend() {
    }

    public void resume() {
    }

    public void onLowMemory() {
    }

    public Component createComponent() {
        return null;
    }

    public StormPrinter createPrinter() {
        return null;
    }

    public Object getDynamicValueOnWindow(DynamicObject window, String name, DynEnv env) {
        return DynamicObject.NOT_FOUND;
    }

    public int setDynamicValueOnWindow(DynamicObject window, String name, Object value, DynEnv env) {
        return 0;
    }

    public Object execDynamicMethodOnWindow(DynamicObject window, String name, Object[] args, DynEnv env) {
        return DynamicObject.NOT_FOUND;
    }

    public DynamicObject getDocumentObject() {
        return null;
    }

    public void updateFrameList() {
    }

    public Object getSnapshot() {
        return null;
    }

    public void applySnapshot(Object snap) {
    }

    public void parsingDone() {
    }

    public void onLoadingDone() {
    }

    public void beforeUnload() {
    }

    public void refresh() {
    }

    public final String getViewportId() {
        return this.viewport.getId();
    }

    public final Viewport getPilotViewport() {
        return this.viewport;
    }

    public DocPane getDocPane() {
        return null;
    }

    public final void getAllPilotInstances(Vector result) {
        Class<?> pilotClass = this.getClass();
        this.base.getAllPilotInstances(pilotClass, result);
    }

    public final Object getViewportProperty(String name) {
        return this.viewport.getProperty(name);
    }

    public final void firePropertyChange(String propName, Object oldValue, Object newValue) {
        this.base.sendViewportMessage(this.viewport, propName, oldValue, newValue);
    }

    public final void renderContent(String loc, String contentType, String viewportName) {
        Scripter scripter = this.base.getScripterForCodeLocation(loc);
        if (scripter != null) {
            Viewport v = this.viewport.findViewportInTreeByName(viewportName);
            if (v == null) {
                v = this.viewport;
            }
            scripter.evalCodeLocation(v, loc);
        } else {
            Viewport view = this.findOrCreateViewport(viewportName, loc);
            if (view != null) {
                this.base.renderContent(loc, contentType, view.getId());
            }
        }
    }

    public final Viewport findOrCreateViewport(String viewportName) {
        return this.findOrCreateViewport(viewportName, null);
    }

    public final Viewport findOrCreateViewport(String viewportName, String location) {
        boolean nullContainerContentLoading = Defs.sysPropertyBoolean("ice.stormbase.nullContainerContentLoading", true);
        Viewport v = this.viewport.findViewportInTreeByName(viewportName);
        if (v == null && (v = this.base.newTopLevelViewport(viewportName, location)) == null && nullContainerContentLoading) {
            v = this.viewport;
        }
        return v;
    }

    public final boolean isStopRequested() {
        return this.viewport.isStopRequested();
    }

    public final void refreshViewport() {
        Container c = this.viewport.getContainer();
        if (c != null) {
            c.repaint();
        }
    }

    public final void viewportBecameActive() {
        this.base.setActiveViewport(this.viewport);
    }

    public final Container getViewportContainer() {
        return this.viewport.getContainer();
    }

    public final UrlMaster getUrlMaster() {
        return this.base.getUrlMaster();
    }
}

