/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.swing;

import ice.debug.Debug;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNodeList;
import ice.pilots.text.ThePilot;
import ice.ri.common.print.PrintHelper;
import ice.ri.common.print.PrintUtilities;
import ice.ri.common.print.swing.PageSetupDialog;
import ice.ri.common.print.swing.PrintPreviewDialog;
import ice.ri.common.search.SearchHelper;
import ice.ri.common.search.SearchStatusEventAdapter;
import ice.ri.common.search.swing.SearchPanel;
import ice.ri.swing.ActionHelper;
import ice.ri.swing.ActivityThrobber;
import ice.ri.swing.Bookmark;
import ice.ri.swing.DragEventListener;
import ice.ri.swing.FocusLessButton;
import ice.ri.swing.LocationBar;
import ice.ri.swing.MouseListener;
import ice.ri.swing.MouseManager;
import ice.ri.swing.Parse;
import ice.ri.swing.PropertiesManager;
import ice.ri.swing.Resources;
import ice.ri.swing.StatusBar;
import ice.ri.swing.ToolBarPanel;
import ice.ri.swing.VisitedLinksManager;
import ice.ri.swing.WindowManager;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.ViewportGuiParams;
import ice.storm.print.StormPageFormat;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.html.HTMLAnchorElement;
import org.w3c.dom.html.HTMLDocument;

public class BrowserWindow
extends JFrame
implements PropertyChangeListener {
    static final int EVENT_MOUSE_CLICKED = 1;
    static final int EVENT_MOUSE_MOVED = 2;
    static final int EVENT_MOUSE_ENTERED = 3;
    static final int EVENT_MOUSE_EXITED = 4;
    private static final Object BROWSER_PANEL_KEY = new Object();
    private static final String[] actionNames = new String[]{"separator", "back", "forward", "reload", "stop", "printsetup", "printpilot", "printpreview", "openURL", "openfile", "sethome", "gotohome", "gotosearch", "gotohelp", "encoding", "quit", "close", "save", "new", "fonts", "source", "console", "dom", "look", "goto", "search", "copy", "paste", "emulation"};
    private static final int[] actions = new int[]{-1, 1, 2, 3, 4, 33, 5, 32, 6, 7, 9, 10, 29, 30, 11, 12, 18, 13, 14, 15, 16, 17, 31, 25, 26, 28, 34, 35, 36};
    Viewport mainview;
    String currentFrameId;
    Thread throbberThread;
    WindowManager windowManager;
    PropertiesManager properties;
    Resources res;
    Container browserContainer;
    private String defaultTitle;
    String urlTitle;
    private JMenu bookmarkMenu;
    StatusBar statusBar;
    SearchPanel searchBar;
    LocationBar locationBar;
    ToolBarPanel toolBar;
    MouseManager mouseManager;
    JButton logo;
    ActivityThrobber throbber;
    private JMenuBar mBar = new JMenuBar();
    private boolean winActive = false;
    private boolean moveFocusToDocPane = false;
    private static final String ERROR_PAGE_NAME = "error.html";
    private static final String LOGO_PLACEHOLDER = "logo1.gif";
    private static final String ERROR_PLACEHOLDER = "No error message available.";

    BrowserWindow(WindowManager windowManager, Viewport view) {
        this.windowManager = windowManager;
        this.properties = windowManager.getProperties();
        this.res = windowManager.getProperties().res;
        new DropTarget(this, 3, new DragEventListener(this));
        this.mainview = view;
        this.mainview.setProperty(BROWSER_PANEL_KEY, this);
        this.enableEvents(64L);
        this.browserContainer = new JPanel();
        this.buildPanels();
        this.buildMenu();
        this.buidPopup();
        this.mainview.addPropertyChangeListener(this);
        this.mainview.addPropertyChangeListener(VisitedLinksManager.getInstance());
        this.setBrowserAppearance();
        this.setFrameAppearance();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                BrowserWindow.this.winActive = true;
                if (BrowserWindow.this.moveFocusToDocPane) {
                    BrowserWindow.this.moveFocusToDocPane = false;
                    Pilot pilot = BrowserWindow.this.mainview.getPilot();
                    if (pilot != null) {
                        pilot.getDocPane().reqFocus();
                    }
                }
            }

            public void windowDeactivated(WindowEvent e) {
                BrowserWindow.this.winActive = false;
            }
        });
        this.setVisible(true);
    }

    private void setFrameAppearance() {
        URL iconURL;
        this.defaultTitle = this.res.str("application.title");
        this.setTitle(this.defaultTitle);
        Dimension dim = new Dimension(this.properties.getInt("application.width"), this.properties.getInt("application.height"));
        int _x = -1;
        int _y = -1;
        ViewportGuiParams _viewportGuiParams = this.mainview.getGuiParams();
        if (_viewportGuiParams != null) {
            _x = Math.abs(_viewportGuiParams.left);
            _y = Math.abs(_viewportGuiParams.top);
            this.setResizable(_viewportGuiParams.resizable);
            dim = this.calculateActualFrameSize(dim.width, dim.height);
        }
        this.setSize(dim.width, dim.height);
        if (_x >= 0 && _y >= 0) {
            this.setLocation(_x, _y);
        }
        if ((iconURL = this.res.imageURL("ibicone32.gif")) != null) {
            this.setIconImage(this.getToolkit().getImage(iconURL));
        }
    }

    private Dimension calculateActualFrameSize(int w, int h) {
        String pos;
        this.pack();
        ViewportGuiParams guiParams = this.mainview.getGuiParams();
        if (guiParams != null) {
            if (guiParams.width > 0) {
                w = guiParams.width;
            }
            if (guiParams.height > 0) {
                h = guiParams.height;
            }
        }
        if (w < 100) {
            w = 100;
        }
        if (h < 100) {
            h = 100;
        }
        if (this.statusBar != null) {
            pos = this.properties.getPositionInfo("statusbar.location");
            if (pos.equalsIgnoreCase("East") || pos.equalsIgnoreCase("West")) {
                w += this.statusBar.getWidth();
            } else {
                h += this.statusBar.getHeight();
            }
        }
        if (this.toolBar != null) {
            pos = this.properties.getPositionInfo("toolbar.location");
            if (pos.equalsIgnoreCase("East") || pos.equalsIgnoreCase("West")) {
                w += this.toolBar.getWidth();
            } else {
                h += this.toolBar.getHeight();
            }
        }
        if (this.locationBar != null) {
            pos = this.properties.getPositionInfo("locationbar.location");
            if (pos.equalsIgnoreCase("East") || pos.equalsIgnoreCase("West")) {
                w += this.locationBar.getWidth();
            } else {
                h += this.locationBar.getHeight();
            }
        }
        if (this.mBar != null) {
            h += this.mBar.getHeight();
        }
        Insets insets = this.getInsets();
        w = w + insets.left + insets.right;
        h = h + insets.top + insets.bottom;
        return new Dimension(w, h);
    }

    private void setBrowserAppearance() {
        this.setEncoding(this.properties.getEncoding("document.encoding"));
    }

    private void buildPanels() {
        JPanel layout_panel;
        PropertiesManager pm = this.properties;
        String tool_bar_position = null;
        String location_bar_position = null;
        String search_bar_position = null;
        String status_bar_position = null;
        ViewportGuiParams params = this.mainview.getGuiParams();
        boolean showIt = true;
        if (params != null) {
            if (!params.toolbar) {
                showIt = false;
            }
        } else if (!this.properties.getBoolean("toolbar.visible", true)) {
            showIt = false;
        }
        if (showIt) {
            this.logo = this.buildToolbarLogo();
            JPanel buttons = this.buildToolbarButtons();
            if (this.logo != null || buttons != null) {
                String pos;
                ToolBarPanel tb = new ToolBarPanel();
                if (this.logo != null) {
                    tb.addLogo(this.logo);
                }
                if (buttons != null) {
                    tb.addButtons(buttons);
                }
                if ((pos = pm.getPositionInfo("toolbar.location")) == "East" || pos == "West") {
                    tb.setOrientation(1);
                }
                this.toolBar = tb;
                tool_bar_position = pos;
            }
        }
        showIt = true;
        if (params != null) {
            if (!params.location) {
                showIt = false;
            }
        } else if (!this.properties.getBoolean("locationbar.visible", true)) {
            showIt = false;
        }
        if (showIt) {
            boolean showGoButton = pm.getBoolean("locationbar.gobutton.visible", true);
            this.locationBar = new LocationBar(this, showGoButton);
            location_bar_position = pm.getHorizontalInfo("locationbar.location");
        }
        showIt = true;
        if (params != null) {
            if (!params.status) {
                showIt = false;
            }
        } else if (!this.properties.getBoolean("statusbar.visible", true)) {
            showIt = false;
        }
        if (showIt) {
            this.statusBar = new StatusBar(this);
            status_bar_position = pm.getHorizontalInfo("statusbar.location");
        } else {
            this.statusBar = null;
        }
        Container container = this.browserContainer;
        if (this.locationBar != null) {
            JPanel layout_panel2 = new JPanel(new BorderLayout());
            layout_panel2.add((Component)container, "Center");
            layout_panel2.add((Component)this.locationBar, location_bar_position);
            container = layout_panel2;
        }
        this.searchBar = new SearchPanel(this.mainview);
        search_bar_position = pm.getHorizontalInfo("searchbar.location");
        JPanel search_layout_panel = new JPanel(new BorderLayout());
        search_layout_panel.add((Component)container, "Center");
        search_layout_panel.add((Component)this.searchBar, search_bar_position);
        if (this.statusBar != null) {
            this.searchBar.addSearchStatusEventListener(new SearchStatusEventAdapter(){

                public void setSearchStatusMessage(int status, int nMatches) {
                    if (status == SearchHelper.MATCH_FOUND) {
                        if (nMatches > 1) {
                            BrowserWindow.this.statusBar.setStatusText(Integer.toString(nMatches) + ' ' + BrowserWindow.this.res.str("search.found.matches"));
                        } else if (nMatches == 1) {
                            BrowserWindow.this.statusBar.setStatusText("1 " + BrowserWindow.this.res.str("search.found"));
                        } else {
                            BrowserWindow.this.statusBar.setStatusText(" ");
                        }
                    } else if (status == SearchHelper.NO_MATCH_FOUND) {
                        BrowserWindow.this.statusBar.setStatusText(BrowserWindow.this.res.str("search.notfound"));
                    } else if (status == SearchHelper.END_OF_SEARCH) {
                        BrowserWindow.this.statusBar.setStatusText(BrowserWindow.this.res.str("search.end.search"));
                    }
                }
            });
        }
        container = search_layout_panel;
        if (this.statusBar != null) {
            layout_panel = new JPanel(new BorderLayout());
            layout_panel.add((Component)container, "Center");
            layout_panel.add((Component)this.statusBar, status_bar_position);
            container = layout_panel;
        }
        if (this.toolBar != null) {
            layout_panel = new JPanel(new BorderLayout());
            layout_panel.add((Component)container, "Center");
            layout_panel.add((Component)this.toolBar, tool_bar_position);
            container = layout_panel;
        }
        this.setContentPane(container);
    }

    private void buildMenu() {
        PropertiesManager pm = this.properties;
        ViewportGuiParams params = this.mainview.getGuiParams();
        if (params != null ? !params.menubar : !this.properties.getBoolean("menubar.visible", true)) {
            return;
        }
        StringBuffer sb = new StringBuffer(22);
        sb.append("menu");
        int countMenu = 1;
        while (true) {
            sb.setLength(4);
            sb.append(countMenu);
            int prefixLength = sb.length();
            sb.append(".label");
            String menuLabel = pm.getString(sb.toString(), null);
            if (menuLabel == null) break;
            JMenu menu = new JMenu(this.res.str(menuLabel));
            sb.setLength(prefixLength);
            sb.append(".mnemonic");
            String menuMnemonic = pm.getString(sb.toString(), null);
            if (menuMnemonic != null) {
                menu.setMnemonic(menuMnemonic.trim().toCharArray()[0]);
            }
            int countItem = 1;
            while (true) {
                sb.setLength(prefixLength);
                sb.append(".item");
                sb.append(countItem);
                String actionString = pm.getString(sb.toString(), null);
                if (actionString == null) break;
                if (!actionString.equals("fonts")) {
                    int actionStrLength = sb.length();
                    int actionValue = Parse.parseAction(actionNames, actions, actionString, this.res);
                    if (actionValue == -1) {
                        menu.addSeparator();
                    } else if (actionValue > -1) {
                        sb.setLength(actionStrLength);
                        sb.append(".label");
                        menuLabel = pm.getString(sb.toString(), null);
                        if (menuLabel == null) {
                            menuLabel = this.res.str("long." + actionString);
                        }
                        JMenuItem item = new JMenuItem(menuLabel.trim());
                        new ActionHelper(actionValue, item, this);
                        item.setVerticalTextPosition(0);
                        item.setHorizontalTextPosition(2);
                        sb.setLength(actionStrLength);
                        sb.append(".image");
                        String imageRes = pm.getString(sb.toString(), null);
                        if (imageRes != null) {
                            item.setIcon(this.res.imageIcon(this.getToolkit(), imageRes));
                        }
                        sb.setLength(actionStrLength);
                        sb.append(".shortcut");
                        KeyStroke k = pm.getKeyStroke(sb.toString(), null);
                        if (k != null) {
                            item.setAccelerator(k);
                        }
                        menu.add(item);
                    }
                }
                ++countItem;
            }
            this.mBar.add(menu);
            ++countMenu;
        }
        this.buildBookmarkMenu();
        if (this.bookmarkMenu != null) {
            this.mBar.add(this.bookmarkMenu);
        }
        if (pm.getBoolean("helpmenu.visible", true)) {
            JMenu helpMenu = new JMenu(this.res.str("menu.help"));
            helpMenu.setMnemonic('h');
            JMenuItem helpStartMenu = new JMenuItem(this.res.str("menu.help.start"));
            helpStartMenu.setAccelerator(KeyStroke.getKeyStroke(112, 0));
            JMenuItem aboutMenu = new JMenuItem(this.res.str("menu.help.about"));
            helpMenu.add(helpStartMenu);
            helpMenu.addSeparator();
            helpMenu.add(aboutMenu);
            new ActionHelper(19, helpStartMenu, this);
            new ActionHelper(22, aboutMenu, this);
            this.mBar.add(helpMenu);
        }
        this.setJMenuBar(this.mBar);
    }

    private void buildBookmarkMenu() {
        PropertiesManager pm = this.properties;
        if (pm.getBoolean("bookmarkmenu.visible", true)) {
            this.bookmarkMenu = new JMenu(this.res.str("menu.bookmarks"));
            this.bookmarkMenu.setMnemonic('b');
            JMenuItem addBookmarkMenu = new JMenuItem(this.res.str("menu.bookmark.add"));
            addBookmarkMenu.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            JMenuItem manageBookmarkMenu = new JMenuItem(this.res.str("menu.bookmark.manage"));
            manageBookmarkMenu.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.bookmarkMenu.add(addBookmarkMenu);
            this.bookmarkMenu.add(manageBookmarkMenu);
            this.bookmarkMenu.addSeparator();
            new ActionHelper(23, addBookmarkMenu, this);
            new ActionHelper(24, manageBookmarkMenu, this);
            Vector bookmarks = pm.bookmarks();
            for (int i = 0; i < bookmarks.size(); ++i) {
                this.addBookmarkItem((Bookmark)bookmarks.elementAt(i));
            }
        }
    }

    private JButton buildToolbarLogo() {
        String logoImage = this.properties.getString("toolbar.logo", null);
        if (logoImage != null) {
            FocusLessButton logo = new FocusLessButton();
            ImageIcon logoIcon = this.res.imageIcon(this.getToolkit(), logoImage);
            logo.setIcon(logoIcon);
            logo.setBorderPainted(false);
            logo.setFocusPainted(false);
            new ActionHelper(26, logo, this);
            int totalFrames = this.properties.getInt("toolbar.logo.animation.frames", 0);
            String frameKeyName = "toolbar.logo.frame";
            Icon[] throbberImage = new Icon[totalFrames + 1];
            int frameInc = 0;
            while (frameInc < totalFrames) {
                String frameFileName = this.properties.getString(frameKeyName + (frameInc + 1), null);
                if (frameFileName == null) continue;
                throbberImage[frameInc++] = this.res.imageIcon(this.getToolkit(), frameFileName);
            }
            throbberImage[frameInc] = logoIcon;
            long animInterval = this.properties.getInt("toolbar.logo.animation.interval", 1000);
            this.throbber = new ActivityThrobber(logo, throbberImage, animInterval);
            if (totalFrames > 0) {
                this.throbberThread = new Thread(this.throbber);
                this.throbberThread.setDaemon(true);
                this.throbberThread.setName("Activity_Throbber-" + this.mainview.getName());
                this.throbberThread.start();
            }
            return logo;
        }
        return null;
    }

    private JPanel buildToolbarButtons() {
        PropertiesManager pm = this.properties;
        Font f = pm.getFont("buttons.font");
        int count = 1;
        int maxMaxWidth = 0;
        int maxPrefWidth = 0;
        int maxMinWidth = 0;
        int maxMaxHeight = 0;
        int maxPrefHeight = 0;
        int maxMinHeight = 0;
        ImageIcon blank = this.res.imageIcon(this.getToolkit(), "clear.gif");
        boolean withLabels = pm.getBoolean("buttons.display.labels", true);
        boolean withTooltips = pm.getBoolean("buttons.display.tooltips", true);
        boolean withImages = pm.getBoolean("buttons.display.images", true);
        JPanel buttonPanel = new JPanel();
        StringBuffer sb = new StringBuffer(30);
        while (true) {
            sb.setLength(0);
            sb.append("button");
            sb.append(count);
            String actionString = pm.getString(sb.toString(), null);
            if (actionString == null) break;
            int actionValue = Parse.parseAction(actionNames, actions, actionString, this.res);
            if (actionValue == -1) {
                buttonPanel.add(Box.createRigidArea(new Dimension(5, 5)));
            } else if (actionValue > -1) {
                String label = "";
                if (withLabels) {
                    sb.setLength(0);
                    sb.append(actionString);
                    sb.append(".label");
                    label = pm.getString(sb.toString(), null);
                    if (label == null) {
                        sb.setLength(0);
                        sb.append("short.");
                        sb.append(actionString);
                        label = this.res.str(sb.toString());
                    }
                }
                FocusLessButton button = new FocusLessButton();
                new ActionHelper(actionValue, button, this);
                button.setFocusPainted(false);
                button.setText(label.trim());
                button.setMargin(new Insets(4, 4, 4, 4));
                button.setVerticalTextPosition(0);
                button.setHorizontalTextPosition(4);
                button.setFont(f);
                if (withTooltips) {
                    sb.setLength(0);
                    sb.append(actionString);
                    sb.append(".tooltip");
                    String tooltip = pm.getString(sb.toString(), null);
                    if (tooltip == null) {
                        sb.setLength(0);
                        sb.append("long.");
                        sb.append(actionString);
                        tooltip = this.res.str("long." + actionString);
                    }
                    button.setToolTipText(tooltip);
                }
                if (!withImages) {
                    button.setIcon(blank);
                } else {
                    sb.setLength(0);
                    sb.append(actionString);
                    int prefixLength = sb.length();
                    sb.setLength(prefixLength);
                    sb.append(".image.normal");
                    String name = pm.getString(sb.toString(), null);
                    if (name != null) {
                        button.setIcon(this.res.imageIcon(this.getToolkit(), name));
                    } else {
                        button.setIcon(blank);
                    }
                    sb.setLength(prefixLength);
                    sb.append(".image.pressed");
                    name = pm.getString(sb.toString(), null);
                    if (name != null) {
                        button.setPressedIcon(this.res.imageIcon(this.getToolkit(), name));
                    }
                    sb.setLength(prefixLength);
                    sb.append(".image.disabled");
                    name = pm.getString(sb.toString(), null);
                    if (name != null) {
                        button.setDisabledIcon(this.res.imageIcon(this.getToolkit(), name));
                    }
                    sb.setLength(prefixLength);
                    sb.append(".image.rollover");
                    name = pm.getString(sb.toString(), null);
                    if (name != null) {
                        button.setRolloverIcon(this.res.imageIcon(this.getToolkit(), name));
                        button.setRolloverEnabled(true);
                    }
                }
                Dimension maxSz = button.getMaximumSize();
                Dimension minSz = button.getMinimumSize();
                Dimension prefSz = button.getPreferredSize();
                maxMaxWidth = Math.max(maxMaxWidth, maxSz.width);
                maxPrefWidth = Math.max(maxPrefWidth, prefSz.width);
                maxMinWidth = Math.max(maxMinWidth, minSz.width);
                maxMaxHeight = Math.max(maxMaxHeight, maxSz.height);
                maxPrefHeight = Math.max(maxPrefHeight, prefSz.height);
                maxMinHeight = Math.max(maxMinHeight, minSz.height);
                buttonPanel.add(button);
            }
            ++count;
        }
        return buttonPanel;
    }

    private void buidPopup() {
        if (this.properties.getBoolean("popupmenu.visible", true)) {
            this.mouseManager = new MouseManager(this);
        }
    }

    public void addBookmarkItem(Bookmark bookmark) {
        if (this.bookmarkMenu != null) {
            JMenuItem item = new JMenuItem(bookmark.title);
            this.bookmarkMenu.add(item);
            ActionHelper.forBookmark(100, this, item, bookmark);
        }
    }

    public void resetBookmarks() {
        if (this.bookmarkMenu != null) {
            int count = this.bookmarkMenu.getItemCount();
            while (count > 3) {
                this.bookmarkMenu.remove(--count);
            }
            Vector bookmarks = this.properties.bookmarks();
            for (int i = 0; i < bookmarks.size(); ++i) {
                Bookmark bookmark = (Bookmark)bookmarks.elementAt(i);
                this.addBookmarkItem(bookmark);
            }
        }
    }

    private Viewport currentFrameView() {
        Viewport view = null;
        if (this.currentFrameId != null) {
            view = this.mainview.findViewportByName(this.currentFrameId);
        }
        if (view == null) {
            view = this.mainview;
        }
        return view;
    }

    void closeWindow() {
        this.mainview.removePropertyChangeListener(this);
        this.searchBar.dispose();
        if (this.throbberThread != null && !this.throbberThread.isInterrupted()) {
            this.throbberThread.interrupt();
        }
        this.windowManager.storm.closeViewport(this.mainview.getId());
    }

    void reload() {
        this.windowManager.storm.getHistoryManager().reload(this.mainview.getId());
    }

    void htmlInterrupt() {
        this.windowManager.storm.stopLoading(this.mainview.getId());
    }

    Reader getHTMLSource() throws IOException {
        Viewport view = this.currentFrameView();
        InputStream is = new URL(view.getLocation()).openStream();
        String charset = null;
        InputStreamReader r = charset == null ? new InputStreamReader(is) : new InputStreamReader(is, charset);
        return new BufferedReader(r);
    }

    String getDocumentTitle() {
        Viewport view = this.currentFrameView();
        Pilot tmp = view.getPilot();
        if (tmp instanceof ice.pilots.html4.ThePilot) {
            ice.pilots.html4.ThePilot pilot = (ice.pilots.html4.ThePilot)tmp;
            HTMLDocument doc = (HTMLDocument)pilot.getDocument();
            return doc.getTitle();
        }
        return "";
    }

    String getCurrentLocation() {
        return this.currentFrameView().getLocation();
    }

    String getEncoding() {
        Viewport view = this.currentFrameView();
        Pilot tmp = view.getPilot();
        if (tmp instanceof ice.pilots.html4.ThePilot) {
            ice.pilots.html4.ThePilot pilot = (ice.pilots.html4.ThePilot)tmp;
            return pilot.getEncoding();
        }
        return "";
    }

    void setEncoding(String encoding) {
        Viewport view = this.currentFrameView();
        Pilot tmp = view.getPilot();
        if (tmp instanceof ice.pilots.html4.ThePilot) {
            ice.pilots.html4.ThePilot pilot = (ice.pilots.html4.ThePilot)tmp;
            pilot.setEncoding(encoding);
        }
    }

    boolean displayRenderTimes() {
        return this.properties.getBoolean("statusbar.displayRenderTimes", false);
    }

    boolean isSelectionActive() {
        boolean active = false;
        ice.pilots.html4.ThePilot pilot = this.getActiveViewportPilot();
        if (pilot != null) {
            active = pilot.isSelectionActive();
        }
        return active;
    }

    String getSelectedText() {
        String selText = null;
        ice.pilots.html4.ThePilot pilot = this.getActiveViewportPilot();
        if (pilot != null) {
            selText = pilot.getSelectedText();
        }
        return selText;
    }

    private ice.pilots.html4.ThePilot getActiveViewportPilot() {
        Pilot p;
        Viewport vp = this.windowManager.storm.getActiveViewport();
        if (vp != null && (p = vp.getPilot()) instanceof ice.pilots.html4.ThePilot) {
            return (ice.pilots.html4.ThePilot)p;
        }
        return null;
    }

    void pasteText(String text) {
        block2: {
            try {
                Robot rbt = new Robot();
                rbt.keyPress(17);
                rbt.keyPress(86);
            }
            catch (AWTException e) {
                if (!Debug.ex) break block2;
                Debug.ex(e);
            }
        }
    }

    void displayPageSetupDialog() {
        StormPageFormat stormPageFormat = this.windowManager.getStormPageFormat();
        PageSetupDialog pageSetup = new PageSetupDialog(this, this.mainview, stormPageFormat);
        stormPageFormat = pageSetup.showDialog();
        this.windowManager.setStormPageFormat(stormPageFormat);
    }

    void displayPrintPreviewDialog() {
        StormPrinter mainViewPrinter = this.mainview.getPilot().createPrinter();
        if (mainViewPrinter == null) {
            JOptionPane.showMessageDialog(this, this.res.str("print.notsupported.text"), this.res.str("print.notsupported.title"), 2);
        } else {
            mainViewPrinter.dispose();
            Container topLevelContainer = this.browserContainer;
            Component[] tempViewports = topLevelContainer.getComponents();
            LayoutManager oldLayout = topLevelContainer.getLayout();
            Image pageImage = topLevelContainer.createImage(topLevelContainer.getWidth(), topLevelContainer.getHeight());
            Graphics imageGraphics = pageImage.getGraphics();
            topLevelContainer.paintComponents(imageGraphics);
            topLevelContainer.removeAll();
            topLevelContainer.setLayout(new BorderLayout());
            JLabel snapShot = new JLabel(new ImageIcon(pageImage));
            topLevelContainer.add((Component)snapShot, "Center");
            topLevelContainer.validate();
            topLevelContainer.repaint();
            PrintPreviewDialog d = new PrintPreviewDialog(this, this.mainview, this.windowManager.getStormPageFormat());
            this.windowManager.setStormPageFormat(d.showDialog());
            topLevelContainer.remove(snapShot);
            imageGraphics.dispose();
            topLevelContainer.setLayout(oldLayout);
            for (int i = 0; i < tempViewports.length; ++i) {
                topLevelContainer.add(tempViewports[i]);
            }
            d.dispose();
        }
    }

    void printViewport() {
        StormPrinter mainViewPrinter = this.mainview.getPilot().createPrinter();
        if (mainViewPrinter == null) {
            JOptionPane.showMessageDialog(this, this.res.str("print.notsupported.text"), this.res.str("print.notsupported.title"), 2);
        } else {
            mainViewPrinter.dispose();
            Container topLevelContainer = this.browserContainer;
            Component[] tempViewports = topLevelContainer.getComponents();
            LayoutManager oldLayout = topLevelContainer.getLayout();
            Image pageImage = topLevelContainer.createImage(topLevelContainer.getWidth(), topLevelContainer.getHeight());
            Graphics imageGraphics = pageImage.getGraphics();
            topLevelContainer.paintComponents(imageGraphics);
            topLevelContainer.removeAll();
            topLevelContainer.setLayout(new BorderLayout());
            JLabel snapShot = new JLabel(new ImageIcon(pageImage));
            topLevelContainer.add((Component)snapShot, "Center");
            topLevelContainer.validate();
            RepaintManager currentManager = RepaintManager.currentManager(this.browserContainer);
            currentManager.setDoubleBufferingEnabled(false);
            PrintHelper printHelper = PrintUtilities.getPrintHelper(this.mainview, this.windowManager.getStormPageFormat());
            printHelper.print(this);
            currentManager.setDoubleBufferingEnabled(true);
            topLevelContainer.remove(snapShot);
            imageGraphics.dispose();
            topLevelContainer.setLayout(oldLayout);
            for (int i = 0; i < tempViewports.length; ++i) {
                topLevelContainer.add(tempViewports[i]);
            }
            topLevelContainer.validate();
        }
    }

    boolean hasBackHistory() {
        return this.windowManager.storm.getHistoryManager().canGoBack(this.mainview.getId());
    }

    boolean hasForwardHistory() {
        return this.windowManager.storm.getHistoryManager().canGoForward(this.mainview.getId());
    }

    void goBack() {
        if (this.hasBackHistory()) {
            this.windowManager.storm.getHistoryManager().goBack(this.mainview.getId());
        }
    }

    void goForward() {
        if (this.hasForwardHistory()) {
            this.windowManager.storm.getHistoryManager().goForward(this.mainview.getId());
        }
    }

    void copy() {
        if (this.isSelectionActive()) {
            String selTxt = this.getSelectedText();
            Clipboard clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection sel = new StringSelection(selTxt);
            clipBoard.setContents(sel, sel);
        }
    }

    void paste() {
        Pilot thePilot;
        if (this.mainview != null && (thePilot = this.mainview.getPilot()) != null) {
            Component c = this.mainview.getPilotComponent();
            c.requestFocus();
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new KeyEvent(c, 401, System.currentTimeMillis(), 0, 65487));
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new KeyEvent(c, 402, System.currentTimeMillis(), 0, 65487));
        }
    }

    void gotoLocation(String loc) {
        this.windowManager.storm.renderContent(loc, null, this.currentFrameView().getId());
    }

    void gotoLocation(String loc, String targetFrame, String outputString) {
        if (targetFrame == null) {
            this.gotoLocation(loc);
        } else {
            Viewport view = this.mainview.findViewportByName(targetFrame);
            if (view != null) {
                this.currentFrameId = view.getId();
            }
            this.windowManager.storm.renderContent(loc, null, targetFrame);
        }
    }

    void setActivityThrobberStatus(boolean animate) {
        this.throbber.setAnimationStatus(animate);
    }

    void updateUserFonts() {
        String cssFixedFont;
        String cssProportionalFont;
        StringBuffer sb = new StringBuffer(50);
        Font fprop = this.properties.getFont("document.proportionalfont");
        if (fprop != null) {
            WindowManager.fontToCssStyle(fprop, sb);
            cssProportionalFont = sb.toString();
        } else {
            cssProportionalFont = null;
        }
        Font ffixed = this.properties.getFont("document.fixedfont");
        if (ffixed != null) {
            sb.setLength(0);
            WindowManager.fontToCssStyle(ffixed, sb);
            cssFixedFont = sb.toString();
        } else {
            cssFixedFont = null;
        }
        Vector views = new Vector();
        this.mainview.getViewAndAllChildren(views);
        int n = views.size();
        for (int i = 0; i != n; ++i) {
            Viewport v = (Viewport)views.elementAt(i);
            Pilot p = v.getPilot();
            if (p instanceof ice.pilots.html4.ThePilot) {
                ice.pilots.html4.ThePilot ph = (ice.pilots.html4.ThePilot)p;
                DDocument doc = (DDocument)ph.getDocument();
                if (cssProportionalFont != null && doc != null) {
                    doc.getBody().setAttribute("style", cssProportionalFont);
                }
                if (cssFixedFont != null) {
                    this.applyStyleToAll(doc, "PRE", cssFixedFont);
                    this.applyStyleToAll(doc, "CODE", cssFixedFont);
                    this.applyStyleToAll(doc, "TT", cssFixedFont);
                }
                ph.refresh();
                continue;
            }
            if (!(p instanceof ThePilot) || ffixed == null) continue;
            ((ThePilot)p).setFont(ffixed);
        }
    }

    private void applyStyleToAll(DDocument doc, String tag, String style) {
        DNodeList list = (DNodeList)doc.getElementsByTagName(tag);
        int n = list.getLength();
        for (int i = 0; i != n; ++i) {
            DElement elem = (DElement)list.item(i);
            elem.setAttribute("style", style);
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        Viewport view;
        Pilot pilot;
        Object value;
        String name = ev.getPropertyName();
        if (name.equals("title")) {
            if (this.isTopFrameEvent(ev)) {
                this.urlTitle = (String)ev.getNewValue();
                if (SwingUtilities.isEventDispatchThread()) {
                    this.setTitle(this.defaultTitle + " - " + this.urlTitle);
                } else {
                    Runnable doSwingWork = new Runnable(){

                        public void run() {
                            BrowserWindow.this.setTitle(BrowserWindow.this.defaultTitle + " - " + BrowserWindow.this.urlTitle);
                        }
                    };
                    SwingUtilities.invokeLater(doSwingWork);
                }
            }
        } else if (name.equals("contentLoading")) {
            String s = (String)ev.getNewValue();
            if (s.equals("error")) {
                ContentLoader cl = (ContentLoader)ev.getOldValue();
                Viewport view2 = (Viewport)ev.getSource();
                if (cl != null) {
                    URL url = cl.getURL();
                    IOException ex = cl.getException();
                    String message = url.toExternalForm() + " - " + ex.getMessage();
                    message = ex instanceof UnknownHostException || ex instanceof MalformedURLException ? this.res.str("url.unknownhost", url.getHost()) : (ex instanceof NoRouteToHostException || ex instanceof SocketException ? this.res.str("url.noroute_error", url.getHost(), ex.getMessage()) : this.res.str("url.open_error", url.toString()));
                    this.showErrorPage(view2, message);
                }
            }
        } else if (name.equals("contentRendering")) {
            String val = (String)ev.getNewValue();
            if (val.equals("finished") && this.isTopFrameEvent(ev)) {
                if (this.winActive) {
                    Viewport view3 = (Viewport)ev.getSource();
                    Pilot pilot2 = view3.getPilot();
                    if (pilot2 != null) {
                        pilot2.getDocPane().reqFocus();
                    }
                } else {
                    this.moveFocusToDocPane = true;
                }
            }
        } else if (name.equals("pilotLoading") && "end".equals(value = ev.getNewValue()) && (pilot = (view = (Viewport)ev.getSource()).getPilot()) instanceof ice.pilots.html4.ThePilot) {
            new MouseListener(this, (ice.pilots.html4.ThePilot)pilot);
        }
    }

    private void showErrorPage(Viewport view, String message) {
        try {
            String temp;
            URL errorURL = this.res.errorURL(ERROR_PAGE_NAME);
            StringBuffer pageBuff = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(errorURL.openStream()));
            while (reader.ready() && (temp = reader.readLine()) != null) {
                pageBuff.append(temp);
            }
            reader.close();
            String page = pageBuff.toString();
            URL logoURL = this.res.imageURL(LOGO_PLACEHOLDER);
            if (logoURL != null) {
                page = this.replace(page, LOGO_PLACEHOLDER, logoURL.toString());
            }
            page = this.replace(page, ERROR_PLACEHOLDER, message);
            ByteArrayInputStream bais = new ByteArrayInputStream(page.getBytes());
            ContentLoader loader = new ContentLoader(null, bais, "text/html");
            this.windowManager.storm.renderContent(loader, view.getId());
        }
        catch (IOException e) {
            if (Debug.ex) {
                Debug.ex(e);
            }
            this.show_connection_report(view, message);
        }
    }

    private String replace(String page, String placeholder, String replacement) {
        int start = page.indexOf(placeholder);
        if (start >= 0) {
            StringBuffer pageBuff = new StringBuffer();
            pageBuff.append(page.substring(0, start));
            pageBuff.append(replacement);
            pageBuff.append(page.substring(start + placeholder.length()));
            page = pageBuff.toString();
        }
        return page;
    }

    boolean isTopFrameEvent(PropertyChangeEvent event) {
        Object esObj = event.getSource();
        return esObj instanceof Viewport && ((Viewport)esObj).getName().equals(this.mainview.getName());
    }

    boolean isActiveFrameEvent(PropertyChangeEvent event) {
        return event.getSource() == this.currentFrameView();
    }

    private HTMLAnchorElement getLinkElement(Event event) {
        EventTarget target = event.getTarget();
        if (target instanceof Node) {
            Node n = (Node)((Object)target);
            do {
                HTMLAnchorElement anchor;
                String href;
                if (!(n instanceof HTMLAnchorElement) || (href = (anchor = (HTMLAnchorElement)n).getHref()) == null) continue;
                return anchor;
            } while ((n = n.getParentNode()) != null);
        }
        return null;
    }

    void handleMouseEvent(Component c, MouseEvent event) {
        short button;
        HTMLAnchorElement anchor = this.getLinkElement(event);
        if (this.statusBar != null) {
            this.statusBar.onMouseEvent(event, anchor);
        }
        if (event.getType().equals("contextmenu")) {
            if (this.mouseManager != null) {
                this.mouseManager.onContextMenu(c, event, anchor);
            }
        } else if (event.getType().equals("mouseup") && (button = event.getButton()) == 1 && anchor != null) {
            this.windowManager.newWindow(anchor.getHref());
        }
    }

    private void show_connection_report(Viewport view, String text) {
        String msg = "<html><body><H4>" + text + "<BR></H4></body></html>";
        ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes());
        ContentLoader newLoader = new ContentLoader(null, is, "text/html");
        this.windowManager.storm.renderContent(newLoader, view.getId());
    }

    void disposeTopLevelContainer() {
        this.windowManager.disposeTopLevelContainer(this);
        this.mainview.removeProperty(BROWSER_PANEL_KEY);
    }

    static void disposeTopLevelContainer(Viewport viewport) {
        ((BrowserWindow)viewport.getProperty(BROWSER_PANEL_KEY)).disposeTopLevelContainer();
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.closeWindow();
        }
        super.processWindowEvent(e);
    }

    void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        if (this.mouseManager != null) {
            this.mouseManager.updateUI();
        }
    }
}

