/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DTextAreaElement;
import ice.pilots.html4.swing.DocView;
import ice.util.Defs;
import java.awt.AWTEvent;
import java.awt.FontMetrics;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JTextArea;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class MyTextArea
extends JTextArea
implements EventListener {
    private DocView docView;
    private DTextAreaElement text;
    private String startValue;

    MyTextArea(int rows, int cols, DocView docView, DTextAreaElement text) {
        super(rows, cols);
        this.docView = docView;
        this.text = text;
        this.setLineWrap(true);
        this.validateTree();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    protected void processEvent(AWTEvent e) {
        MyTextArea action = null;
        int id = e.getID();
        if (id == 401 || id == 402) {
            KeyEvent ke = (KeyEvent)e;
            int kc = ke.getKeyCode();
            if (kc == 38 || kc == 40 || kc == 39 || kc == 37 || kc == 36 || kc == 35 || kc == 33 || kc == 34) {
                action = this;
            } else if (kc == 9) {
                ke.consume();
            } else {
                super.processEvent(e);
            }
        }
        if (this.docView.onComponentEvent(this, e, action)) {
            FocusEvent fe;
            super.processEvent(e);
            if (id == 1004) {
                if (this.startValue == null) {
                    this.startValue = this.getText();
                }
            } else if (id == 1005 && !(fe = (FocusEvent)e).isTemporary()) {
                String tmp = this.getText();
                if (!tmp.equals(this.startValue)) {
                    this.text.dispatchChange();
                }
                this.startValue = null;
            }
        }
    }

    public void handleEvent(Event event) {
        DOMEvent de = (DOMEvent)event;
        super.processEvent((AWTEvent)de.getSystemEvent());
        de.setDefaultDone();
    }

    protected int getColumnWidth() {
        String widthChar = Defs.sysProperty("ice.pilots.html4.colWidthChar", "o");
        if (widthChar == null || widthChar.length() != 1) {
            return super.getColumnWidth();
        }
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        return metrics.charWidth(widthChar.charAt(0));
    }
}

