/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.awt;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.awt.DocView;
import ice.pilots.html4.awt.Movable;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

class FormSelectChoice
extends Choice
implements Runnable,
DSelectElement.SelectPainter,
ItemListener,
Movable,
EventListener {
    private DocView docView;
    private DSelectElement sel;
    private ObjectBox box;
    private boolean ignoreItemChange;
    private boolean tempSelection = false;
    boolean onMyWay = false;

    FormSelectChoice(DocView docView, DElement e) {
        this.docView = docView;
        this.sel = (DSelectElement)e;
        this.copyOptionsToView();
        this.enableEvents(60L);
        this.addItemListener(this);
    }

    private void copyOptionsToView() {
        int i;
        int n = this.getItemCount();
        DOptionElement opt = this.sel.firstDOption();
        for (i = 0; i < n && opt != null; ++i) {
            String s1 = this.getItem(i);
            String s2 = opt.getTextOrEmptyString();
            if (s1.length() != s2.length() || !s1.equals(s2)) break;
            opt = this.sel.nextDOption(opt);
        }
        if (i != n || opt != null) {
            this.ignoreItemChange = true;
            this.removeAll();
            opt = this.sel.firstDOption();
            i = 0;
            while (opt != null) {
                this.addItem(opt.getTextOrEmptyString());
                opt = this.sel.nextDOption(opt);
                ++i;
            }
            this.checkAttributes();
            this.ignoreItemChange = false;
        }
        this.updateSelection();
    }

    private void updateSelection() {
        this.ignoreItemChange = true;
        int index = this.sel.getSelectedIndex();
        if (index >= 0 && index < this.getItemCount()) {
            this.select(index);
        }
        this.ignoreItemChange = false;
    }

    private void checkAttributes() {
        this.setEnabled(!this.sel.getDisabled());
    }

    public void itemStateChanged(ItemEvent e) {
        if (!this.ignoreItemChange && !this.tempSelection) {
            this.sel.setSelectedIndexByUser(this.getSelectedIndex());
        }
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
    }

    public void run() {
        this.onMyWay = false;
        this.copyOptionsToView();
    }

    public void onOptionStructChange() {
        if (!this.onMyWay) {
            this.onMyWay = true;
            this.docView.getPilot().getStorm().runOnEventThreadLater(this, 100L);
        }
    }

    public void onOptionSelectionChange() {
        this.updateSelection();
    }

    public void onOptionAttrChange(DOptionElement opt, DAttr attr) {
        int i = this.sel.getOptionIndex(opt);
        if (i >= 0 && i < this.getItemCount()) {
            this.ignoreItemChange = true;
            String s = opt.getLabel();
            if (s != null && !this.getItem(i).equals(s)) {
                this.remove(i);
                this.insert(s, i);
                this.box.invalidate();
                this.box.reqReflow();
            }
            this.ignoreItemChange = false;
        }
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
        if (box != null) {
            this.copyOptionsToView();
        }
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            return;
        }
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int x, int y, boolean visible) {
        super.doLayout();
        this.setLocation(x, y);
        this.setVisible(visible);
    }

    protected void processEvent(AWTEvent e) {
        MouseEvent me;
        FormSelectChoice action = null;
        if (e instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)e;
            int keyCode = ke.getKeyCode();
            if (keyCode == 38 || keyCode == 40) {
                this.tempSelection = true;
                action = this;
            }
            if ((keyCode == 9 || keyCode == 10) && this.tempSelection) {
                this.sel.setSelectedIndexByUser(this.getSelectedIndex());
                this.tempSelection = false;
            }
        }
        if (e instanceof MouseEvent && (me = (MouseEvent)e).getID() == 500) {
            this.tempSelection = false;
        }
        if (this.docView.onComponentEvent(this, e, action)) {
            super.processEvent(e);
        }
    }

    public void handleEvent(Event event) {
        if (((DOMEvent)event).getTypeId() == 22) {
            return;
        }
        DOMUIEvent de = (DOMUIEvent)event;
        super.processEvent((AWTEvent)de.getSystemEvent());
        de.setDefaultDone();
    }

    public void setFont(Font f) {
        Container parent = this.getParent();
        parent.remove(this);
        super.setFont(f);
        parent.add(this);
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
        Font f = css.getFont();
        if (!f.equals(this.getFont())) {
            this.setFont(f);
        }
    }

    public int getClientHeight() {
        return this.getSize().height;
    }

    public int getClientWidth() {
        return this.getSize().width - this.docView.vbar.getSize().width;
    }
}

