/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.LineMetricValue;
import ice.util.UnsupportedOperationException;

public class LineBox {
    public int _inheritedContentHeight;
    boolean _normalized;
    private int normalizedBaseline;
    private LineMetricValue[] _chunks;
    private static final int CHUNK_ALLOCATION = 3;
    private int _topOfLineBox = Integer.MAX_VALUE;
    private int _bottomOfLineBox = Integer.MIN_VALUE;
    private int _superscriptHackValue;
    private int _subscriptHackValue;
    private int _lmIndex;
    static int _passes;
    static int _expansions;

    LineBox() {
        this._chunks = new LineMetricValue[3];
    }

    void treatInlineBox(long aLineParameters, int aBoxId, int aVerticalAlignment) {
        if (aLineParameters == 0L) {
            return;
        }
        LineMetricValue cv = new LineMetricValue();
        cv.boxId = aBoxId;
        cv.verticalAlign = aVerticalAlignment;
        int lineHeight = CSSBox.unwrapLineHeight(aLineParameters);
        int ascent = CSSBox.unwrapAscent(aLineParameters);
        int descent = CSSBox.unwrapDescent(aLineParameters);
        if (lineHeight == 0) {
            lineHeight = ascent + descent;
        }
        int halfLeading = 0;
        if (lineHeight > 0) {
            halfLeading = Math.round((float)(ascent + descent - lineHeight) / 2.0f);
        }
        switch (aVerticalAlignment) {
            case 140: {
                cv.topOfContent = -ascent;
                cv.topOfInline = cv.topOfContent + halfLeading;
                cv.bottomOfInline = cv.topOfInline + lineHeight;
                cv.bottomOfContent = descent;
                if (cv.topOfInline < this._topOfLineBox) {
                    this._topOfLineBox = cv.topOfInline;
                }
                if (cv.bottomOfInline <= this._bottomOfLineBox) break;
                this._bottomOfLineBox = cv.bottomOfInline;
                break;
            }
            case 16: {
                cv.topOfContent = -halfLeading;
                cv.topOfInline = 0;
                cv.bottomOfInline = lineHeight;
                cv.bottomOfContent = cv.bottomOfInline + halfLeading;
                break;
            }
            case 144: {
                int height = ascent + descent;
                cv.topOfContent = this._inheritedContentHeight != 0 ? Math.round(-((float)this._inheritedContentHeight / 3.0f) - (float)height / 2.0f) : Math.round(-(height / 5) - height / 2);
                cv.topOfInline = cv.topOfContent + halfLeading;
                cv.bottomOfInline = cv.topOfInline + lineHeight;
                cv.bottomOfContent = cv.bottomOfInline + halfLeading;
                if (cv.topOfInline < this._topOfLineBox) {
                    this._topOfLineBox = cv.topOfInline;
                }
                if (cv.bottomOfInline <= this._bottomOfLineBox) break;
                this._bottomOfLineBox = cv.bottomOfInline;
                break;
            }
            case 17: {
                cv.topOfContent = -ascent;
                cv.topOfInline = cv.topOfContent + halfLeading;
                cv.bottomOfInline = cv.topOfInline + lineHeight;
                cv.bottomOfContent = descent;
                break;
            }
            case 145: {
                cv.bottomOfInline = Math.round((float)this._inheritedContentHeight / 4.0f);
                cv.bottomOfContent = cv.bottomOfInline + halfLeading;
                cv.topOfInline = cv.bottomOfInline - lineHeight;
                cv.topOfContent = cv.topOfInline - halfLeading;
                if (cv.topOfInline < this._topOfLineBox) {
                    this._topOfLineBox = cv.topOfInline;
                }
                if (cv.bottomOfInline <= this._bottomOfLineBox) break;
                this._bottomOfLineBox = cv.bottomOfInline;
                break;
            }
            case 143: {
                cv.topOfContent = -Math.round((float)this._inheritedContentHeight * 4.0f / 5.0f);
                cv.topOfInline = cv.topOfContent + halfLeading;
                cv.bottomOfInline = cv.topOfInline + lineHeight;
                cv.bottomOfContent = cv.bottomOfInline + halfLeading;
                if (cv.bottomOfInline > this._bottomOfLineBox) {
                    this._bottomOfLineBox = cv.bottomOfInline;
                }
                if (cv.topOfInline >= this._topOfLineBox) break;
                this._topOfLineBox = cv.topOfInline;
                break;
            }
            case 141: 
            case 142: {
                int value = this._inheritedContentHeight / 4;
                if (aVerticalAlignment == 142) {
                    this._superscriptHackValue = value;
                } else {
                    this._subscriptHackValue = value;
                }
                cv.topOfContent = -ascent;
                cv.topOfInline = cv.topOfContent + halfLeading;
                cv.bottomOfInline = cv.topOfInline + lineHeight;
                cv.bottomOfContent = descent;
                if (cv.bottomOfInline > this._bottomOfLineBox) {
                    this._bottomOfLineBox = cv.bottomOfInline;
                }
                if (cv.topOfInline >= this._topOfLineBox) break;
                this._topOfLineBox = cv.topOfInline;
                break;
            }
            default: {
                if (!Debug.trace) break;
                Debug.trace("Unsupported Vertical-align parameter: " + aVerticalAlignment);
            }
        }
        ++_passes;
        if (this._lmIndex == this._chunks.length) {
            LineMetricValue[] newChunks = new LineMetricValue[this._chunks.length * 2];
            System.arraycopy(this._chunks, 0, newChunks, 0, this._chunks.length);
            this._chunks = newChunks;
            ++_expansions;
        }
        this._chunks[this._lmIndex++] = cv;
    }

    public void doneLine() {
        if (this._lmIndex == 0) {
            this._bottomOfLineBox = 0;
            this._topOfLineBox = 0;
            this._normalized = true;
            return;
        }
        for (int idx = 0; idx < this._lmIndex; ++idx) {
            int height;
            if (this._chunks[idx].verticalAlign != 17 || (height = this._chunks[idx].bottomOfInline - this._chunks[idx].topOfInline) <= this._bottomOfLineBox - this._topOfLineBox) continue;
            this._topOfLineBox = this._bottomOfLineBox - height;
        }
        this._bottomOfLineBox -= this._topOfLineBox;
        block8: for (int idx = 0; idx < this._lmIndex; ++idx) {
            switch (this._chunks[idx].verticalAlign) {
                case 17: {
                    int adjustment = this._bottomOfLineBox - this._chunks[idx].bottomOfInline;
                    this._chunks[idx].topOfContent += adjustment;
                    this._chunks[idx].topOfInline += adjustment;
                    this._chunks[idx].bottomOfInline += adjustment;
                    this._chunks[idx].bottomOfContent += adjustment;
                    if (this._chunks[idx].bottomOfInline <= this._bottomOfLineBox) continue block8;
                    this._bottomOfLineBox = this._chunks[idx].bottomOfInline;
                    continue block8;
                }
                case 140: 
                case 143: 
                case 144: 
                case 145: {
                    this._chunks[idx].topOfContent -= this._topOfLineBox;
                    this._chunks[idx].topOfInline -= this._topOfLineBox;
                    this._chunks[idx].bottomOfInline -= this._topOfLineBox;
                    this._chunks[idx].bottomOfContent -= this._topOfLineBox;
                    continue block8;
                }
                case 141: {
                    this._chunks[idx].topOfContent -= this._topOfLineBox - this._subscriptHackValue;
                    this._chunks[idx].topOfInline -= this._topOfLineBox - this._subscriptHackValue;
                    this._chunks[idx].bottomOfInline -= this._topOfLineBox - this._subscriptHackValue;
                    this._chunks[idx].bottomOfContent -= this._topOfLineBox - this._subscriptHackValue;
                    continue block8;
                }
                case 142: {
                    this._chunks[idx].topOfContent -= this._topOfLineBox + this._superscriptHackValue;
                    this._chunks[idx].topOfInline -= this._topOfLineBox + this._superscriptHackValue;
                    this._chunks[idx].bottomOfInline -= this._topOfLineBox + this._superscriptHackValue;
                    this._chunks[idx].bottomOfContent -= this._topOfLineBox + this._superscriptHackValue;
                    continue block8;
                }
                case 16: {
                    if (this._chunks[idx].bottomOfInline <= this._bottomOfLineBox) continue block8;
                    this._bottomOfLineBox = this._chunks[idx].bottomOfInline;
                }
            }
        }
        this.normalizedBaseline = -this._topOfLineBox;
        this._topOfLineBox = 0;
        this._normalized = true;
    }

    public long getLineParameters() {
        if (!this._normalized) {
            throw new UnsupportedOperationException("Programmer error: LineBox not normalized");
        }
        long returnVal = CSSBox.wrapDescentAscent(0, 0, this._bottomOfLineBox);
        if (this._bottomOfLineBox < -300) {
            Debug.p("Warning, uninitialized bottom of lineBox");
        }
        return returnVal;
    }

    public int getYDeflectionOfChunk(int aBoxId) {
        for (int idx = 0; idx < this._chunks.length; ++idx) {
            if (this._chunks[idx] == null || this._chunks[idx].boxId != aBoxId) continue;
            return this._chunks[idx].topOfContent;
        }
        return 0;
    }

    public int getNormalizedBaseline() {
        if (!this._normalized) {
            throw new UnsupportedOperationException("Programmer error: LineBox not normalized");
        }
        return this.normalizedBaseline;
    }
}

