/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Viewport;
import ice.util.Defs;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class DOMEvent
extends DynamicObject
implements Event {
    private static final boolean ENABLE_FROM_TO_ELEM_SUPPORT = true;
    public static final int CLICK = 1;
    public static final int DBLCLICK = 2;
    public static final int MOUSEDOWN = 3;
    public static final int MOUSEUP = 4;
    public static final int MOUSEOVER = 5;
    public static final int MOUSEMOVE = 6;
    public static final int MOUSEOUT = 7;
    public static final int KEYPRESS = 8;
    public static final int KEYDOWN = 9;
    public static final int KEYUP = 10;
    public static final int RESIZE = 11;
    public static final int SCROLL = 12;
    public static final int LOAD = 13;
    public static final int UNLOAD = 14;
    public static final int ABORT = 15;
    public static final int ERROR = 16;
    public static final int SELECT = 17;
    public static final int CHANGE = 18;
    public static final int SUBMIT = 19;
    public static final int RESET = 20;
    public static final int FOCUS = 21;
    public static final int BLUR = 22;
    public static final int HELP = 23;
    public static final int CONTEXTMENU = 24;
    public static final int DOMSubtreeModified = 25;
    public static final int DOMNodeInserted = 26;
    public static final int DOMNodeRemoved = 27;
    public static final int DOMAttrModified = 28;
    public static final int CSSModified = 29;
    public static final int GOTO = 30;
    public static final int NUM_EVENTS = 31;
    protected DDocument doc;
    int typeId;
    long timestamp;
    DNode target;
    DNode currentNode;
    DNode nodeAfterMap;
    short eventPhase;
    boolean cancel = false;
    private boolean canceledDefault;
    protected DNode defaultActionTarget;
    int posX;
    int posY;
    DNode relatedNode;
    private EventListener _eventAction;
    private boolean _defaultDone;
    private Object _systemEvent;
    private static final int Field_bubbles = 1;
    private static final int Field_cancelable = 2;
    private static final int Field_cancelBubble = 3;
    private static final int Field_currentNode = 4;
    private static final int Field_currentTarget = 5;
    private static final int Field_eventPhase = 6;
    private static final int Field_fromElement = 7;
    private static final int Field_srcElement = 8;
    private static final int Field_target = 9;
    private static final int Field_timeStamp = 10;
    private static final int Field_toElement = 11;
    private static final int Field_type = 12;
    private static final int Method_initEvent = -1;
    private static final int Method_isDefaultCancelled = -2;
    private static final int Method_preventDefault = -3;
    private static final int Method_stopPropagation = -4;

    static int mapEventTypeToId(String s) {
        boolean Id_click = true;
        int Id_dblclick = 2;
        int Id_mousedown = 3;
        int Id_mouseup = 4;
        int Id_mouseover = 5;
        int Id_mousemove = 6;
        int Id_mouseout = 7;
        int Id_keypress = 8;
        int Id_keydown = 9;
        int Id_keyup = 10;
        int Id_resize = 11;
        int Id_scroll = 12;
        int Id_load = 13;
        int Id_unload = 14;
        int Id_abort = 15;
        int Id_error = 16;
        int Id_select = 17;
        int Id_change = 18;
        int Id_submit = 19;
        int Id_reset = 20;
        int Id_focus = 21;
        int Id_blur = 22;
        int Id_help = 23;
        int Id_contextmenu = 24;
        int Id_DOMSubtreeModified = 25;
        int Id_DOMNodeInserted = 26;
        int Id_DOMNodeRemoved = 27;
        int Id_DOMAttrModified = 28;
        int Id_CSSModified = 29;
        int Id_goto = 30;
        int id = 0;
        String X = null;
        block0 : switch (s.length()) {
            case 4: {
                char c = s.charAt(0);
                if (c == 'b') {
                    X = "blur";
                    id = 22;
                    break;
                }
                if (c == 'h') {
                    X = "help";
                    id = 23;
                    break;
                }
                if (c == 'l') {
                    X = "load";
                    id = 13;
                    break;
                }
                if (c != 'g') break;
                X = "goto";
                id = 30;
                break;
            }
            case 5: {
                switch (s.charAt(0)) {
                    case 'a': {
                        X = "abort";
                        id = 15;
                        break block0;
                    }
                    case 'c': {
                        X = "click";
                        id = 1;
                        break block0;
                    }
                    case 'e': {
                        X = "error";
                        id = 16;
                        break block0;
                    }
                    case 'f': {
                        X = "focus";
                        id = 21;
                        break block0;
                    }
                    case 'k': {
                        X = "keyup";
                        id = 10;
                        break block0;
                    }
                    case 'r': {
                        X = "reset";
                        id = 20;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (s.charAt(4)) {
                    case 'a': {
                        X = "unload";
                        id = 14;
                        break block0;
                    }
                    case 'c': {
                        X = "select";
                        id = 17;
                        break block0;
                    }
                    case 'g': {
                        X = "change";
                        id = 18;
                        break block0;
                    }
                    case 'i': {
                        X = "submit";
                        id = 19;
                        break block0;
                    }
                    case 'l': {
                        X = "scroll";
                        id = 12;
                        break block0;
                    }
                    case 'z': {
                        X = "resize";
                        id = 11;
                        break block0;
                    }
                }
                break;
            }
            case 7: {
                char c = s.charAt(0);
                if (c == 'k') {
                    X = "keydown";
                    id = 9;
                    break;
                }
                if (c != 'm') break;
                X = "mouseup";
                id = 4;
                break;
            }
            case 8: {
                char c = s.charAt(0);
                if (c == 'd') {
                    X = "dblclick";
                    id = 2;
                    break;
                }
                if (c == 'k') {
                    X = "keypress";
                    id = 8;
                    break;
                }
                if (c != 'm') break;
                X = "mouseout";
                id = 7;
                break;
            }
            case 9: {
                char c = s.charAt(5);
                if (c == 'd') {
                    X = "mousedown";
                    id = 3;
                    break;
                }
                if (c == 'm') {
                    X = "mousemove";
                    id = 6;
                    break;
                }
                if (c != 'o') break;
                X = "mouseover";
                id = 5;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'C') {
                    X = "CSSModified";
                    id = 29;
                    break;
                }
                if (c != 'c') break;
                X = "contextmenu";
                id = 24;
                break;
            }
            case 14: {
                X = "DOMNodeRemoved";
                id = 27;
                break;
            }
            case 15: {
                char c = s.charAt(3);
                if (c == 'A') {
                    X = "DOMAttrModified";
                    id = 28;
                    break;
                }
                if (c != 'N') break;
                X = "DOMNodeInserted";
                id = 26;
                break;
            }
            case 18: {
                X = "DOMSubtreeModified";
                id = 25;
                break;
            }
        }
        if (X != null && X != s && !X.equals(s)) {
            id = 0;
        }
        if (id == 0) {
            id = -1;
        }
        return id;
    }

    static String mapEventIdToType(int id) {
        switch (id) {
            case 1: {
                return "click";
            }
            case 2: {
                return "dblclick";
            }
            case 3: {
                return "mousedown";
            }
            case 4: {
                return "mouseup";
            }
            case 5: {
                return "mouseover";
            }
            case 6: {
                return "mousemove";
            }
            case 7: {
                return "mouseout";
            }
            case 8: {
                return "keypress";
            }
            case 9: {
                return "keydown";
            }
            case 10: {
                return "keyup";
            }
            case 11: {
                return "resize";
            }
            case 12: {
                return "scroll";
            }
            case 13: {
                return "load";
            }
            case 14: {
                return "unload";
            }
            case 15: {
                return "abort";
            }
            case 16: {
                return "error";
            }
            case 17: {
                return "select";
            }
            case 18: {
                return "change";
            }
            case 19: {
                return "submit";
            }
            case 20: {
                return "reset";
            }
            case 21: {
                return "focus";
            }
            case 22: {
                return "blur";
            }
            case 23: {
                return "help";
            }
            case 24: {
                return "contextmenu";
            }
            case 25: {
                return "DOMSubtreeModified";
            }
            case 26: {
                return "DOMNodeInserted";
            }
            case 27: {
                return "DOMNodeRemoved";
            }
            case 28: {
                return "DOMAttrModified";
            }
            case 29: {
                return "CSSModified";
            }
            case 30: {
                return "goto";
            }
        }
        return null;
    }

    static String internType(String name) {
        return DOMEvent.mapEventIdToType(DOMEvent.mapEventTypeToId(name));
    }

    static boolean canBubbleEvent(int type) {
        switch (type) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return true;
            }
            case 16: {
                return true;
            }
            case 17: {
                return true;
            }
            case 18: {
                return true;
            }
            case 19: {
                return true;
            }
            case 20: {
                return true;
            }
            case 21: {
                return false;
            }
            case 22: {
                return false;
            }
            case 23: {
                return false;
            }
            case 24: {
                return true;
            }
            case 30: {
                return false;
            }
        }
        return false;
    }

    static boolean canCancelEvent(int type) {
        switch (type) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return false;
            }
            case 7: {
                return true;
            }
            case 8: {
                return true;
            }
            case 9: {
                return true;
            }
            case 10: {
                return true;
            }
            case 11: {
                return false;
            }
            case 12: {
                return false;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            case 15: {
                return false;
            }
            case 16: {
                return false;
            }
            case 17: {
                return false;
            }
            case 18: {
                return false;
            }
            case 19: {
                return true;
            }
            case 20: {
                return false;
            }
            case 21: {
                return false;
            }
            case 22: {
                return false;
            }
            case 23: {
                return true;
            }
            case 24: {
                return true;
            }
            case 30: {
                return false;
            }
        }
        return false;
    }

    protected DOMEvent(DDocument doc, int id) {
        this.doc = doc;
        this.typeId = id;
        this.timestamp = System.currentTimeMillis();
    }

    public final DDocument getDDocument() {
        return this.doc;
    }

    public final Viewport getViewport() {
        return this.doc.pilot.getPilotViewport();
    }

    protected void copyUIDataFrom(DOMEvent source) {
        this.target = source.target;
        this.currentNode = source.currentNode;
        this.nodeAfterMap = source.nodeAfterMap;
        this.defaultActionTarget = source.defaultActionTarget;
        this.posX = source.posX;
        this.posY = source.posY;
        this.relatedNode = source.relatedNode;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getType() {
        return DOMEvent.mapEventIdToType(this.typeId);
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public EventTarget getCurrentTarget() {
        return this.currentNode;
    }

    public short getEventPhase() {
        return this.eventPhase;
    }

    public boolean getBubbles() {
        return DOMEvent.canBubbleEvent(this.typeId);
    }

    public boolean getCancelable() {
        return DOMEvent.canCancelEvent(this.typeId);
    }

    public void stopPropagation() {
        this.cancel = true;
    }

    public void preventDefault() {
        if (!this.canceledDefault && this.getCancelable()) {
            this.canceledDefault = true;
        }
    }

    public void initEvent(String eventTypeArg, boolean canBubbleArg, boolean cancelableArg) {
    }

    void setTarget(DNode node) {
        this.target = node;
    }

    void setCurrentNode(Node node) {
        this.currentNode = (DNode)node;
    }

    void setEventPhase(short eventPhase) {
        this.eventPhase = eventPhase;
    }

    public boolean isDefaultCancelled() {
        return this.canceledDefault;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String toString() {
        return "[event " + this.getType() + "]";
    }

    private DNode getSrcElement() {
        DNode a;
        for (a = this.target; a != null && !(a instanceof DElement); a = a.getParentDNode()) {
        }
        return a;
    }

    private DNode getToElement() {
        DNode result = this.target;
        if (this.typeId == 7) {
            result = this.relatedNode;
        }
        return result;
    }

    private DNode getFromElement() {
        DNode result = this.target;
        if (this.typeId == 5) {
            result = this.relatedNode;
        }
        return result;
    }

    private void setCancelBubble(boolean flag) {
        this.cancel = flag;
    }

    private boolean getCancelBubble() {
        return this.cancel;
    }

    EventListener getAction() {
        return this._eventAction;
    }

    void setAction(EventListener action) {
        if (action == null) {
            Defs.badArg();
        }
        if (this._eventAction != null) {
            Defs.badArg();
        }
        this._eventAction = action;
    }

    public boolean isDefaultDone() {
        return this._defaultDone;
    }

    public void setDefaultDone() {
        this._defaultDone = true;
    }

    public Object getSystemEvent() {
        return this._systemEvent;
    }

    public void setSystemEvent(Object event) {
        if (event == null) {
            Defs.badArg();
        }
        if (this._systemEvent != null) {
            Defs.badArg();
        }
        this._systemEvent = event;
    }

    public Object getDynamicValue(String name, DynEnv env) {
        int id = DOMEvent.toDynamicId(name);
        if (id < 0) {
            return env.wrapMethod(this, name);
        }
        if (id > 0) {
            return this.getDynamicValue(id, env);
        }
        return super.getDynamicValue(name, env);
    }

    public int setDynamicValue(String name, Object value, DynEnv env) {
        int id = DOMEvent.toDynamicId(name);
        if (id < 0) {
            return 2;
        }
        if (id > 0) {
            return this.setDynamicValue(id, value, env);
        }
        return super.setDynamicValue(name, value, env);
    }

    public Object execDynamicMethod(String name, Object[] args, DynEnv env) {
        int id = DOMEvent.toDynamicId(name);
        if (id < 0) {
            return this.execDynamicMethod(id, args, env);
        }
        return super.execDynamicMethod(name, args, env);
    }

    private Object getDynamicValue(int key_id, DynEnv env) {
        switch (key_id) {
            case 1: {
                return env.wrapBoolean(this.getBubbles());
            }
            case 2: {
                return env.wrapBoolean(this.getCancelable());
            }
            case 3: {
                return env.wrapBoolean(this.getCancelBubble());
            }
            case 4: {
                return this.getCurrentNode();
            }
            case 5: {
                return this.getCurrentTarget();
            }
            case 6: {
                return env.wrapInt(this.getEventPhase());
            }
            case 7: {
                return this.getFromElement();
            }
            case 8: {
                return this.getSrcElement();
            }
            case 9: {
                return this.getTarget();
            }
            case 10: {
                return env.wrapLong(this.getTimeStamp());
            }
            case 11: {
                return this.getToElement();
            }
            case 12: {
                return this.getType();
            }
        }
        return null;
    }

    private int setDynamicValue(int key_id, Object value, DynEnv env) {
        switch (key_id) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 1;
            }
            case 3: {
                this.setCancelBubble(env.toBoolean(value));
                return 1;
            }
            case 6: {
                this.setEventPhase(env.toShort(value));
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                this.setTarget((DNode)env.toNative(value));
                return 1;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 1;
            }
            case 12: {
                return 1;
            }
        }
        return 2;
    }

    private Object execDynamicMethod(int key_id, Object[] args, DynEnv env) {
        switch (key_id) {
            case -1: {
                String eventTypeArg = env.toStr(args, 0);
                boolean canBubbleArg = env.toBoolean(args, 1);
                boolean cancelableArg = env.toBoolean(args, 2);
                this.initEvent(eventTypeArg, canBubbleArg, cancelableArg);
                break;
            }
            case -2: {
                return env.wrapBoolean(this.isDefaultCancelled());
            }
            case -3: {
                this.preventDefault();
                break;
            }
            case -4: {
                this.stopPropagation();
            }
        }
        return env.wrapVoid();
    }

    private static int toDynamicId(String s) {
        int id = 0;
        String guess = null;
        switch (s.length()) {
            case 4: {
                guess = "type";
                id = 12;
                break;
            }
            case 6: {
                guess = "target";
                id = 9;
                break;
            }
            case 7: {
                guess = "bubbles";
                id = 1;
                break;
            }
            case 9: {
                char c = s.charAt(1);
                if (c == 'i') {
                    guess = "timeStamp";
                    id = 10;
                    break;
                }
                if (c == 'n') {
                    guess = "initEvent";
                    id = -1;
                    break;
                }
                if (c != 'o') break;
                guess = "toElement";
                id = 11;
                break;
            }
            case 10: {
                char c = s.charAt(0);
                if (c == 'c') {
                    guess = "cancelable";
                    id = 2;
                    break;
                }
                if (c == 'e') {
                    guess = "eventPhase";
                    id = 6;
                    break;
                }
                if (c != 's') break;
                guess = "srcElement";
                id = 8;
                break;
            }
            case 11: {
                char c = s.charAt(0);
                if (c == 'c') {
                    guess = "currentNode";
                    id = 4;
                    break;
                }
                if (c != 'f') break;
                guess = "fromElement";
                id = 7;
                break;
            }
            case 12: {
                guess = "cancelBubble";
                id = 3;
                break;
            }
            case 13: {
                guess = "currentTarget";
                id = 5;
                break;
            }
            case 14: {
                guess = "preventDefault";
                id = -3;
                break;
            }
            case 15: {
                guess = "stopPropagation";
                id = -4;
                break;
            }
            case 18: {
                guess = "isDefaultCancelled";
                id = -2;
                break;
            }
        }
        if (guess != null && (guess == s || guess.equals(s))) {
            return id;
        }
        return 0;
    }
}

