/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSLayout;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.LineBox;
import ice.pilots.html4.TextBox;
import java.awt.FontMetrics;
import java.awt.Graphics;

class BulletBox
extends CSSBox {
    private int type;
    private int lineHeight;
    private int ascent;
    private int descent;
    private int size;

    BulletBox(DElement e, CSSAttribs css, int type, CSSLayout cssLayout) {
        super(e, css, cssLayout);
        this.type = type;
    }

    void dispose() {
        super.dispose();
        this.element = null;
    }

    DNode getDomNode() {
        return this.element;
    }

    int calcBreaks() {
        FontMetrics fm = this.css.getFontMetrics();
        long val = TextBox.calculateCompressedFontSize(fm.getAscent(), fm.getDescent(), this.css);
        this.ascent = BulletBox.unwrapAscent(val);
        this.descent = BulletBox.unwrapDescent(val);
        this.size = (this.ascent + this.descent) / 3;
        this.lineHeight = TextBox.calculateLineHeight(this.css);
        this.totalWidth = this.size;
        return 0;
    }

    int getBreaks(int[] breaks, int idx) {
        return 0;
    }

    long getChunkDescentAscent(int x, int w, LineBox aBox) {
        return BulletBox.wrapDescentAscent(this.descent, this.ascent, this.lineHeight);
    }

    void paintChunk(Graphics g, int x, int w, LineBox aLineMetrics, int aBoxId) {
        if ((this.css.misc & 1) == 0) {
            return;
        }
        g.setColor(this.css.color);
        int y = (this.ascent + this.descent) * 2 / 5;
        if (this.type == 98) {
            g.drawOval(x, y, this.size, this.size);
        } else if (this.type == 99) {
            g.drawRect(x, y, this.size, this.size);
        } else if (this.type == 97) {
            g.fillOval(x, y, this.size, this.size);
        }
    }
}

