/*
 * Decompiled with CFR 0.152.
 */
package ice.mozilla.javascript;

import ice.mozilla.javascript.Context;
import ice.mozilla.javascript.NativeJavaArray;
import ice.mozilla.javascript.NativeJavaObject;
import ice.mozilla.javascript.Scriptable;
import ice.mozilla.javascript.Undefined;

public class WrapFactory {
    private boolean javaPrimitiveWrap = true;

    public Object wrap(Context cx, Scriptable scope, Object obj, Class staticType) {
        Class<?> cls;
        if (obj == null) {
            return obj;
        }
        if (staticType != null && staticType.isPrimitive()) {
            if (staticType == Void.TYPE) {
                return Undefined.instance;
            }
            if (staticType == Character.TYPE) {
                return new Integer(((Character)obj).charValue());
            }
            return obj;
        }
        if (obj instanceof Scriptable) {
            return obj;
        }
        if (!this.isJavaPrimitiveWrap()) {
            if (obj instanceof String || obj instanceof Number || obj instanceof Boolean) {
                return obj;
            }
            if (obj instanceof Character) {
                char[] a = new char[]{((Character)obj).charValue()};
                return new String(a);
            }
        }
        if ((cls = obj.getClass()).isArray()) {
            return NativeJavaArray.wrap(scope, obj);
        }
        return new NativeJavaObject(scope, obj, staticType);
    }

    public Scriptable wrapNewObject(Context cx, Scriptable scope, Object obj) {
        if (obj instanceof Scriptable) {
            return (Scriptable)obj;
        }
        Class<?> cls = obj.getClass();
        if (cls.isArray()) {
            return NativeJavaArray.wrap(scope, obj);
        }
        return new NativeJavaObject(scope, obj, null);
    }

    public final boolean isJavaPrimitiveWrap() {
        return this.javaPrimitiveWrap;
    }

    public final void setJavaPrimitiveWrap(boolean value) {
        this.javaPrimitiveWrap = value;
    }
}

