/*
 * Decompiled with CFR 0.152.
 */
package ice.dombase;

import ice.debug.Debug;
import ice.dombase.LexCallbackBase;
import ice.util.Defs;
import ice.util.JavaVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class LexBase
extends InputStream {
    protected static final char[] EMPTY_CHAR_ARRAY = new char[0];
    protected LexCallbackBase callback;
    protected static final IOException lexer_eof = new IOException();
    protected InputStream sourceInputStream;
    protected int inputReadProgress;
    protected Reader reader;
    protected char[] char_buf;
    protected int mark;
    protected int bufEnd;
    protected static final int TEXT_STATE = 0;
    protected static final int MARKUP_START_STATE = 1;
    protected static final int META_MARKUP_START_STATE = 2;
    protected static final int IN_XML_COMMENTS_STATE = 3;
    protected static final int SCRIPT_STATE = 4;
    protected static final int TEXTAREA_STATE = 5;
    protected static final int CDATA_STATE = 6;
    protected static final int EMBEDDED_XML_STATE = 7;
    protected int lexerState;
    private static final int XML_COMMENTS_START = 0;
    private static final int XML_COMMENTS_BODY = 1;
    private static final int XML_COMMENTS_END_MINUS = 2;
    private static final int XML_COMMENTS_END_MINUS_MINUS = 3;
    private int commentState;
    protected boolean done;
    protected int lexerNestingLevel;
    public int lineNumber;
    private char[] read_buf;
    private static final boolean isReadBufferNeeded = Defs.sysProperty("mrj.version") != null && !JavaVersion.isV12orGreater();
    private boolean cdataSection = false;

    protected LexBase(LexCallbackBase callback) {
        this.callback = callback;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public void reqCdata() {
        this.lexerState = 6;
    }

    public void reqEmbeddedXml() {
        this.lexerState = 7;
    }

    public void reqScriptCdata() {
        this.lexerState = 4;
    }

    public void reqTextareaCdata() {
        this.lexerState = 5;
    }

    protected void restoreBuffer(char[] saved_buf, int saved_mark, int saved_bufEnd) {
        if (this.mark != this.bufEnd) {
            int prefix_length = this.bufEnd - this.mark;
            if (prefix_length <= saved_mark) {
                System.arraycopy(this.char_buf, this.mark, saved_buf, saved_mark -= prefix_length, prefix_length);
            } else {
                int saved_length = saved_bufEnd - saved_mark;
                int new_size = prefix_length + saved_length;
                int capacity = this.char_buf.length;
                if (new_size <= capacity) {
                    System.arraycopy(saved_buf, saved_mark, saved_buf, prefix_length, saved_length);
                    System.arraycopy(this.char_buf, this.mark, saved_buf, 0, prefix_length);
                } else {
                    if (new_size > (capacity *= 2)) {
                        capacity = new_size;
                    }
                    char[] tmp = new char[capacity];
                    System.arraycopy(saved_buf, saved_mark, tmp, prefix_length, saved_length);
                    System.arraycopy(this.char_buf, this.mark, tmp, 0, prefix_length);
                    saved_buf = tmp;
                }
                saved_mark = 0;
                saved_bufEnd = new_size;
            }
        }
        this.char_buf = saved_buf;
        this.mark = saved_mark;
        this.bufEnd = saved_bufEnd;
    }

    private int fillBuffer(int pos) throws IOException {
        return this.ensureAvailable(pos, 1);
    }

    private int ensureAvailable(int pos, int minSize) throws IOException {
        int requiredChunk = pos + minSize - this.bufEnd;
        if (requiredChunk > 0) {
            if (this.lexerNestingLevel > 1 || this.sourceInputStream == null && this.reader == null) {
                throw lexer_eof;
            }
            if (this.mark != 0) {
                System.arraycopy(this.char_buf, this.mark, this.char_buf, 0, this.bufEnd - this.mark);
                pos -= this.mark;
                this.bufEnd -= this.mark;
                this.mark = 0;
            }
            this.readAtLeast(requiredChunk);
        }
        return pos;
    }

    protected void readAtLeast(int minSize) throws IOException {
        int minEnd = this.bufEnd + minSize;
        int capacity = this.char_buf.length;
        if (minEnd > capacity) {
            if (minEnd > (capacity *= 2)) {
                capacity = minEnd;
            }
            char[] tmp = new char[capacity];
            System.arraycopy(this.char_buf, 0, tmp, 0, this.bufEnd);
            this.char_buf = tmp;
        }
        int nRead = 0;
        int length = 0;
        do {
            length = capacity - this.bufEnd;
            if (isReadBufferNeeded) {
                if (this.read_buf == null || this.read_buf.length < this.char_buf.length) {
                    this.read_buf = new char[this.char_buf.length];
                }
                nRead = this.reader.read(this.read_buf, 0, length);
                System.arraycopy(this.read_buf, 0, this.char_buf, this.bufEnd, length);
            } else {
                nRead = this.reader.read(this.char_buf, this.bufEnd, length);
            }
            if (nRead < 0) {
                throw lexer_eof;
            }
            this.bufEnd += nRead;
            this.inputReadProgress += nRead;
        } while ((minSize -= nRead) > 0);
    }

    void stopParsing() {
        this.done = true;
    }

    public final void parse() throws IOException {
        this.parse(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(boolean doStart, boolean doFinish) throws IOException {
        try {
            ++this.lexerNestingLevel;
            if (this.lexerNestingLevel == 1 && doStart) {
                this.callback.startDocument();
            }
            this.do_parse(doFinish);
            if (this.done && this.lexerNestingLevel == 1 && doFinish) {
                this.callback.endDocument();
            }
        }
        finally {
            --this.lexerNestingLevel;
        }
    }

    private void do_parse(boolean doFinish) throws IOException {
        block12: {
            try {
                while (!this.done && !this.callback.isStopRequested()) {
                    this.checkMemory();
                    switch (this.lexerState) {
                        case 0: {
                            this.parseChars();
                            break;
                        }
                        case 1: {
                            this.parseMarkup();
                            break;
                        }
                        case 2: {
                            this.parseMetaMarkup();
                            break;
                        }
                        case 3: {
                            this.parseComments();
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            this.parseCData();
                        }
                    }
                }
            }
            catch (IOException ex) {
                if (ex != lexer_eof) {
                    Debug.ex(ex);
                    throw ex;
                }
                if (this.lexerNestingLevel != 1 || !doFinish) break block12;
                if (this.lexerState != 3) {
                    this.onTextChars(this.char_buf, this.mark, this.bufEnd, 0);
                }
                this.done = true;
            }
        }
    }

    protected void checkMemory() throws IOException {
    }

    private int updateLineNumber(int c, int pos) throws IOException {
        if (this.lexerNestingLevel == 1) {
            if (c == 13) {
                if (pos + 1 == this.bufEnd) {
                    pos = this.ensureAvailable(pos, 2);
                }
                if (this.char_buf[pos + 1] == '\n') {
                    return pos;
                }
            }
            ++this.lineNumber;
        }
        return pos;
    }

    private void parseChars() throws IOException {
        int pos = this.mark;
        int first_entity_offset = -1;
        while (true) {
            char c;
            if (pos == this.bufEnd) {
                pos = this.fillBuffer(pos);
            }
            if ((c = this.char_buf[pos]) == '\r' || c == '\n') {
                pos = this.updateLineNumber(c, pos);
            }
            ++pos;
            if (c == '<') {
                if (pos == this.bufEnd) {
                    pos = this.fillBuffer(pos);
                }
                if ((c = this.char_buf[pos]) == '\r' || c == '\n') {
                    pos = this.updateLineNumber(c, pos);
                }
                if (!LexBase.isWhiteSpace(c) && c != '%' && c != '-' && c != '<') break;
                continue;
            }
            if (c != '&' || first_entity_offset >= 0) continue;
            first_entity_offset = pos - this.mark - 1;
        }
        int text_start = this.mark;
        int text_end = pos - 1;
        this.mark = pos;
        this.lexerState = 1;
        this.onTextChars(this.char_buf, text_start, text_end, first_entity_offset);
    }

    private void onTextChars(char[] buf, int text_start, int text_end, int first_entity_offset) {
        if (text_start != text_end) {
            if (first_entity_offset >= 0) {
                text_end = this.resolveEntities(buf, text_start + first_entity_offset, text_end);
            }
            this.callback.textCharacters(buf, text_start, text_end - text_start);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseCData() throws IOException {
        pos = this.mark;
        INITIAL = false;
        AFTER_LESS = true;
        AFTER_LESS_EXCLAMATION = 2;
        AFTER_LESS_EXCLAMATION_MINUS = 3;
        COMMENTS_IN_CDATA = 4;
        MINUS_IN_COMMENTS = 5;
        MINUS_MINUS_IN_COMMENTS = 6;
        state = 0;
        block9: while (true) {
            if (pos == this.bufEnd) {
                pos = this.fillBuffer(pos);
            }
            if ((c = this.char_buf[pos]) == '\r' || c == '\n') {
                pos = this.updateLineNumber(c, pos);
            }
            ++pos;
            switch (state) {
                case 0: {
                    if (c == '<') {
                        state = 1;
                    } else if (this.cdataSection && c == ']' && this.char_buf[pos] == ']' && this.char_buf[pos + 1] == '>') {
                        --pos;
                        break block9;
                    }
                    ** GOTO lbl86
                }
                case 1: {
                    if (!this.cdataSection && c == '/') {
                        endIsFound = true;
                        explicitEnd = null;
                        if (this.lexerState == 7) {
                            explicitEnd = "xml";
                        } else if (this.lexerState == 4) {
                            explicitEnd = "script";
                        } else if (this.lexerState == 5) {
                            explicitEnd = "textarea";
                        }
                        if (explicitEnd != null) {
                            length = explicitEnd.length();
                            pos = this.ensureAvailable(pos, length + 1);
                            x = this.char_buf;
                            for (i = 0; i != length; ++i) {
                                c = x[pos + i];
                                match = explicitEnd.charAt(i);
                                if (c == match || c == match + -32) continue;
                                endIsFound = false;
                                break;
                            }
                            if (endIsFound && (c = x[pos + length]) != '>' && !LexBase.isWhiteSpace(c)) {
                                endIsFound = false;
                            }
                        }
                        if (endIsFound) {
                            pos -= 2;
                            break block9;
                        }
                    } else if (c == '!') {
                        state = 2;
                    } else {
                        --pos;
                        state = 0;
                    }
                    ** GOTO lbl86
                }
                case 2: {
                    if (c == '-') {
                        state = 3;
                    } else {
                        --pos;
                        state = 0;
                    }
                    ** GOTO lbl86
                }
                case 3: {
                    if (c == '-') {
                        state = 4;
                    } else {
                        --pos;
                        state = 0;
                    }
                    ** GOTO lbl86
                }
                case 4: {
                    if (c == '-') {
                        state = 5;
                    }
                    ** GOTO lbl86
                }
                case 5: {
                    state = c == '-' ? 6 : 4;
                    ** GOTO lbl86
                }
                case 6: {
                    if (c != '>') ** GOTO lbl84
                    state = 0;
                    ** GOTO lbl86
lbl84:
                    // 1 sources

                    if (c != '-') {
                        state = 4;
                    }
                }
lbl86:
                // 16 sources

                default: {
                    continue block9;
                }
            }
            break;
        }
        cdataStart = this.mark;
        cdataEnd = pos;
        if (this.lexerState == 5) {
            cdataEnd = this.resolveEntities(this.char_buf, cdataStart, cdataEnd);
            cdataEnd = LexBase.cleanupTextarea(this.char_buf, cdataStart, cdataEnd);
        }
        this.lexerState = 0;
        if (this.cdataSection) {
            pos += 3;
            this.cdataSection = false;
        }
        this.mark = pos;
        this.callback.cdataBody(this.char_buf, cdataStart, cdataEnd - cdataStart);
    }

    private void parseMarkup() throws IOException {
        char c;
        int pos = this.mark;
        if (pos == this.bufEnd) {
            pos = this.fillBuffer(pos);
        }
        if ((c = this.char_buf[pos]) == '!') {
            this.mark = pos + 1;
            this.lexerState = 2;
        } else {
            this.parseElement();
        }
    }

    private void parseMetaMarkup() throws IOException {
        int pos = this.ensureAvailable(this.mark, 2);
        if (this.char_buf[pos] == '-' && this.char_buf[pos + 1] == '-') {
            this.mark = pos + 2;
            this.lexerState = 3;
            this.commentState = 0;
        } else if (this.char_buf[pos] == '[') {
            pos = this.ensureAvailable(this.mark, 7);
            if (!(this.char_buf[pos + 1] != 'C' && this.char_buf[pos + 1] != 'c' || this.char_buf[pos + 2] != 'D' && this.char_buf[pos + 2] != 'd' || this.char_buf[pos + 3] != 'A' && this.char_buf[pos + 3] != 'a' || this.char_buf[pos + 4] != 'T' && this.char_buf[pos + 4] != 't' || this.char_buf[pos + 5] != 'A' && this.char_buf[pos + 5] != 'a' || this.char_buf[pos + 6] != '[')) {
                this.mark = pos + 7;
                this.lexerState = 6;
                this.cdataSection = true;
            } else {
                this.mark = pos = this.parseMetaMarkup2(pos);
                this.lexerState = 0;
            }
        } else {
            this.mark = pos = this.parseMetaMarkup2(pos);
            this.lexerState = 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseMetaMarkup2(int pos) throws IOException {
        boolean LOOK_FOR_COMMENTS = false;
        boolean AFTER_STARTING_MINUS = true;
        int AFTER_STARTING_MINUS_MINUS = 2;
        int INSIDE_SGML_COMMENTS = 3;
        int AFTER_ENDING_MINUS = 4;
        int AFTER_ENDING_MINUS_MINUS = 5;
        int state = 0;
        boolean isInsideInternalSubset = false;
        while (true) {
            char c;
            if (pos == this.bufEnd) {
                pos = this.fillBuffer(pos);
            }
            if ((c = this.char_buf[pos]) == '\r' || c == '\n') {
                pos = this.updateLineNumber(c, pos);
            }
            ++pos;
            switch (state) {
                case 0: {
                    if (c == '>' && !isInsideInternalSubset) {
                        return pos;
                    }
                    if (c != '-') break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == '>' && !isInsideInternalSubset) {
                        return pos;
                    }
                    if (c == '-') {
                        state = 2;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (c == '>' && !isInsideInternalSubset) {
                        return pos;
                    }
                    if (c == '-') break;
                    state = 3;
                    break;
                }
                case 3: {
                    if (c != '-') break;
                    state = 4;
                    break;
                }
                case 4: {
                    if (c == '-') {
                        state = 5;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 5: {
                    if (c == '>' && !isInsideInternalSubset) {
                        return pos;
                    }
                    if (c == '-') break;
                    state = 0;
                }
            }
            if (state == 3) continue;
            if (c == '[') {
                isInsideInternalSubset = true;
                continue;
            }
            if (c != ']') continue;
            isInsideInternalSubset = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseComments() throws IOException {
        int pos = this.mark;
        int firstCloseBracket_offset = -1;
        int saved_mark = 0;
        try {
            block14: while (true) {
                char c;
                if (pos == this.bufEnd) {
                    try {
                        saved_mark = this.mark;
                        pos = this.fillBuffer(pos);
                    }
                    finally {
                        if (firstCloseBracket_offset != -1 && this.mark != saved_mark) {
                            firstCloseBracket_offset -= saved_mark - this.mark;
                        }
                    }
                }
                if ((c = this.char_buf[pos]) == '\r' || c == '\n') {
                    try {
                        saved_mark = this.mark;
                        pos = this.updateLineNumber(c, pos);
                    }
                    finally {
                        if (firstCloseBracket_offset != -1 && this.mark != saved_mark) {
                            firstCloseBracket_offset -= saved_mark - this.mark;
                        }
                    }
                }
                ++pos;
                switch (this.commentState) {
                    case 0: {
                        if (c == '>') break block14;
                        if (c == '-') break;
                        this.commentState = 1;
                        break;
                    }
                    case 1: {
                        if (c == '-') {
                            this.commentState = 2;
                            break;
                        }
                        if (c != '>' || firstCloseBracket_offset != -1) break;
                        firstCloseBracket_offset = pos;
                        break;
                    }
                    case 2: {
                        if (c == '-') {
                            this.commentState = 3;
                            break;
                        }
                        if (c == '>' && firstCloseBracket_offset == -1) {
                            firstCloseBracket_offset = pos;
                        }
                        this.commentState = 1;
                        break;
                    }
                    case 3: {
                        if (c == '>') break block14;
                        if (c == '-') break;
                        this.commentState = 1;
                    }
                }
            }
        }
        catch (IOException ex) {
            if (ex != lexer_eof) {
                throw ex;
            }
            if (firstCloseBracket_offset == -1) {
                throw ex;
            }
            pos = firstCloseBracket_offset;
        }
        this.mark = pos;
        this.lexerState = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseElement() throws IOException {
        int pos = this.mark;
        char quoteChar = '\u0000';
        while (true) {
            char c;
            if (pos == this.bufEnd) {
                pos = this.fillBuffer(pos);
            }
            if ((c = this.char_buf[pos]) == '\r' || c == '\n') {
                pos = this.updateLineNumber(c, pos);
            }
            if (c == '\'' || c == '\"') {
                char t;
                if (quoteChar == c) {
                    quoteChar = '\u0000';
                } else if (quoteChar == '\u0000' && (LexBase.isWhiteSpace(t = this.char_buf[pos - 1]) || t == '=')) {
                    quoteChar = c;
                }
            } else if (c == '>' && quoteChar == '\u0000') break;
            ++pos;
        }
        int elemNameStart = this.mark;
        this.mark = ++pos;
        this.lexerState = 0;
        char[] saved_buf = this.char_buf;
        int saved_mark = this.mark;
        int saved_bufEnd = this.bufEnd;
        this.char_buf = EMPTY_CHAR_ARRAY;
        this.mark = 0;
        this.bufEnd = 0;
        try {
            if (saved_buf[elemNameStart] != '/') {
                this.doElementCallback(saved_buf, elemNameStart, pos - elemNameStart - 1);
            } else {
                int prefixLength = 0;
                int t = ++elemNameStart;
                while (t < pos) {
                    char c = saved_buf[t];
                    ++t;
                    if (c == ':') {
                        prefixLength = t - elemNameStart;
                    }
                    if (!LexBase.isWhiteSpace(c)) continue;
                    break;
                }
                this.callback.endElement(this, saved_buf, elemNameStart, t - elemNameStart - 1, prefixLength);
            }
        }
        finally {
            this.restoreBuffer(saved_buf, saved_mark, saved_bufEnd);
        }
    }

    private void doElementCallback(char[] chars, int offset, int length) {
        int p;
        char c = '\u0000';
        boolean isEmpty = false;
        c = chars[offset + length - 1];
        if (c == '/') {
            isEmpty = true;
            --length;
            c = chars[offset];
            char c1 = chars[offset + 1];
            if (!((c != 'a' && c != 'A' || c1 != ' ') && (c != 'b' && c != 'B' || c1 != 'a' && c1 != 'A' || chars[offset + 4] != ' ') && (c != 'o' && c != 'O' || c1 != 'p' && c1 != 'P' || chars[offset + 6] != ' ') && (c != 'f' && c != 'F' || c1 != 'o' && c1 != 'O' || chars[offset + 4] != ' '))) {
                isEmpty = false;
                ++length;
            }
        } else if (c == '?') {
            --length;
        }
        int endp = offset + length;
        int prefixLength = 0;
        for (p = offset; p < endp && !LexBase.isWhiteSpace(c = chars[p]); ++p) {
            if (c != ':') continue;
            prefixLength = p - offset + 1;
        }
        int tagNameOffset = offset;
        int tagNameLength = p - offset;
        while (p < endp) {
            while (p < endp && LexBase.isWhiteSpace(c = chars[p])) {
                ++p;
            }
            int nameStart = p;
            int attrPrefixLength = 0;
            while (p < endp && !LexBase.isWhiteSpace(c = chars[p]) && c != '=') {
                if (c == ':') {
                    attrPrefixLength = p - nameStart + 1;
                }
                ++p;
            }
            int nameLength = p - nameStart;
            boolean equalFound = false;
            while (p < endp) {
                c = chars[p];
                if (c == '=') {
                    equalFound = true;
                } else if (!LexBase.isWhiteSpace(c)) break;
                ++p;
            }
            if (!equalFound) {
                if (nameLength <= 0) continue;
                this.callback.elementAttribute(chars, nameStart, nameLength, attrPrefixLength, nameStart, nameLength);
                continue;
            }
            int valueStart = p;
            int weirdChars = 0;
            char qchar = '\u0000';
            if (c == '\'' || c == '\"') {
                qchar = c;
            }
            if (qchar == '\u0000') {
                while (p < endp && !LexBase.isWhiteSpace(c = chars[p])) {
                    if (c == '&') {
                        weirdChars = 1;
                    }
                    ++p;
                }
            } else {
                ++p;
                while (p < endp) {
                    c = chars[p];
                    if (c == qchar) {
                        ++p;
                        break;
                    }
                    if (c == '&' || c == '\n' || c == '\r' || c == '\t') {
                        weirdChars = 1;
                    }
                    ++p;
                }
            }
            boolean isEventHandler = false;
            if (!(weirdChars <= 0 || nameLength <= 2 || chars[nameStart] != 'o' && chars[nameStart] != 'O' || chars[nameStart + 1] != 'n' && chars[nameStart + 1] != 'N')) {
                isEventHandler = true;
            }
            int valueLength = p - valueStart;
            if (qchar != '\u0000') {
                if (valueLength < 2) continue;
                if (weirdChars > 0) {
                    weirdChars = this.substWeirdChars(chars, valueStart + 1, valueLength - 2, isEventHandler);
                }
                this.callback.elementAttribute(chars, nameStart, nameLength, attrPrefixLength, valueStart + 1, valueLength - 2 - weirdChars);
                continue;
            }
            if (weirdChars > 0) {
                weirdChars = this.substWeirdChars(chars, valueStart, valueLength, isEventHandler);
            }
            this.callback.elementAttribute(chars, nameStart, nameLength, attrPrefixLength, valueStart, valueLength - weirdChars);
        }
        this.callback.startElement(this, chars, tagNameOffset, tagNameLength, prefixLength, isEmpty);
    }

    private int substWeirdChars(char[] chars, int pos, int len, boolean isEventHandler) {
        char[] src = new char[len];
        System.arraycopy(chars, pos, src, 0, len);
        int removedChars = 0;
        for (int i = 0; i < len; ++i) {
            char t = src[i];
            if (!isEventHandler) {
                if (t == '\r' || t == '\n') {
                    ++removedChars;
                    continue;
                }
                if (t == '\t') {
                    chars[pos++] = 32;
                    continue;
                }
            }
            if (t == '&') {
                int j;
                for (j = i + 1; j <= len; ++j) {
                    int entity_len;
                    int tmp;
                    if (j != len && src[j] != ';' || (tmp = this.entityToChar(src, i + 1, entity_len = j - i - 1)) < 0) continue;
                    i = j;
                    chars[pos++] = (char)tmp;
                    removedChars += entity_len;
                    if (j >= len) break;
                    ++removedChars;
                    break;
                }
                if (j <= len) continue;
                chars[pos++] = t;
                continue;
            }
            chars[pos++] = t;
        }
        return removedChars;
    }

    private static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13 || c == 12;
    }

    private boolean isBadEntityTerminator(int c) {
        return LexBase.isWhiteSpace(c) || c == 38 || c == 60 || c == 34 || c == 39 || c == 40 || c == 41;
    }

    private static int cleanupTextarea(char[] chars, int begin, int end) {
        int destinationIndex = begin;
        int carriageReturnPosition = -2;
        for (int charIndex = begin; charIndex < end; ++charIndex) {
            int currentChar = chars[charIndex];
            if (currentChar == 12) {
                currentChar = 10;
            } else if (currentChar == 13) {
                currentChar = 10;
                carriageReturnPosition = charIndex;
            }
            if (currentChar == 10 && charIndex == begin || currentChar == 10 && carriageReturnPosition + 1 == charIndex) continue;
            chars[destinationIndex] = (char)currentChar;
            ++destinationIndex;
        }
        return destinationIndex;
    }

    private int resolveEntities(char[] chars, int begin, int end) {
        int j;
        int entity_end;
        int c;
        int destination = -1;
        int entity_char = -1;
        int i = begin;
        while (i != end) {
            c = chars[i];
            ++i;
            if (c != 38) continue;
            entity_end = end;
            for (j = i; j != end; ++j) {
                c = chars[j];
                if (c == 59) {
                    entity_end = j++;
                    break;
                }
                if (!this.isBadEntityTerminator(c)) continue;
                entity_end = j;
                break;
            }
            if ((entity_char = this.entityToChar(chars, i, entity_end - i)) < 0) continue;
            destination = i - 1;
            i = j;
            break;
        }
        if (entity_char >= 0) {
            chars[destination] = (char)entity_char;
            ++destination;
            while (i != end) {
                c = chars[i];
                ++i;
                if (c == 38) {
                    entity_end = end;
                    for (j = i; j != end; ++j) {
                        c = chars[j];
                        if (c == 59) {
                            entity_end = j++;
                            break;
                        }
                        if (!this.isBadEntityTerminator(c)) continue;
                        entity_end = j;
                        break;
                    }
                    if ((c = this.entityToChar(chars, i, entity_end - i)) < 0) {
                        c = 38;
                    } else {
                        i = j;
                    }
                }
                chars[destination] = (char)c;
                ++destination;
            }
            end = destination;
        }
        return end;
    }

    private int entityToChar(char[] chars, int offset, int length) {
        int c = -1;
        if (length >= 2) {
            if (chars[offset] != '#') {
                c = LexBase.entityNameToChar(chars, offset, length);
            } else {
                char firstDigitChar;
                --length;
                int base = 10;
                if ((firstDigitChar = chars[++offset]) == 'X' || firstDigitChar == 'x') {
                    base = 16;
                    ++offset;
                    --length;
                }
                String s = new String(chars, offset, length);
                try {
                    c = Integer.parseInt(s, base);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (128 <= c && c <= 159) {
                    c = LexBase.mapWin1252_128_159_toUnicode(c);
                } else if (c == 9) {
                    c = 32;
                }
            }
        }
        return c;
    }

    private static int mapWin1252_128_159_toUnicode(int c) {
        String s = "\u20ac\u0081\u201a\u0192\u201e\u2026\u2020\u2021\u02c6\u2030\u0160\u2039\u0152\u008d\u017d\u008f\u0090\u2018\u2019\u201c\u201d\u2022\u2013\u2014\u02dc\u2122\u0161\u203a\u0153\u009d\u017e\u0178";
        return s.charAt(c - 128);
    }

    private static int entityNameToChar(char[] buf, int offset, int length) {
        block0 : switch (length) {
            case 2: {
                char c1 = buf[offset + 1];
                switch (buf[offset]) {
                    case 'M': {
                        if (c1 != 'u') break block0;
                        return 924;
                    }
                    case 'N': {
                        if (c1 != 'u') break block0;
                        return 925;
                    }
                    case 'P': {
                        if (c1 != 'i') break block0;
                        return 928;
                    }
                    case 'X': {
                        if (c1 != 'i') break block0;
                        return 926;
                    }
                    case 'g': {
                        if (c1 == 'e') {
                            return 8805;
                        }
                        if (c1 != 't') break block0;
                        return 62;
                    }
                    case 'l': {
                        if (c1 == 'e') {
                            return 8804;
                        }
                        if (c1 != 't') break block0;
                        return 60;
                    }
                    case 'm': {
                        if (c1 != 'u') break block0;
                        return 956;
                    }
                    case 'n': {
                        if (c1 == 'e') {
                            return 8800;
                        }
                        if (c1 == 'i') {
                            return 8715;
                        }
                        if (c1 != 'u') break block0;
                        return 957;
                    }
                    case 'o': {
                        if (c1 != 'r') break block0;
                        return 8744;
                    }
                    case 'p': {
                        if (c1 != 'i') break block0;
                        return 960;
                    }
                    case 'x': {
                        if (c1 != 'i') break block0;
                        return 958;
                    }
                }
                break;
            }
            case 3: {
                char c1 = buf[offset + 1];
                char c2 = buf[offset + 2];
                switch (buf[offset]) {
                    case 'C': {
                        if (0 != (c1 ^ 0x68 | c2 ^ 0x69)) break block0;
                        return 935;
                    }
                    case 'E': {
                        if (c1 == 'T') {
                            if (c2 != 'H') break block0;
                            return 208;
                        }
                        if (c1 != 't' || c2 != 'a') break block0;
                        return 919;
                    }
                    case 'P': {
                        if (c2 != 'i') break block0;
                        if (c1 == 'h') {
                            return 934;
                        }
                        if (c1 != 's') break block0;
                        return 936;
                    }
                    case 'R': {
                        if (0 != (c1 ^ 0x68 | c2 ^ 0x6F)) break block0;
                        return 929;
                    }
                    case 'T': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x75)) break block0;
                        return 932;
                    }
                    case 'a': {
                        if (c2 == 'p') {
                            if (c1 != 'm') break block0;
                            return 38;
                        }
                        if (c2 == 'd') {
                            if (c1 != 'n') break block0;
                            return 8743;
                        }
                        if (c2 != 'g' || c1 != 'n') break block0;
                        return 8736;
                    }
                    case 'c': {
                        if (c1 == 'a') {
                            if (c2 != 'p') break block0;
                            return 8745;
                        }
                        if (c1 == 'h') {
                            if (c2 != 'i') break block0;
                            return 967;
                        }
                        if (c1 != 'u' || c2 != 'p') break block0;
                        return 8746;
                    }
                    case 'd': {
                        if (0 != (c1 ^ 0x65 | c2 ^ 0x67)) break block0;
                        return 176;
                    }
                    case 'e': {
                        if (c1 != 't') break block0;
                        if (c2 == 'a') {
                            return 951;
                        }
                        if (c2 != 'h') break block0;
                        return 240;
                    }
                    case 'i': {
                        if (0 != (c1 ^ 0x6E | c2 ^ 0x74)) break block0;
                        return 8747;
                    }
                    case 'l': {
                        if (c1 == 'o') {
                            if (c2 != 'z') break block0;
                            return 9674;
                        }
                        if (c1 != 'r' || c2 != 'm') break block0;
                        return 8206;
                    }
                    case 'n': {
                        if (0 != (c1 ^ 0x6F | c2 ^ 0x74)) break block0;
                        return 172;
                    }
                    case 'p': {
                        if (c1 == 'h') {
                            if (c2 != 'i') break block0;
                            return 966;
                        }
                        if (c1 == 'i') {
                            if (c2 != 'v') break block0;
                            return 982;
                        }
                        if (c1 != 's' || c2 != 'i') break block0;
                        return 968;
                    }
                    case 'r': {
                        if (c1 == 'e') {
                            if (c2 != 'g') break block0;
                            return 174;
                        }
                        if (c1 == 'h') {
                            if (c2 != 'o') break block0;
                            return 961;
                        }
                        if (c1 != 'l' || c2 != 'm') break block0;
                        return 8207;
                    }
                    case 's': {
                        if (c1 == 'h') {
                            if (c2 != 'y') break block0;
                            return 173;
                        }
                        if (c1 == 'i') {
                            if (c2 != 'm') break block0;
                            return 8764;
                        }
                        if (c1 != 'u') break block0;
                        if (c2 == 'b') {
                            return 8834;
                        }
                        if (c2 == 'm') {
                            return 8721;
                        }
                        if (c2 != 'p') break block0;
                        return 8835;
                    }
                    case 't': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x75)) break block0;
                        return 964;
                    }
                    case 'u': {
                        if (0 != (c1 ^ 0x6D | c2 ^ 0x6C)) break block0;
                        return 168;
                    }
                    case 'y': {
                        if (0 != (c1 ^ 0x65 | c2 ^ 0x6E)) break block0;
                        return 165;
                    }
                    case 'z': {
                        if (0 != (c1 ^ 0x77 | c2 ^ 0x6A)) break block0;
                        return 8205;
                    }
                }
                break;
            }
            case 4: {
                char c1 = buf[offset + 1];
                char c2 = buf[offset + 2];
                char c3 = buf[offset + 3];
                switch (buf[offset]) {
                    case 'A': {
                        if (0 != (c1 ^ 0x75 | c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 196;
                    }
                    case 'B': {
                        if (0 != (c1 ^ 0x65 | c2 ^ 0x74 | c3 ^ 0x61)) break block0;
                        return 914;
                    }
                    case 'E': {
                        if (0 != (c1 ^ 0x75 | c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 203;
                    }
                    case 'I': {
                        if (c1 == 'o') {
                            if (0 != (c2 ^ 0x74 | c3 ^ 0x61)) break block0;
                            return 921;
                        }
                        if (c1 != 'u' || 0 != (c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 207;
                    }
                    case 'O': {
                        if (0 != (c1 ^ 0x75 | c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 214;
                    }
                    case 'U': {
                        if (0 != (c1 ^ 0x75 | c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 220;
                    }
                    case 'Y': {
                        if (0 != (c1 ^ 0x75 | c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 376;
                    }
                    case 'Z': {
                        if (0 != (c1 ^ 0x65 | c2 ^ 0x74 | c3 ^ 0x61)) break block0;
                        return 918;
                    }
                    case 'a': {
                        if (0 != (c1 ^ 0x75 | c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 228;
                    }
                    case 'b': {
                        if (c1 == 'e') {
                            if (0 != (c2 ^ 0x74 | c3 ^ 0x61)) break block0;
                            return 946;
                        }
                        if (c1 != 'u' || 0 != (c2 ^ 0x6C | c3 ^ 0x6C)) break block0;
                        return 8226;
                    }
                    case 'c': {
                        switch (c3) {
                            case 't': {
                                if (0 != (c1 ^ 0x65 | c2 ^ 0x6E)) break block0;
                                return 162;
                            }
                            case 'c': {
                                if (0 != (c1 ^ 0x69 | c2 ^ 0x72)) break block0;
                                return 710;
                            }
                            case 'g': {
                                if (0 != (c1 ^ 0x6F | c2 ^ 0x6E)) break block0;
                                return 8773;
                            }
                            case 'y': {
                                if (0 != (c1 ^ 0x6F | c2 ^ 0x70)) break block0;
                                return 169;
                            }
                        }
                        break block0;
                    }
                    case 'd': {
                        if (0 != (c2 ^ 0x72 | c3 ^ 0x72)) break block0;
                        if (c1 == 'A') {
                            return 8659;
                        }
                        if (c1 != 'a') break block0;
                        return 8595;
                    }
                    case 'e': {
                        if (c1 == 'm') {
                            if (0 != (c2 ^ 0x73 | c3 ^ 0x70)) break block0;
                            return 8195;
                        }
                        if (c1 == 'n') {
                            if (0 != (c2 ^ 0x73 | c3 ^ 0x70)) break block0;
                            return 8194;
                        }
                        if (c1 != 'u') break block0;
                        if (c2 == 'm') {
                            if (c3 != 'l') break block0;
                            return 235;
                        }
                        if (c2 != 'r' || c3 != 'o') break block0;
                        return 8364;
                    }
                    case 'f': {
                        if (0 != (c1 ^ 0x6E | c2 ^ 0x6F | c3 ^ 0x66)) break block0;
                        return 402;
                    }
                    case 'h': {
                        if (0 != (c2 ^ 0x72 | c3 ^ 0x72)) break block0;
                        if (c1 == 'A') {
                            return 8660;
                        }
                        if (c1 != 'a') break block0;
                        return 8596;
                    }
                    case 'i': {
                        if (c1 == 'o') {
                            if (0 != (c2 ^ 0x74 | c3 ^ 0x61)) break block0;
                            return 953;
                        }
                        if (c1 == 's') {
                            if (0 != (c2 ^ 0x69 | c3 ^ 0x6E)) break block0;
                            return 8712;
                        }
                        if (c1 != 'u' || 0 != (c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 239;
                    }
                    case 'l': {
                        if (c3 == 'r') {
                            if (c2 != 'r') break block0;
                            if (c1 == 'A') {
                                return 8656;
                            }
                            if (c1 != 'a') break block0;
                            return 8592;
                        }
                        if (c3 != 'g' || 0 != (c1 ^ 0x61 | c2 ^ 0x6E)) break block0;
                        return 9001;
                    }
                    case 'm': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x63 | c3 ^ 0x72)) break block0;
                        return 175;
                    }
                    case 'n': {
                        if (c1 == 'b') {
                            if (0 != (c2 ^ 0x73 | c3 ^ 0x70)) break block0;
                            return 160;
                        }
                        if (c1 != 's' || 0 != (c2 ^ 0x75 | c3 ^ 0x62)) break block0;
                        return 8836;
                    }
                    case 'o': {
                        if (c3 == 'f') {
                            if (0 != (c1 ^ 0x72 | c2 ^ 0x64)) break block0;
                            return 170;
                        }
                        if (c3 == 'l') {
                            if (0 != (c1 ^ 0x75 | c2 ^ 0x6D)) break block0;
                            return 246;
                        }
                        if (c3 != 'm' || 0 != (c1 ^ 0x72 | c2 ^ 0x64)) break block0;
                        return 186;
                    }
                    case 'p': {
                        if (c1 == 'a') {
                            if (c2 != 'r') break block0;
                            if (c3 == 'a') {
                                return 182;
                            }
                            if (c3 != 't') break block0;
                            return 8706;
                        }
                        if (c1 == 'e') {
                            if (0 != (c2 ^ 0x72 | c3 ^ 0x70)) break block0;
                            return 8869;
                        }
                        if (c1 != 'r' || c2 != 'o') break block0;
                        if (c3 == 'd') {
                            return 8719;
                        }
                        if (c3 != 'p') break block0;
                        return 8733;
                    }
                    case 'q': {
                        if (0 != (c1 ^ 0x75 | c2 ^ 0x6F | c3 ^ 0x74)) break block0;
                        return 34;
                    }
                    case 'r': {
                        if (c1 == 'A') {
                            if (0 != (c2 ^ 0x72 | c3 ^ 0x72)) break block0;
                            return 8658;
                        }
                        if (c1 == 'a') {
                            if (c2 == 'n') {
                                if (c3 != 'g') break block0;
                                return 9002;
                            }
                            if (c2 != 'r' || c3 != 'r') break block0;
                            return 8594;
                        }
                        if (c1 != 'e' || 0 != (c2 ^ 0x61 | c3 ^ 0x6C)) break block0;
                        return 8476;
                    }
                    case 's': {
                        switch (c2) {
                            case 'o': {
                                if (0 != (c1 ^ 0x64 | c3 ^ 0x74)) break block0;
                                return 8901;
                            }
                            case 'c': {
                                if (0 != (c1 ^ 0x65 | c3 ^ 0x74)) break block0;
                                return 167;
                            }
                            case 'b': {
                                if (0 != (c1 ^ 0x75 | c3 ^ 0x65)) break block0;
                                return 8838;
                            }
                            case 'p': {
                                if (c1 != 'u') break block0;
                                switch (c3) {
                                    case '1': {
                                        return 185;
                                    }
                                    case '2': {
                                        return 178;
                                    }
                                    case '3': {
                                        return 179;
                                    }
                                    case 'e': {
                                        return 8839;
                                    }
                                }
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case 'u': {
                        if (c1 == 'A') {
                            if (0 != (c2 ^ 0x72 | c3 ^ 0x72)) break block0;
                            return 8657;
                        }
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x72 | c3 ^ 0x72)) break block0;
                            return 8593;
                        }
                        if (c1 != 'u' || 0 != (c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 252;
                    }
                    case 'y': {
                        if (0 != (c1 ^ 0x75 | c2 ^ 0x6D | c3 ^ 0x6C)) break block0;
                        return 255;
                    }
                    case 'z': {
                        if (c1 == 'e') {
                            if (0 != (c2 ^ 0x74 | c3 ^ 0x61)) break block0;
                            return 950;
                        }
                        if (c1 != 'w' || 0 != (c2 ^ 0x6E | c3 ^ 0x6A)) break block0;
                        return 8204;
                    }
                }
                break;
            }
            case 5: {
                char c1 = buf[offset + 1];
                char c2 = buf[offset + 2];
                char c3 = buf[offset + 3];
                char c4 = buf[offset + 4];
                switch (buf[offset]) {
                    case 'A': {
                        switch (c1) {
                            case 'E': {
                                if (0 != (c2 ^ 0x6C | c3 ^ 0x69 | c4 ^ 0x67)) break block0;
                                return 198;
                            }
                            case 'c': {
                                if (0 != (c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                                return 194;
                            }
                            case 'l': {
                                if (0 != (c2 ^ 0x70 | c3 ^ 0x68 | c4 ^ 0x61)) break block0;
                                return 913;
                            }
                            case 'r': {
                                if (0 != (c2 ^ 0x69 | c3 ^ 0x6E | c4 ^ 0x67)) break block0;
                                return 197;
                            }
                        }
                        break block0;
                    }
                    case 'D': {
                        if (0 != (c1 ^ 0x65 | c2 ^ 0x6C | c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                        return 916;
                    }
                    case 'E': {
                        if (0 != (c1 ^ 0x63 | c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                        return 202;
                    }
                    case 'G': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x6D | c3 ^ 0x6D | c4 ^ 0x61)) break block0;
                        return 915;
                    }
                    case 'I': {
                        if (0 != (c1 ^ 0x63 | c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                        return 206;
                    }
                    case 'K': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x70 | c3 ^ 0x70 | c4 ^ 0x61)) break block0;
                        return 922;
                    }
                    case 'O': {
                        if (c1 == 'E') {
                            if (0 != (c2 ^ 0x6C | c3 ^ 0x69 | c4 ^ 0x67)) break block0;
                            return 338;
                        }
                        if (c1 == 'c') {
                            if (0 != (c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                            return 212;
                        }
                        if (c1 != 'm' || 0 != (c2 ^ 0x65 | c3 ^ 0x67 | c4 ^ 0x61)) break block0;
                        return 937;
                    }
                    case 'P': {
                        if (0 != (c1 ^ 0x72 | c2 ^ 0x69 | c3 ^ 0x6D | c4 ^ 0x65)) break block0;
                        return 8243;
                    }
                    case 'S': {
                        if (0 != (c1 ^ 0x69 | c2 ^ 0x67 | c3 ^ 0x6D | c4 ^ 0x61)) break block0;
                        return 931;
                    }
                    case 'T': {
                        if (c1 == 'H') {
                            if (0 != (c2 ^ 0x4F | c3 ^ 0x52 | c4 ^ 0x4E)) break block0;
                            return 222;
                        }
                        if (c1 != 'h' || 0 != (c2 ^ 0x65 | c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                        return 920;
                    }
                    case 'U': {
                        if (0 != (c1 ^ 0x63 | c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                        return 219;
                    }
                    case 'a': {
                        switch (c3) {
                            case 'i': {
                                if (0 != (c1 ^ 0x65 | c2 ^ 0x6C | c4 ^ 0x67)) break block0;
                                return 230;
                            }
                            case 'h': {
                                if (0 != (c1 ^ 0x6C | c2 ^ 0x70 | c4 ^ 0x61)) break block0;
                                return 945;
                            }
                            case 'n': {
                                if (0 != (c1 ^ 0x72 | c2 ^ 0x69 | c4 ^ 0x67)) break block0;
                                return 229;
                            }
                            case 'r': {
                                if (0 != (c1 ^ 0x63 | c2 ^ 0x69 | c4 ^ 0x63)) break block0;
                                return 226;
                            }
                            case 'm': {
                                if (0 != (c1 ^ 0x73 | c2 ^ 0x79 | c4 ^ 0x70)) break block0;
                                return 8776;
                            }
                            case 't': {
                                if (0 != (c1 ^ 0x63 | c2 ^ 0x75 | c4 ^ 0x65)) break block0;
                                return 180;
                            }
                        }
                        break block0;
                    }
                    case 'b': {
                        if (0 != (c1 ^ 0x64 | c2 ^ 0x71 | c3 ^ 0x75 | c4 ^ 0x6F)) break block0;
                        return 8222;
                    }
                    case 'c': {
                        if (c1 == 'e') {
                            if (0 != (c2 ^ 0x64 | c3 ^ 0x69 | c4 ^ 0x6C)) break block0;
                            return 184;
                        }
                        if (c1 == 'l') {
                            if (0 != (c2 ^ 0x75 | c3 ^ 0x62 | c4 ^ 0x73)) break block0;
                            return 9827;
                        }
                        if (c1 != 'r' || 0 != (c2 ^ 0x61 | c3 ^ 0x72 | c4 ^ 0x72)) break block0;
                        return 8629;
                    }
                    case 'd': {
                        if (c1 == 'e' && 0 == (c2 ^ 0x6C | c3 ^ 0x74 | c4 ^ 0x61)) {
                            return 948;
                        }
                        if (c1 != 'i' || 0 != (c2 ^ 0x61 | c3 ^ 0x6D | c4 ^ 0x73)) break block0;
                        return 9830;
                    }
                    case 'e': {
                        switch (c1) {
                            case 'c': {
                                if (0 != (c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                                return 234;
                            }
                            case 'm': {
                                if (0 != (c2 ^ 0x70 | c3 ^ 0x74 | c4 ^ 0x79)) break block0;
                                return 8709;
                            }
                            case 'q': {
                                if (0 != (c2 ^ 0x75 | c3 ^ 0x69 | c4 ^ 0x76)) break block0;
                                return 8801;
                            }
                            case 'x': {
                                if (0 != (c2 ^ 0x69 | c3 ^ 0x73 | c4 ^ 0x74)) break block0;
                                return 8707;
                            }
                        }
                        break block0;
                    }
                    case 'f': {
                        if (0 != (c1 ^ 0x72 | c2 ^ 0x61 | c3 ^ 0x73 | c4 ^ 0x6C)) break block0;
                        return 8260;
                    }
                    case 'g': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x6D | c3 ^ 0x6D | c4 ^ 0x61)) break block0;
                        return 947;
                    }
                    case 'i': {
                        switch (c1) {
                            case 'c': {
                                if (0 != (c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                                return 238;
                            }
                            case 'e': {
                                if (0 != (c2 ^ 0x78 | c3 ^ 0x63 | c4 ^ 0x6C)) break block0;
                                return 161;
                            }
                            case 'm': {
                                if (0 != (c2 ^ 0x61 | c3 ^ 0x67 | c4 ^ 0x65)) break block0;
                                return 8465;
                            }
                            case 'n': {
                                if (0 != (c2 ^ 0x66 | c3 ^ 0x69 | c4 ^ 0x6E)) break block0;
                                return 8734;
                            }
                        }
                        break block0;
                    }
                    case 'k': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x70 | c3 ^ 0x70 | c4 ^ 0x61)) break block0;
                        return 954;
                    }
                    case 'l': {
                        switch (c1) {
                            case 'a': {
                                if (0 != (c2 ^ 0x71 | c3 ^ 0x75 | c4 ^ 0x6F)) break block0;
                                return 171;
                            }
                            case 'c': {
                                if (0 != (c2 ^ 0x65 | c3 ^ 0x69 | c4 ^ 0x6C)) break block0;
                                return 8968;
                            }
                            case 'd': {
                                if (0 != (c2 ^ 0x71 | c3 ^ 0x75 | c4 ^ 0x6F)) break block0;
                                return 8220;
                            }
                            case 's': {
                                if (0 != (c2 ^ 0x71 | c3 ^ 0x75 | c4 ^ 0x6F)) break block0;
                                return 8216;
                            }
                        }
                        break block0;
                    }
                    case 'm': {
                        if (c2 == 'a') {
                            if (0 != (c1 ^ 0x64 | c3 ^ 0x73 | c4 ^ 0x68)) break block0;
                            return 8212;
                        }
                        if (c2 == 'c') {
                            if (0 != (c1 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x6F)) break block0;
                            return 181;
                        }
                        if (c2 != 'n' || 0 != (c1 ^ 0x69 | c3 ^ 0x75 | c4 ^ 0x73)) break block0;
                        return 8722;
                    }
                    case 'n': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x62 | c3 ^ 0x6C | c4 ^ 0x61)) break block0;
                            return 8711;
                        }
                        if (c1 == 'd') {
                            if (0 != (c2 ^ 0x61 | c3 ^ 0x73 | c4 ^ 0x68)) break block0;
                            return 8211;
                        }
                        if (c1 != 'o' || 0 != (c2 ^ 0x74 | c3 ^ 0x69 | c4 ^ 0x6E)) break block0;
                        return 8713;
                    }
                    case 'o': {
                        switch (c1) {
                            case 'c': {
                                if (0 != (c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                                return 244;
                            }
                            case 'e': {
                                if (0 != (c2 ^ 0x6C | c3 ^ 0x69 | c4 ^ 0x67)) break block0;
                                return 339;
                            }
                            case 'l': {
                                if (0 != (c2 ^ 0x69 | c3 ^ 0x6E | c4 ^ 0x65)) break block0;
                                return 8254;
                            }
                            case 'm': {
                                if (0 != (c2 ^ 0x65 | c3 ^ 0x67 | c4 ^ 0x61)) break block0;
                                return 969;
                            }
                            case 'p': {
                                if (0 != (c2 ^ 0x6C | c3 ^ 0x75 | c4 ^ 0x73)) break block0;
                                return 8853;
                            }
                        }
                        break block0;
                    }
                    case 'p': {
                        if (c1 == 'o') {
                            if (0 != (c2 ^ 0x75 | c3 ^ 0x6E | c4 ^ 0x64)) break block0;
                            return 163;
                        }
                        if (c1 != 'r' || 0 != (c2 ^ 0x69 | c3 ^ 0x6D | c4 ^ 0x65)) break block0;
                        return 8242;
                    }
                    case 'r': {
                        switch (c1) {
                            case 'a': {
                                if (c2 == 'q') {
                                    if (0 != (c3 ^ 0x75 | c4 ^ 0x6F)) break block0;
                                    return 187;
                                }
                                if (c2 != 'd' || 0 != (c3 ^ 0x69 | c4 ^ 0x63)) break block0;
                                return 8730;
                            }
                            case 'c': {
                                if (0 != (c2 ^ 0x65 | c3 ^ 0x69 | c4 ^ 0x6C)) break block0;
                                return 8969;
                            }
                            case 'd': {
                                if (0 != (c2 ^ 0x71 | c3 ^ 0x75 | c4 ^ 0x6F)) break block0;
                                return 8221;
                            }
                            case 's': {
                                if (0 != (c2 ^ 0x71 | c3 ^ 0x75 | c4 ^ 0x6F)) break block0;
                                return 8217;
                            }
                        }
                        break block0;
                    }
                    case 's': {
                        if (c1 == 'b') {
                            if (0 != (c2 ^ 0x71 | c3 ^ 0x75 | c4 ^ 0x6F)) break block0;
                            return 8218;
                        }
                        if (c1 == 'i') {
                            if (0 != (c2 ^ 0x67 | c3 ^ 0x6D | c4 ^ 0x61)) break block0;
                            return 963;
                        }
                        if (c1 != 'z' || 0 != (c2 ^ 0x6C | c3 ^ 0x69 | c4 ^ 0x67)) break block0;
                        return 223;
                    }
                    case 't': {
                        switch (c2) {
                            case 'e': {
                                if (0 != (c1 ^ 0x68 | c3 ^ 0x74 | c4 ^ 0x61)) break block0;
                                return 952;
                            }
                            case 'o': {
                                if (0 != (c1 ^ 0x68 | c3 ^ 0x72 | c4 ^ 0x6E)) break block0;
                                return 254;
                            }
                            case 'l': {
                                if (0 != (c1 ^ 0x69 | c3 ^ 0x64 | c4 ^ 0x65)) break block0;
                                return 732;
                            }
                            case 'm': {
                                if (0 != (c1 ^ 0x69 | c3 ^ 0x65 | c4 ^ 0x73)) break block0;
                                return 215;
                            }
                            case 'a': {
                                if (0 != (c1 ^ 0x72 | c3 ^ 0x64 | c4 ^ 0x65)) break block0;
                                return 8482;
                            }
                        }
                        break block0;
                    }
                    case 'u': {
                        if (c1 == 'c') {
                            if (0 != (c2 ^ 0x69 | c3 ^ 0x72 | c4 ^ 0x63)) break block0;
                            return 251;
                        }
                        if (c1 != 'p' || 0 != (c2 ^ 0x73 | c3 ^ 0x69 | c4 ^ 0x68)) break block0;
                        return 978;
                    }
                }
                break;
            }
            case 6: {
                char c1 = buf[offset + 1];
                char c2 = buf[offset + 2];
                char c3 = buf[offset + 3];
                char c4 = buf[offset + 4];
                char c5 = buf[offset + 5];
                switch (buf[offset]) {
                    case 'A': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                            return 193;
                        }
                        if (c1 == 'g') {
                            if (0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                            return 192;
                        }
                        if (c1 != 't' || 0 != (c2 ^ 0x69 | c3 ^ 0x6C | c4 ^ 0x64 | c5 ^ 0x65)) break block0;
                        return 195;
                    }
                    case 'C': {
                        if (0 != (c1 ^ 0x63 | c2 ^ 0x65 | c3 ^ 0x64 | c4 ^ 0x69 | c5 ^ 0x6C)) break block0;
                        return 199;
                    }
                    case 'D': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x67 | c3 ^ 0x67 | c4 ^ 0x65 | c5 ^ 0x72)) break block0;
                        return 8225;
                    }
                    case 'E': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                            return 201;
                        }
                        if (c1 != 'g' || 0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                        return 200;
                    }
                    case 'I': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                            return 205;
                        }
                        if (c1 != 'g' || 0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                        return 204;
                    }
                    case 'L': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x6D | c3 ^ 0x62 | c4 ^ 0x64 | c5 ^ 0x61)) break block0;
                        return 923;
                    }
                    case 'N': {
                        if (0 != (c1 ^ 0x74 | c2 ^ 0x69 | c3 ^ 0x6C | c4 ^ 0x64 | c5 ^ 0x65)) break block0;
                        return 209;
                    }
                    case 'O': {
                        switch (c1) {
                            case 'a': {
                                if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                                return 211;
                            }
                            case 'g': {
                                if (0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                                return 210;
                            }
                            case 's': {
                                if (0 != (c2 ^ 0x6C | c3 ^ 0x61 | c4 ^ 0x73 | c5 ^ 0x68)) break block0;
                                return 216;
                            }
                            case 't': {
                                if (0 != (c2 ^ 0x69 | c3 ^ 0x6C | c4 ^ 0x64 | c5 ^ 0x65)) break block0;
                                return 213;
                            }
                        }
                        break block0;
                    }
                    case 'S': {
                        if (0 != (c1 ^ 0x63 | c2 ^ 0x61 | c3 ^ 0x72 | c4 ^ 0x6F | c5 ^ 0x6E)) break block0;
                        return 352;
                    }
                    case 'U': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                            return 218;
                        }
                        if (c1 != 'g' || 0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                        return 217;
                    }
                    case 'Y': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                        return 221;
                    }
                    case 'a': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                            return 225;
                        }
                        if (c1 == 'g') {
                            if (0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                            return 224;
                        }
                        if (c1 != 't' || 0 != (c2 ^ 0x69 | c3 ^ 0x6C | c4 ^ 0x64 | c5 ^ 0x65)) break block0;
                        return 227;
                    }
                    case 'b': {
                        if (0 != (c1 ^ 0x72 | c2 ^ 0x76 | c3 ^ 0x62 | c4 ^ 0x61 | c5 ^ 0x72)) break block0;
                        return 166;
                    }
                    case 'c': {
                        if (c1 == 'c') {
                            if (0 != (c2 ^ 0x65 | c3 ^ 0x64 | c4 ^ 0x69 | c5 ^ 0x6C)) break block0;
                            return 231;
                        }
                        if (c1 != 'u' || 0 != (c2 ^ 0x72 | c3 ^ 0x72 | c4 ^ 0x65 | c5 ^ 0x6E)) break block0;
                        return 164;
                    }
                    case 'd': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x67 | c3 ^ 0x67 | c4 ^ 0x65 | c5 ^ 0x72)) break block0;
                            return 8224;
                        }
                        if (c1 != 'i' || 0 != (c2 ^ 0x76 | c3 ^ 0x69 | c4 ^ 0x64 | c5 ^ 0x65)) break block0;
                        return 247;
                    }
                    case 'e': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                            return 233;
                        }
                        if (c1 != 'g' || 0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                        return 232;
                    }
                    case 'f': {
                        if (c5 == 'l') {
                            if (0 != (c1 ^ 0x6F | c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x6C)) break block0;
                            return 8704;
                        }
                        if (c5 == '2') {
                            if (0 != (c1 ^ 0x72 | c2 ^ 0x61 | c3 ^ 0x63 | c4 ^ 0x31)) break block0;
                            return 189;
                        }
                        if (c5 != '4' || 0 != (c1 ^ 0x72 | c2 ^ 0x61 | c3 ^ 0x63)) break block0;
                        if (c4 == '1') {
                            return 188;
                        }
                        if (c4 != '3') break block0;
                        return 190;
                    }
                    case 'h': {
                        if (c2 == 'a') {
                            if (0 != (c1 ^ 0x65 | c3 ^ 0x72 | c4 ^ 0x74 | c5 ^ 0x73)) break block0;
                            return 9829;
                        }
                        if (c2 != 'l' || 0 != (c1 ^ 0x65 | c3 ^ 0x6C | c4 ^ 0x69 | c5 ^ 0x70)) break block0;
                        return 8230;
                    }
                    case 'i': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                            return 237;
                        }
                        if (c1 == 'g') {
                            if (0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                            return 236;
                        }
                        if (c1 != 'q' || 0 != (c2 ^ 0x75 | c3 ^ 0x65 | c4 ^ 0x73 | c5 ^ 0x74)) break block0;
                        return 191;
                    }
                    case 'l': {
                        switch (c1) {
                            case 'a': {
                                if (0 != (c2 ^ 0x6D | c3 ^ 0x62 | c4 ^ 0x64 | c5 ^ 0x61)) break block0;
                                return 955;
                            }
                            case 'f': {
                                if (0 != (c2 ^ 0x6C | c3 ^ 0x6F | c4 ^ 0x6F | c5 ^ 0x72)) break block0;
                                return 8970;
                            }
                            case 'o': {
                                if (0 != (c2 ^ 0x77 | c3 ^ 0x61 | c4 ^ 0x73 | c5 ^ 0x74)) break block0;
                                return 8727;
                            }
                            case 's': {
                                if (0 != (c2 ^ 0x61 | c3 ^ 0x71 | c4 ^ 0x75 | c5 ^ 0x6F)) break block0;
                                return 8249;
                            }
                        }
                        break block0;
                    }
                    case 'm': {
                        if (0 != (c1 ^ 0x69 | c2 ^ 0x64 | c3 ^ 0x64 | c4 ^ 0x6F | c5 ^ 0x74)) break block0;
                        return 183;
                    }
                    case 'n': {
                        if (0 != (c1 ^ 0x74 | c2 ^ 0x69 | c3 ^ 0x6C | c4 ^ 0x64 | c5 ^ 0x65)) break block0;
                        return 241;
                    }
                    case 'o': {
                        switch (c1) {
                            case 'a': {
                                if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                                return 243;
                            }
                            case 'g': {
                                if (0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                                return 242;
                            }
                            case 's': {
                                if (0 != (c2 ^ 0x6C | c3 ^ 0x61 | c4 ^ 0x73 | c5 ^ 0x68)) break block0;
                                return 248;
                            }
                            case 't': {
                                if (c5 == 'e') {
                                    if (0 != (c2 ^ 0x69 | c3 ^ 0x6C | c4 ^ 0x64)) break block0;
                                    return 245;
                                }
                                if (c5 != 's' || 0 != (c2 ^ 0x69 | c3 ^ 0x6D | c4 ^ 0x65)) break block0;
                                return 8855;
                            }
                        }
                        break block0;
                    }
                    case 'p': {
                        if (c1 == 'e') {
                            if (0 != (c2 ^ 0x72 | c3 ^ 0x6D | c4 ^ 0x69 | c5 ^ 0x6C)) break block0;
                            return 8240;
                        }
                        if (c1 != 'l' || 0 != (c2 ^ 0x75 | c3 ^ 0x73 | c4 ^ 0x6D | c5 ^ 0x6E)) break block0;
                        return 177;
                    }
                    case 'r': {
                        if (c1 == 'f') {
                            if (0 != (c2 ^ 0x6C | c3 ^ 0x6F | c4 ^ 0x6F | c5 ^ 0x72)) break block0;
                            return 8971;
                        }
                        if (c1 != 's' || 0 != (c2 ^ 0x61 | c3 ^ 0x71 | c4 ^ 0x75 | c5 ^ 0x6F)) break block0;
                        return 8250;
                    }
                    case 's': {
                        if (c1 == 'c') {
                            if (0 != (c2 ^ 0x61 | c3 ^ 0x72 | c4 ^ 0x6F | c5 ^ 0x6E)) break block0;
                            return 353;
                        }
                        if (c1 == 'i') {
                            if (0 != (c2 ^ 0x67 | c3 ^ 0x6D | c4 ^ 0x61 | c5 ^ 0x66)) break block0;
                            return 962;
                        }
                        if (c1 != 'p' || 0 != (c2 ^ 0x61 | c3 ^ 0x64 | c4 ^ 0x65 | c5 ^ 0x73)) break block0;
                        return 9824;
                    }
                    case 't': {
                        if (c5 == '4') {
                            if (0 != (c1 ^ 0x68 | c2 ^ 0x65 | c3 ^ 0x72 | c4 ^ 0x65)) break block0;
                            return 8756;
                        }
                        if (c5 != 'p' || 0 != (c1 ^ 0x68 | c2 ^ 0x69 | c3 ^ 0x6E | c4 ^ 0x73)) break block0;
                        return 8201;
                    }
                    case 'u': {
                        if (c1 == 'a') {
                            if (0 != (c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                            return 250;
                        }
                        if (c1 != 'g' || 0 != (c2 ^ 0x72 | c3 ^ 0x61 | c4 ^ 0x76 | c5 ^ 0x65)) break block0;
                        return 249;
                    }
                    case 'w': {
                        if (0 != (c1 ^ 0x65 | c2 ^ 0x69 | c3 ^ 0x65 | c4 ^ 0x72 | c5 ^ 0x70)) break block0;
                        return 8472;
                    }
                    case 'y': {
                        if (0 != (c1 ^ 0x61 | c2 ^ 0x63 | c3 ^ 0x75 | c4 ^ 0x74 | c5 ^ 0x65)) break block0;
                        return 253;
                    }
                }
                break;
            }
            case 7: {
                char c1 = buf[offset + 1];
                char c2 = buf[offset + 2];
                char c3 = buf[offset + 3];
                char c4 = buf[offset + 4];
                char c5 = buf[offset + 5];
                char c6 = buf[offset + 6];
                switch (buf[offset]) {
                    case 'E': {
                        if (0 != (c1 ^ 0x70 | c2 ^ 0x73 | c3 ^ 0x69 | c4 ^ 0x6C | c5 ^ 0x6F | c6 ^ 0x6E)) break;
                        return 917;
                    }
                    case 'O': {
                        if (0 != (c1 ^ 0x6D | c2 ^ 0x69 | c3 ^ 0x63 | c4 ^ 0x72 | c5 ^ 0x6F | c6 ^ 0x6E)) break;
                        return 927;
                    }
                    case 'U': {
                        if (0 != (c1 ^ 0x70 | c2 ^ 0x73 | c3 ^ 0x69 | c4 ^ 0x6C | c5 ^ 0x6F | c6 ^ 0x6E)) break;
                        return 933;
                    }
                    case 'a': {
                        if (0 != (c1 ^ 0x6C | c2 ^ 0x65 | c3 ^ 0x66 | c4 ^ 0x73 | c5 ^ 0x79 | c6 ^ 0x6D)) break;
                        return 8501;
                    }
                    case 'e': {
                        if (0 != (c1 ^ 0x70 | c2 ^ 0x73 | c3 ^ 0x69 | c4 ^ 0x6C | c5 ^ 0x6F | c6 ^ 0x6E)) break;
                        return 949;
                    }
                    case 'o': {
                        if (0 != (c1 ^ 0x6D | c2 ^ 0x69 | c3 ^ 0x63 | c4 ^ 0x72 | c5 ^ 0x6F | c6 ^ 0x6E)) break;
                        return 959;
                    }
                    case 'u': {
                        if (0 != (c1 ^ 0x70 | c2 ^ 0x73 | c3 ^ 0x69 | c4 ^ 0x6C | c5 ^ 0x6F | c6 ^ 0x6E)) break;
                        return 965;
                    }
                }
                break;
            }
            case 8: {
                char c1 = buf[offset + 1];
                char c2 = buf[offset + 2];
                char c3 = buf[offset + 3];
                char c4 = buf[offset + 4];
                char c5 = buf[offset + 5];
                char c6 = buf[offset + 6];
                char c7 = buf[offset + 7];
                switch (buf[offset]) {
                    case 't': {
                        if (0 != (c1 ^ 0x68 | c2 ^ 0x65 | c3 ^ 0x74 | c4 ^ 0x61 | c5 ^ 0x73 | c6 ^ 0x79 | c7 ^ 0x6D)) break block0;
                        return 977;
                    }
                }
                break;
            }
        }
        return -1;
    }
}

