/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Vector;

public class CompoundTransferable
implements Transferable {
    private Transferable[] _transferables;

    public CompoundTransferable(Transferable transferable, Transferable transferable2) {
        this._transferables = new Transferable[]{transferable, transferable2};
    }

    public CompoundTransferable(Transferable[] transferableArray) {
        this._transferables = new Transferable[transferableArray.length];
        System.arraycopy(transferableArray, 0, this._transferables, 0, transferableArray.length);
    }

    public DataFlavor[] getTransferDataFlavors() {
        Object[] objectArray;
        Transferable[] transferableArray = this._transferables;
        Vector<Object> vector = new Vector<Object>(transferableArray.length);
        for (int i = 0; i < transferableArray.length; ++i) {
            objectArray = transferableArray[i].getTransferDataFlavors();
            for (int j = 0; j < objectArray.length; ++j) {
                if (vector.contains(objectArray[j])) continue;
                vector.addElement(objectArray[j]);
            }
        }
        objectArray = new DataFlavor[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        Transferable[] transferableArray = this._transferables;
        for (int i = 0; i < transferableArray.length; ++i) {
            if (!transferableArray[i].isDataFlavorSupported(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    public final Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        Transferable[] transferableArray = this._transferables;
        for (int i = 0; i < transferableArray.length; ++i) {
            if (!transferableArray[i].isDataFlavorSupported(dataFlavor)) continue;
            return transferableArray[i].getTransferData(dataFlavor);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

