/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.share.collection;

import java.util.Enumeration;
import java.util.Vector;

public class ImmutableArray {
    private Object[] _array;

    public ImmutableArray() {
        this._array = new Object[0];
    }

    public ImmutableArray(Object[] objectArray) {
        this._array = (Object[])objectArray.clone();
    }

    public ImmutableArray(Vector vector) {
        if (vector == null) {
            this._array = new Object[0];
        } else {
            int n = vector.size();
            this._array = new Object[n];
            for (int i = 0; i < n; ++i) {
                this._array[i] = vector.elementAt(i);
            }
        }
    }

    public ImmutableArray(Enumeration enumeration) {
        if (enumeration == null) {
            this._array = new Object[0];
        } else {
            int n = 0;
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
                ++n;
            }
            this._array = new Object[n];
            for (int i = 0; i < n; ++i) {
                this._array[i] = vector.elementAt(i);
            }
        }
    }

    public Object get(int n) throws ArrayIndexOutOfBoundsException {
        return this._array[n];
    }

    public int size() {
        return this._array.length;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImmutableArray)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Object[] objectArray = this._array;
        Object[] objectArray2 = ((ImmutableArray)object)._array;
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = objectArray.length - 1; i >= 0; --i) {
            Object object2 = objectArray[i];
            Object object3 = objectArray2[i];
            if (!(object2 == null ? object3 != null : !object2.equals(object3))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        Object[] objectArray = this._array;
        int n = objectArray.length;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            n2 = 31 * n2 + (object == null ? 0 : object.hashCode());
        }
        return n2;
    }
}

