/**
 * Copyright (c) 2008, 2009, Oracle and/or its affiliates. All rights reserved.
 *
 */


package oracle.eclipse.tools.webtier.trinidad.ui.internal;

import org.eclipse.jst.common.project.facet.ui.libprov.LibraryFacetPropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;


/**
 * Allows the facet user library to be changed after the facet has been
 * installed. Accessible via Project Properties > Project Facets > Trinidad.
 *
 * @author Debajit Adhikary
 *
 */
public class TrinidadFacetLibraryPropertyPage extends LibraryFacetPropertyPage
{
    private static final String FACET_ID = "jst.jsf.trinidad"; //$NON-NLS-1$


    @Override
    public IProjectFacetVersion getProjectFacetVersion ()
    {
        final IProjectFacet facet = ProjectFacetsManager.getProjectFacet(FACET_ID);
        final IFacetedProject fproj = getFacetedProject();
        return fproj.getInstalledVersion(facet);
    }
}
