package oracle.eclipse.tools.webtier.trinidad.ui.internal;


import org.eclipse.jst.common.project.facet.ui.libprov.LibraryFacetInstallPage;
import org.eclipse.osgi.util.NLS;


/**
 * Wizard Page for Trinidad facet installation. Shows up in the Dynamic Web Project
 * creation wizard.
 * 
 * @author Debajit Adhikary
 * 
 */
public class TrinidadFacetInstallWizardPage extends LibraryFacetInstallPage
{
    public TrinidadFacetInstallWizardPage() 
    {
        super("jst.jsf.trinidad.install"); // Trinidad facet install action name //$NON-NLS-1$

        // Configure what appears on the top of the wizard page
        setTitle(Strings.title);
        setDescription(Strings.description);
    }


    @Override
    public void setVisible(boolean visible) 
    {
        super.setVisible(visible);
        if (visible) 
        {
            updateValidation();
        }
    }


    private static final class Strings extends NLS
    {
        public static String title;
        public static String description;

        static
        {
            initializeMessages(TrinidadFacetInstallWizardPage.class.getName(), Strings.class);
        }
    }
}
