package oracle.eclipse.tools.debug;

import java.util.Map;

import javax.faces.context.FacesContext;

import org.apache.commons.collections.map.AbstractMapDecorator;

final class ScopedMapDecorator extends AbstractMapDecorator {
	private final FacesContext facesContext;
	private final String scopeName;

	ScopedMapDecorator(@SuppressWarnings("rawtypes") final Map map,
			final String scopeName, final FacesContext facesContext) {
		super(map);
		this.facesContext = facesContext;
		this.scopeName = scopeName;
	}

	@Override
	public Object put(final Object key, final Object value) {
		final Object oldValue = super.put(key, value);
		if (!shouldIgnoreKey(key)) {
			ELVariableWriter.writeVariable(key, value, scopeName, "declared",facesContext);
		}
		return oldValue;
	}

	private boolean shouldIgnoreKey(final Object key) {
		if (key == null) {
			return true;
		}
		final String asStr = key.toString();
		if (asStr.startsWith("org.apache") || asStr.startsWith("oracle.")
				|| asStr.startsWith("_")) {
			return true;
		}
		return false;
	}

	@Override
	public Object remove(final Object key) {
		final Object oldValue = super.remove(key);
		if (!shouldIgnoreKey(key)) {
			System.out.printf(
					"REMOVE: Remove from %s map: key %s, old Value: %s\n",
					scopeName, key, oldValue);
		}
		return oldValue;
	}
}