package oracle.eclipse.tools.debug;

import java.util.Map;

import javax.faces.context.FacesContext;

import oracle.adf.controller.TaskFlowId;
import oracle.adf.controller.internal.AdfcNavigationHandler;
import oracle.adf.controller.metadata.ActivityId;
import oracle.adf.controller.metadata.model.ControlFlowRule;
import oracle.adf.controller.metadata.model.PageFlow;
import oracle.adfinternal.controller.state.AdfcContext;
import oracle.adfinternal.controller.state.ViewPortContextImpl;
import oracle.adfinternal.controller.util.StateUtils;

public class OepeAdfcNavigationHandler extends AdfcNavigationHandler {

	@Override
	public ActivityId handleNavigation(FacesContext arg0, String arg1,
			String arg2) {
		if (Settings.isActive) {
			// always return null to force the internal impl to ignore me and
			// continue on.
			// we are just here to watch.
			AdfcContext context = AdfcContext.getCurrentInstance();
			ViewPortContextImpl currentViewPort = context.getCurrentViewPort();
			ActivityId viewActivityId = currentViewPort.getViewActivityId();
			if (viewActivityId != null) {
				String viewId = viewActivityId.getViewId();
				String localActivityId = viewActivityId.getLocalActivityId();
				TaskFlowId taskFlowId = viewActivityId.getTaskFlowId();
				OepeDebugLogger
						.log(String
								.format("Debug ADFc Navigation Handler: [curViewActivity viewId %s, localActivityId: %s, taskFlowId: %s",
										viewId, localActivityId, taskFlowId));
			}
			PageFlow currentPageFlow = StateUtils.getCurrentPageFlow();
			if (currentPageFlow != null) {
				Map<ActivityId, ControlFlowRule> controlFlowRules = currentPageFlow
						.getControlFlowRules();
				OepeDebugLogger
						.log(String
								.format("Debug ADFc Navigation Handler: Map of current control flow rules: %s",
										controlFlowRules));
			}
		}
		return null;
	}

}
