package oracle.eclipse.tools.debug;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

import javax.el.ValueExpression;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

import oracle.adf.view.rich.component.rich.layout.RichPanelStretchLayout;

import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXForm;
import org.apache.myfaces.trinidad.component.UIXPanel;

public class OepeAdfPhaseListener implements PhaseListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private SystemEventListener listener = new SystemEventListener() {
		
		@Override
		public void processEvent(SystemEvent event) throws AbortProcessingException {
			Object source = event.getSource();
			if (source instanceof UIComponent)
			{
				
			}
		}
		
		@Override
		public boolean isListenerForSource(Object source) {
			return true;
		}
	};
	public OepeAdfPhaseListener() {
		super();
		OepeDebugLogger.log("Using OepeAdfPhaseListener");
	}

	@Override
	public void afterPhase(PhaseEvent event) {
//		String viewId = getViewId(event);
//		OepeDebugLogger.log(String.format("afterPhase: %s on viewId %s", event
//				.getPhaseId().toString(), viewId));

		if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
			UIViewRoot viewRoot = event.getFacesContext().getViewRoot();
			final ComponentTreeCollectionContext context = new ComponentTreeCollectionContext();
			visitComponent(viewRoot, context);
			FacesContext.getCurrentInstance().getApplication().unsubscribeFromEvent(PreRenderComponentEvent.class, UIComponent.class,
					listener);
		}
		
		if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION)
		{
			UIViewRoot viewRoot = event.getFacesContext().getViewRoot();
			final ComponentTreeCollectionContext context = new ComponentTreeCollectionContext();
			visitComponent(viewRoot, context);
		}
	}

	private void handleUIXPanel(UIXPanel component,
			ComponentTreeCollectionContext context) {
		if (component instanceof RichPanelStretchLayout) {
			Map<String, UIComponent> facets = component.getFacets();
			Set<String> keySet = facets.keySet();
			if (!keySet.contains("top") && !keySet.contains("bottom")
					&& !keySet.contains("start") && !keySet.contains("end")
					&& !keySet.contains("center")) {
				OepeDebugLogger
						.log(String
								.format("WARNING: panelStretchLayout '%s' may need a child facet (top/bottom/start/end/center) for its children to display",
										component.getId()));
			}
		}
	}

	private void visitComponent(UIComponent component,
			ComponentTreeCollectionContext context) {
		// System.out.println(component.toString());
		if (component instanceof ActionSource) {
			if (!context.isInsideComponent(UIForm.class)
					&& !context.isInsideComponent(UIXForm.class)) {
				OepeDebugLogger
						.log(String
								.format("WARNING, ActionSource component %s found but can't find parent UIForm/UIXForm.  This may cause problems executing the action",
										component.getId()));
			}
		} else if (component instanceof UIXPanel) {
			handleUIXPanel((UIXPanel) component, context);
		}
		
		if (component instanceof UIXComponent)
		{
			FacesBean facesBean = ((UIXComponent)component).getFacesBean();
			if (facesBean != null)
			{
				ValueExpression valueExpression = facesBean.getValueExpression(UIXCollection.VAR_KEY);
				if (valueExpression != null)
				{
					System.out.println(valueExpression.getValue(FacesContext.getCurrentInstance().getELContext()));
				}
			}
		}
		context.pushComponent(component);
		Iterator<UIComponent> facetsAndChildren = component.getFacetsAndChildren();
		while(facetsAndChildren.hasNext()) {
			visitComponent(facetsAndChildren.next(), context);
		}
		context.popComponent();
	}

//	private String getViewId(PhaseEvent event) {
//		UIViewRoot viewRoot = event.getFacesContext().getViewRoot();
//		String viewId = "viewId not set";
//		if (viewRoot != null) {
//			viewId = viewRoot.getViewId();
//		}
//		return viewId;
//	}

	@Override
	public void beforePhase(PhaseEvent event) {
		if (event.getPhaseId() == PhaseId.RENDER_RESPONSE)
		{
			FacesContext.getCurrentInstance().getApplication().subscribeToEvent(PreRenderComponentEvent.class, UIComponent.class,
					listener);
	
		}
	}

	public PhaseId getPhaseId() {
		return PhaseId.ANY_PHASE;
	}

	private static class ComponentTreeCollectionContext {
		private Stack<UIComponent> curTreePath = new Stack<UIComponent>();

		public void pushComponent(final UIComponent comp) {
			curTreePath.push(comp);
		}

		public UIComponent popComponent() {
			return curTreePath.pop();
		}

		public boolean isInsideComponent(
				final Class<? extends UIComponent> component) {
			this.curTreePath.iterator();
			for (final UIComponent comp : this.curTreePath) {
				if (component.isAssignableFrom(comp.getClass())) {
					return true;
				}
			}
			return false;
		}
	}
}
