package oracle.eclipse.tools.debug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.FacesMessage;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;

public class OepeAdfNavigationHandler extends ConfigurableNavigationHandler {

	private NavigationHandler _delegate;
	private final Map<String, Set<NavigationCase>> _emptyCases = new HashMap<String, Set<NavigationCase>>();

	public OepeAdfNavigationHandler(NavigationHandler delegate) {
		_delegate = delegate;
		OepeDebugLogger.log(String.format(
				"Constructing debug navigation handler using delegate: %s",
				delegate));
		// enable the adfc navigation handler in case it gets loaded
		Settings.setActive(true);
	}

	@Override
	public NavigationCase getNavigationCase(FacesContext facesContext,
			String fromAction, String outcome) {
		if (!(_delegate instanceof ConfigurableNavigationHandler)) {
			return null;
		}
		NavigationCase navigationCase = ((ConfigurableNavigationHandler) this._delegate)
				.getNavigationCase(facesContext, fromAction, outcome);
		OepeDebugLogger.log(String.format(
				"From action %s, outcome %s, result=%s", fromAction, outcome,
				navigationCase == null ? "<null>" : navigationCase.toString()));
		facesContext.getExternalContext().getSessionMap().put("_oepeFrom", fromAction);
		facesContext.getExternalContext().getSessionMap().put("_oepeOutcome", outcome);
		facesContext.getExternalContext().getSessionMap().put("_oepeOldViewId", facesContext.getViewRoot().getViewId());
		facesContext.getExternalContext().getSessionMap().put("_oepeNewViewId", navigationCase == null ? null : navigationCase.getToViewId(facesContext));

		if (navigationCase != null)
		{
			return new NavigationCase(navigationCase.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(),
					null, navigationCase.getToViewId(facesContext), 
					navigationCase.getParameters(), navigationCase.isRedirect(), navigationCase.isIncludeViewParams())
			{
				
			};
		}
		return null;
	}

	@Override
	public Map<String, Set<NavigationCase>> getNavigationCases() {
		if (!(_delegate instanceof ConfigurableNavigationHandler)) {
			return _emptyCases;
		}
		Map<String, Set<NavigationCase>> navigationCases = ((ConfigurableNavigationHandler) this._delegate)
				.getNavigationCases();
		OepeDebugLogger.log(navigationCases == null ? "" : navigationCases
				.toString());
		return navigationCases;
	}

	@Override
	public void handleNavigation(final FacesContext facesContext, final String from,
			final String outcome) {
		final String curViewId = facesContext.getViewRoot().getViewId();
		OepeDebugLogger.log(String.format(
				"Handle navigation: curViewId: %s, from %s, outcome %s",
				curViewId, from, outcome));
		final Map<String, List<FacesMessage>> messages = new HashMap<String, List<FacesMessage>>();
		
		this._delegate.handleNavigation(new FacesContextWrapper() {

			@Override
			public void addMessage(String clientId, FacesMessage message) {

				super.addMessage(clientId, message);
				List<FacesMessage> messageList = messages.get(clientId);
				if (messageList == null) {
					messageList = new ArrayList<FacesMessage>(2);
					messages.put(clientId, messageList);
				}
				messageList.add(message);
			}

			@Override
			public void setViewRoot(UIViewRoot newRoot) {
				UIViewRoot oldRoot = getViewRoot();
				String oldViewId = oldRoot != null ? oldRoot.getViewId() : "null";
				String newViewId = newRoot != null ? newRoot.getViewId() : "null";
				OepeDebugLogger.log(String.format(
						"View root updated, old id %s, new id %s",
						oldViewId,
						newViewId));
				getExternalContext().getSessionMap().put("_oepeFrom", from);
				getExternalContext().getSessionMap().put("_oepeOutcome", outcome);
				getExternalContext().getSessionMap().put("_oepeOldViewId", oldViewId);
				getExternalContext().getSessionMap().put("_oepeNewViewId", newViewId);

				super.setViewRoot(newRoot);
			}

			@Override
			public ExternalContext getExternalContext() {
				return new ExternalContextWrapper() {

					@Override
					public ExternalContext getWrapped() {
						return facesContext.getExternalContext();
					}

					@Override
					public void redirect(String url) throws IOException {
						UIViewRoot oldRoot = getViewRoot();
						String oldViewId = oldRoot != null ? oldRoot.getViewId() : "null";
						super.redirect(url);
						OepeDebugLogger.log(String.format(
								"Page redirect executed to %s", url));
						getExternalContext().getSessionMap().put("_oepeFrom", from);
						getExternalContext().getSessionMap().put("_oepeOutcome", outcome);
						getExternalContext().getSessionMap().put("_oepeOldViewId", oldViewId);
					}
				};
			}

			@Override
			public FacesContext getWrapped() {
				return facesContext;
			}

		}, from, outcome);

		if (!messages.isEmpty()) {
			OepeDebugLogger.log(String
					.format("FacesMessages posted during navigation"));
			for (final Map.Entry<String, List<FacesMessage>> entry : messages
					.entrySet()) {
				List<FacesMessage> values = entry.getValue();
				for (final FacesMessage msg : values) {
					OepeDebugLogger.log(String.format(
							"\tClient id: %s, Message: %s", entry.getKey(),
							msg.getSummary()));
				}
			}
		}
	}

}
