package oracle.eclipse.tools.debug;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;

import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.model.CollectionModel;

public class ELVariableWriter {

	public static void writeVariable(final Object key, final Object value,
			final String scopeName, final String verb) {
		writeVariable(key, value, scopeName, verb, FacesContext.getCurrentInstance());
	}

	public static void writeVariable(final Object key, final Object value,
			final String scopeName, final String verb, FacesContext facesContext) {

		final String beanProps = ELVariableWriter.getBeanProps(value);
		final String beanMethods = ELVariableWriter.getBeanMethods(value);
		final String facesBeanProps = ELVariableWriter.getFacesBeanProps(value);
		final String mapProps = ELVariableWriter.getMapProps(value);
		final UIComponent currentComponent = UIComponent
				.getCurrentComponent(FacesContext.getCurrentInstance());
		if (currentComponent != null) {
			String location = "<unknown>";
			final Object object = currentComponent.getAttributes().get(
					UIComponent.VIEW_LOCATION_KEY);
			if (object instanceof Location) {
				location = object.toString();
			}
			OepeDebugLogger.log(String.format("%s scope variable '%s' %s inside component: %s at %s.  Value=%s.  Type=%s",
							scopeName, key, verb, currentComponent, location, value, value != null ? value.getClass() : "<unknown>"));
		} else {
			OepeDebugLogger.log(String.format(
					"%s scope variable '%s' %s.  Value=%s. Type=%s", scopeName, key, verb,
					value, value != null ? value.getClass() : "<unknown>"));
		}
		if (!"[]".equals(beanProps))
		{
			System.out.printf("\tBean Props=%s\n", beanProps);
		}
		if (!"[]".equals(beanMethods))
		{
			System.out.printf("\tMethods=%s\n", beanMethods);
		}
		if (!"[]".equals(facesBeanProps))
		{
			System.out.printf("\tFacesBean=%s\n", facesBeanProps);
		}
		if (!"[]".equals(mapProps))
		{
			System.out.printf("\tMap=%s\n", mapProps);
		}
	}

	@SuppressWarnings("rawtypes")
	public static String getMapProps(final Object value) {
		final StringBuilder builder = new StringBuilder("[");
		if (value instanceof Map) {
			for (final Object propKey : ((Map) value).entrySet()) {
				builder.append(propKey.toString());
				builder.append(",");
			}

			try {
				final Map hardcoded = (Map) value;
				Object object = hardcoded.get("model");
				if (object instanceof CollectionModel) {
					builder.append(String.format("model=[rowCount=%d],",
							((CollectionModel) object).getRowCount()));
				}

				object = hardcoded.get("index");
				if (object instanceof Integer) {
					builder.append(String.format("index=%d,", (Integer) object));
				}
			} catch (final Exception e) {
				// ignore. UIXInclude threw an illegal state
			}
		}

		if (builder.length() > 1) {
			builder.deleteCharAt(builder.length() - 1);
		}
		builder.append("]");
		return builder.toString();
	}

	public static String getFacesBeanProps(final Object value) {
		final StringBuilder builder = new StringBuilder("[");
		try
		{
			if (value instanceof FacesBean) {
				for (final PropertyKey propKey : ((FacesBean) value).keySet()) {
					builder.append(propKey.getName());
					builder.append(",");
				}
			}
	
			if (builder.length() > 1) {
				builder.deleteCharAt(builder.length() - 1);
			}
		}
		catch (NoClassDefFoundError e)
		{
			// ignore missing adf class errors
		}

		builder.append("]");
		return builder.toString();
	}

	public static String getBeanMethods(final Object value) {
		if (value == null) {
			return "[]";
		}
		try {
			final BeanInfo beanInfo = Introspector.getBeanInfo(
					value.getClass(), Object.class);
			final FeatureDescriptor[] featureDescriptors = beanInfo
					.getMethodDescriptors();
			final List<String> strings = featuresAsString(featureDescriptors);
			final Iterator<String> stringIt = strings.iterator();
			while (stringIt.hasNext()) {
				final String next = stringIt.next();
				if (next.startsWith("is") || next.startsWith("get")
						|| next.startsWith("set")) {
					stringIt.remove();
				}
			}
			return strings.toString();
		} catch (final IntrospectionException e) {
			// ignore
			return "[]";
		}
	}

	public static String getBeanProps(final Object value) {
		if (value == null) {
			return "[]";
		}
		try {
			final BeanInfo beanInfo = Introspector.getBeanInfo(
					value.getClass(), Object.class);
			final FeatureDescriptor[] featureDescriptors = beanInfo
					.getPropertyDescriptors();
			final List<String> strings = featuresAsString(featureDescriptors);
			return strings.toString();
		} catch (final IntrospectionException e) {
			// ignore
			return "[]";
		}
	}

	private static List<String> featuresAsString(
			final FeatureDescriptor[] descriptors) {
		final List<String> strings = new ArrayList<String>(descriptors.length);
		for (final FeatureDescriptor pd : descriptors) {
			strings.add(pd.getName());
		}
		return strings;
	}
}
