/*******************************************************************************
 * Copyright (c) 2010, 2013 Tasktop Technologies
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Tasktop Technologies - initial API and implementation
 ******************************************************************************/
package com.tasktop.c2c.server.common.service.web;

import java.net.URI;
import java.util.Map;

/**
 * 
 * A reset client delegate provides the implementation of common set of REST operations, which can be used by
 * AbstractRestServiceClient to access DCS REST services.
 * 
 * @See org.springframework.web.client.RestOperations
 * @author Danny Ju (danny.ju@oracle.com)
 * 
 */
public abstract class RestClientDelegate {

	/**
	 * Retrieve a representation by doing a GET on the specified URL. The response (if any) is converted and returned.
	 * <p>
	 * URI Template variables are expanded using the given URI variables, if any.
	 * 
	 * @param url
	 *            the URL
	 * @param responseType
	 *            the type of the return value
	 * @param uriVariables
	 *            the variables to expand the template
	 * @return the converted object
	 */
	public abstract <T> T getForObject(String url, Class<T> responseType, Object... uriVariables);

	/**
	 * Retrieve a representation by doing a GET on the URI template. The response (if any) is converted and returned.
	 * <p>
	 * URI Template variables are expanded using the given map.
	 * 
	 * @param url
	 *            the URL
	 * @param responseType
	 *            the type of the return value
	 * @param uriVariables
	 *            the map containing variables for the URI template
	 * @return the converted object
	 */
	public abstract <T> T getForObject(String url, Class<T> responseType, Map<String, ?> uriVariables);

	/**
	 * Retrieve a representation by doing a GET on the URL . The response (if any) is converted and returned.
	 * 
	 * @param url
	 *            the URL
	 * @param responseType
	 *            the type of the return value
	 * @return the converted object
	 */
	public abstract <T> T getForObject(URI url, Class<T> responseType);

	public abstract <T> T postForObject(String url, Object request, Class<T> responseType, Object... uriVariables);

	@SuppressWarnings({ "rawtypes" })
	public abstract Object postForEntity(String url, Object request, Class responseType, Map<String, ?> uriVariables);

	public abstract URI postForLocation(String url, Object request, Object... urlVariables);
        
	public abstract void deleteForObject(String url, Object... uriVariables);
        
	public abstract void deleteForObject(URI url);
}
