/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent;

import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.EntityPropertyElem;
import org.eclipse.jpt.jpa.annotate.util.AnnotateMappingUtil;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.AssociationAnnotationWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.JptJpaUiMakePersistentMessages;
import org.eclipse.jpt.jpa.ui.internal.wizards.makepersistent.SelectColumnDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DbColumnAnnotationCtl {
    private ResourceManager resourceManager;
    private EntityPropertyElem entityProp;
    private Table table;
    private Text colNameText;
    private Button colNameBrowseBtn;
    private Combo nullableCombo;
    private Button uniqueChkbox;
    private Text lengthText;
    private Text precisionText;
    private Text scaleText;
    private Combo insertableCombo;
    private Combo updatableCombo;
    private boolean isNumeric;
    private boolean isBasicMapping;

    public DbColumnAnnotationCtl(ResourceManager resourceManager, EntityPropertyElem entityProp, Table table) {
        this.resourceManager = resourceManager;
        this.entityProp = entityProp;
        this.table = table;
    }

    Composite createColumnGroup(Composite parent, int style) {
        Group colGroup = new Group(parent, 0);
        colGroup.setText(JptJpaUiMakePersistentMessages.COL_ANNOTATION_GROUP_DESC);
        GridLayout layout = new GridLayout(3, false);
        colGroup.setLayout((Layout)layout);
        colGroup.setLayoutData((Object)new GridData(768));
        AssociationAnnotationWizard.createLabel((Composite)colGroup, 1, JptJpaUiMakePersistentMessages.COLUMN_NAME, -1);
        this.colNameText = AssociationAnnotationWizard.createText((Composite)colGroup, true, 1, 2048);
        this.colNameBrowseBtn = AssociationAnnotationWizard.createImageButton((Composite)colGroup, this.resourceManager.createImage(JptJpaUiImages.LIST_OF_VALUES), 1, 0, JptJpaUiMakePersistentMessages.BROWSE);
        this.isBasicMapping = this.entityProp.getTagName().equals("basic");
        if (this.isBasicMapping) {
            AssociationAnnotationWizard.createLabel((Composite)colGroup, 1, JptJpaUiMakePersistentMessages.UNIQUE, -1);
            this.uniqueChkbox = AssociationAnnotationWizard.createButton((Composite)colGroup, 2, null, -1, 32);
        }
        AssociationAnnotationWizard.createLabel((Composite)colGroup, 1, JptJpaUiMakePersistentMessages.NULLABLE, -1);
        this.nullableCombo = AssociationAnnotationWizard.createCombo((Composite)colGroup, true, 1, 2060, -1);
        new Label((Composite)colGroup, 0);
        if (this.isBasicMapping) {
            AssociationAnnotationWizard.createLabel((Composite)colGroup, 1, JptJpaUiMakePersistentMessages.INSERTABLE, -1);
            this.insertableCombo = AssociationAnnotationWizard.createCombo((Composite)colGroup, true, 1, 2060, -1);
            new Label((Composite)colGroup, 0);
            AssociationAnnotationWizard.createLabel((Composite)colGroup, 1, JptJpaUiMakePersistentMessages.UPDATABLE, -1);
            this.updatableCombo = AssociationAnnotationWizard.createCombo((Composite)colGroup, true, 1, 2060, -1);
            new Label((Composite)colGroup, 0);
        }
        this.isNumeric = AnnotateMappingUtil.isNumeric((String)this.entityProp.getPropertyType());
        if (!this.isNumeric) {
            AssociationAnnotationWizard.createLabel((Composite)colGroup, 1, JptJpaUiMakePersistentMessages.LENGTH, -1);
            this.lengthText = AssociationAnnotationWizard.createText((Composite)colGroup, true, 1, 2048);
            new Label((Composite)colGroup, 0);
        } else {
            AssociationAnnotationWizard.createLabel((Composite)colGroup, 1, JptJpaUiMakePersistentMessages.PRECISION, -1);
            this.precisionText = AssociationAnnotationWizard.createText((Composite)colGroup, true, 1, 2048);
            new Label((Composite)colGroup, 0);
            AssociationAnnotationWizard.createLabel((Composite)colGroup, 1, JptJpaUiMakePersistentMessages.SCALE, -1);
            this.scaleText = AssociationAnnotationWizard.createText((Composite)colGroup, true, 1, 2048);
            new Label((Composite)colGroup, 0);
        }
        return colGroup;
    }

    void initFields() {
        ColumnAttributes colAttrs;
        String[] boolComboVals = new String[]{"true", "false"};
        this.nullableCombo.setItems(boolComboVals);
        if (this.isBasicMapping) {
            this.insertableCombo.setItems(boolComboVals);
            this.updatableCombo.setItems(boolComboVals);
        }
        if ((colAttrs = this.entityProp.getColumnAnnotationAttrs()) != null) {
            if (colAttrs.getName() != null) {
                this.colNameText.setText(colAttrs.getName());
            }
            if (colAttrs.isSetUnique() && this.isBasicMapping) {
                this.uniqueChkbox.setSelection(colAttrs.isUnique());
            }
            if (colAttrs.isSetNullable()) {
                if (colAttrs.isNullable()) {
                    this.nullableCombo.select(0);
                } else {
                    this.nullableCombo.select(1);
                }
            }
            if (!this.isNumeric) {
                if (colAttrs.isSetLength()) {
                    this.lengthText.setText(String.valueOf(colAttrs.getLength()));
                }
            } else {
                if (colAttrs.isSetPrecision()) {
                    this.precisionText.setText(String.valueOf(colAttrs.getPrecision()));
                }
                if (colAttrs.isSetScale()) {
                    this.scaleText.setText(String.valueOf(colAttrs.getScale()));
                }
            }
            if (this.isBasicMapping) {
                if (colAttrs.isSetInsertable()) {
                    if (colAttrs.isInsertable()) {
                        this.insertableCombo.select(0);
                    } else {
                        this.insertableCombo.select(1);
                    }
                }
                if (colAttrs.isSetUpdatable()) {
                    if (colAttrs.isUpdatable()) {
                        this.updatableCombo.select(0);
                    } else {
                        this.updatableCombo.select(1);
                    }
                }
            }
        }
    }

    void addListeners() {
        this.colNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DbColumnAnnotationCtl.this.handleColNameChange();
            }
        });
        this.colNameBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DbColumnAnnotationCtl.this.chooseColumn();
            }
        });
        if (this.isBasicMapping) {
            this.uniqueChkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DbColumnAnnotationCtl.this.handleUniqueChange();
                }
            });
        }
        this.nullableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DbColumnAnnotationCtl.this.handleNullableChange();
            }
        });
        if (this.lengthText != null) {
            this.lengthText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DbColumnAnnotationCtl.this.handleLengthChange();
                }
            });
        }
        if (this.precisionText != null) {
            this.precisionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DbColumnAnnotationCtl.this.handlePrecisionChange();
                }
            });
        }
        if (this.scaleText != null) {
            this.scaleText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DbColumnAnnotationCtl.this.handleScaleChange();
                }
            });
        }
        if (this.isBasicMapping) {
            this.insertableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DbColumnAnnotationCtl.this.handleInsertableChange();
                }
            });
            this.updatableCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DbColumnAnnotationCtl.this.handleUpdatableChange();
                }
            });
        }
    }

    private void handleColNameChange() {
        ColumnAttributes colAttrs = this.entityProp.getColumnAnnotationAttrs();
        this.entityProp.setDBColumn(this.table.getColumnNamed(this.colNameText.getText()));
        if (colAttrs == null) {
            colAttrs = new ColumnAttributes();
            colAttrs.setName(this.colNameText.getText());
            this.entityProp.setColumnAnnotationAttrs(colAttrs);
        } else {
            colAttrs.setName(this.colNameText.getText());
        }
    }

    private void chooseColumn() {
        SelectColumnDialog dlg = new SelectColumnDialog(Display.getDefault().getActiveShell(), this.table, this.entityProp.getPropertyName());
        if (dlg.open() == 0) {
            this.colNameText.setText(dlg.getSelectedColumn());
        }
    }

    private void handleUniqueChange() {
        boolean isUnique = this.uniqueChkbox.getSelection();
        ColumnAttributes colAttrs = this.entityProp.getColumnAnnotationAttrs();
        if (colAttrs == null) {
            colAttrs = new ColumnAttributes();
            colAttrs.setUnique(isUnique);
            this.entityProp.setColumnAnnotationAttrs(colAttrs);
        } else {
            colAttrs.setUnique(isUnique);
        }
    }

    private void handleNullableChange() {
        boolean nullable;
        int index = this.nullableCombo.getSelectionIndex();
        ColumnAttributes colAttrs = this.entityProp.getColumnAnnotationAttrs();
        boolean bl = nullable = index == 0;
        if (colAttrs == null) {
            colAttrs = new ColumnAttributes();
            colAttrs.setNullable(nullable);
            this.entityProp.setColumnAnnotationAttrs(colAttrs);
        } else {
            colAttrs.setNullable(nullable);
        }
    }

    private void handleLengthChange() {
        ColumnAttributes colAttrs = this.entityProp.getColumnAnnotationAttrs();
        if (colAttrs == null) {
            colAttrs = new ColumnAttributes();
            colAttrs.setLength(this.lengthText.getText());
            this.entityProp.setColumnAnnotationAttrs(colAttrs);
        } else {
            colAttrs.setLength(this.lengthText.getText());
        }
    }

    private void handleScaleChange() {
        ColumnAttributes colAttrs = this.entityProp.getColumnAnnotationAttrs();
        if (colAttrs == null) {
            colAttrs = new ColumnAttributes();
            colAttrs.setScale(this.scaleText.getText());
            this.entityProp.setColumnAnnotationAttrs(colAttrs);
        } else {
            colAttrs.setScale(this.scaleText.getText());
        }
    }

    private void handlePrecisionChange() {
        ColumnAttributes colAttrs = this.entityProp.getColumnAnnotationAttrs();
        if (colAttrs == null) {
            colAttrs = new ColumnAttributes();
            colAttrs.setPrecision(this.precisionText.getText());
            this.entityProp.setColumnAnnotationAttrs(colAttrs);
        } else {
            colAttrs.setPrecision(this.precisionText.getText());
        }
    }

    private void handleInsertableChange() {
        boolean insertable;
        int index = this.insertableCombo.getSelectionIndex();
        ColumnAttributes colAttrs = this.entityProp.getColumnAnnotationAttrs();
        boolean bl = insertable = index == 0;
        if (colAttrs == null) {
            colAttrs = new ColumnAttributes();
            colAttrs.setInsertable(insertable);
            this.entityProp.setColumnAnnotationAttrs(colAttrs);
        } else {
            colAttrs.setInsertable(insertable);
        }
    }

    private void handleUpdatableChange() {
        boolean updatable;
        int index = this.updatableCombo.getSelectionIndex();
        ColumnAttributes colAttrs = this.entityProp.getColumnAnnotationAttrs();
        boolean bl = updatable = index == 0;
        if (colAttrs == null) {
            colAttrs = new ColumnAttributes();
            colAttrs.setUpdatable(updatable);
            this.entityProp.setColumnAnnotationAttrs(colAttrs);
        } else {
            colAttrs.setUpdatable(updatable);
        }
    }
}

