/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.selection;

import java.util.Hashtable;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaPageSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaWorkbenchSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.SetJpaSelectionJob;
import org.eclipse.jpt.jpa.ui.selection.JpaSelectionManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

class JpaWindowSelectionManager
implements JpaSelectionManager,
SetJpaSelectionJob.Manager {
    private final JpaWorkbenchSelectionManager workbenchManager;
    private final IWorkbenchWindow window;
    private final Hashtable<IWorkbenchPage, JpaPageSelectionManager> pageManagers = new Hashtable();
    private static final String TRACE_OPTION = JpaSelectionManager.class.getSimpleName();

    JpaWindowSelectionManager(JpaWorkbenchSelectionManager workbenchManager, IWorkbenchWindow window) {
        this.workbenchManager = workbenchManager;
        this.window = window;
    }

    public void setSelection(JpaStructureNode selection) {
        new SetJpaSelectionJob(this, selection).schedule();
    }

    public void setSelection_(JpaStructureNode selection) {
        JpaPageSelectionManager manager;
        IWorkbenchPage page = this.window.getActivePage();
        if (page != null && (manager = this.pageManagers.get(page)) != null) {
            manager.setSelection_(selection);
        }
    }

    JpaPageSelectionManager getPageManager(IWorkbenchPage page) {
        return this.pageManagers.get(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JpaPageSelectionManager getPageManager_(IWorkbenchPage page) {
        Hashtable<IWorkbenchPage, JpaPageSelectionManager> hashtable = this.pageManagers;
        synchronized (hashtable) {
            JpaPageSelectionManager manager = this.pageManagers.get(page);
            if (manager == null) {
                JptJpaUiPlugin.instance().trace(TRACE_OPTION, "add page manager: {0}", new Object[]{page});
                manager = new JpaPageSelectionManager(this, page);
                this.pageManagers.put(page, manager);
            }
            return manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePageManager(IWorkbenchPage page) {
        Hashtable<IWorkbenchPage, JpaPageSelectionManager> hashtable = this.pageManagers;
        synchronized (hashtable) {
            JptJpaUiPlugin.instance().trace(TRACE_OPTION, "remove page manager: {0}", new Object[]{page});
            this.pageManagers.remove(page);
            if (this.pageManagers.isEmpty()) {
                this.dispose();
            }
        }
    }

    private void dispose() {
        this.workbenchManager.removeWindowManager(this.window);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.window);
    }

    static JpaWindowSelectionManager forWindow(IWorkbenchWindow window) {
        JpaWorkbenchSelectionManager manager = JpaWorkbenchSelectionManager.forWorkbench(window.getWorkbench());
        return manager == null ? null : manager.getWindowManager(window);
    }

    static JpaWindowSelectionManager forWindow_(IWorkbenchWindow window) {
        JpaWorkbenchSelectionManager wsm = JpaWorkbenchSelectionManager.forWorkbench_(window.getWorkbench());
        return wsm == null ? null : wsm.getWindowManager_(window);
    }
}

