/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.generic;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jpt.common.ui.internal.jface.AbstractItemExtendedLabelProvider;
import org.eclipse.jpt.common.ui.jface.ItemExtendedLabelProvider;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.model.value.CompositePropertyValueModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.JptJpaUiImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitItemLabelProvider
extends AbstractItemExtendedLabelProvider<PersistenceUnit> {
    public PersistenceUnitItemLabelProvider(PersistenceUnit persistenceUnit, ItemExtendedLabelProvider.Manager manager) {
        super((Object)persistenceUnit, manager);
    }

    protected ImageDescriptor getImageDescriptor() {
        return JptJpaUiImages.PERSISTENCE_UNIT;
    }

    protected PropertyValueModel<String> buildTextModel() {
        return new TextModel((PersistenceUnit)this.item);
    }

    protected PropertyValueModel<String> buildDescriptionModel() {
        return new DescriptionModel((PersistenceUnit)this.item);
    }

    public static PropertyValueModel<String> buildQuotedComponentDescriptionModel(JpaContextModel node, PropertyValueModel<String> nodeTextModel) {
        return PersistenceUnitItemLabelProvider.buildComponentDescriptionModel(node, true, nodeTextModel);
    }

    public static PropertyValueModel<String> buildNonQuotedComponentDescriptionModel(JpaContextModel node, PropertyValueModel<String> ... nodeTextModels) {
        return PersistenceUnitItemLabelProvider.buildComponentDescriptionModel(node, false, nodeTextModels);
    }

    protected static PropertyValueModel<String> buildComponentDescriptionModel(JpaContextModel node, boolean quote, PropertyValueModel<String> ... nodeTextModels) {
        IResource nodeResource = node.getResource();
        String nodePath = nodeResource == null ? null : nodeResource.getFullPath().makeRelative().toString();
        return new ComponentDescriptionModel(nodeTextModels, (PropertyValueModel<String>)new TextModel(node.getPersistenceUnit()), nodePath, quote);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComponentDescriptionModel
    extends CompositePropertyValueModel<String, Object> {
        protected final PropertyValueModel<String>[] nodeTextModels;
        protected final PropertyValueModel<String> persistenceUnitNameModel;
        protected final String path;
        protected final boolean quote;

        ComponentDescriptionModel(PropertyValueModel<String> nodeTextModel, PropertyValueModel<String> persistenceUnitNameModel, String path, boolean quote) {
            this(new PropertyValueModel[]{nodeTextModel}, persistenceUnitNameModel, path, quote);
        }

        ComponentDescriptionModel(PropertyValueModel<String>[] nodeTextModels, PropertyValueModel<String> persistenceUnitNameModel, String path, boolean quote) {
            super((PropertyValueModel[])ArrayTools.add((Object[])nodeTextModels, persistenceUnitNameModel));
            if (nodeTextModels.length < 1) {
                throw new IllegalArgumentException();
            }
            this.nodeTextModels = nodeTextModels;
            this.persistenceUnitNameModel = persistenceUnitNameModel;
            this.path = path;
            this.quote = quote;
        }

        protected String buildValue() {
            StringBuilder sb = new StringBuilder();
            sb.append((String)this.persistenceUnitNameModel.getValue());
            sb.append('/');
            if (this.quote) {
                sb.append('\"');
            }
            sb.append((String)this.nodeTextModels[0].getValue());
            int i = 1;
            while (i < this.nodeTextModels.length) {
                sb.append('/');
                sb.append((String)this.nodeTextModels[i].getValue());
                ++i;
            }
            if (this.quote) {
                sb.append('\"');
            }
            if (this.path != null) {
                sb.append(" - ");
                sb.append(this.path);
            }
            return sb.toString();
        }
    }

    protected static class DescriptionModel
    extends TextModel {
        public DescriptionModel(PersistenceUnit subject) {
            super(subject);
        }

        protected String buildValue_() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.buildValue_());
            sb.append(" - ");
            sb.append(((PersistenceUnit)this.subject).getResource().getFullPath().makeRelative());
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TextModel
    extends PropertyAspectAdapter<PersistenceUnit, String> {
        public TextModel(PersistenceUnit subject) {
            super("name", (Model)subject);
        }

        protected String buildValue_() {
            return ((PersistenceUnit)this.subject).getName();
        }
    }
}

