/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.OptionalMapping;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalTriStateCheckBox
extends Pane<OptionalMapping> {
    private TriStateCheckBox checkBox;

    public OptionalTriStateCheckBox(Pane<? extends OptionalMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected boolean addsComposite() {
        return false;
    }

    public Control getControl() {
        return this.checkBox.getCheckBox();
    }

    protected void initializeLayout(Composite container) {
        this.checkBox = this.addTriStateCheckBoxWithDefault(container, JptJpaUiDetailsMessages.BasicGeneralSection_optionalLabel, this.buildSpecifiedOptionalHolder(), this.buildOptionalStringHolder(), JpaHelpContextIds.MAPPING_OPTIONAL);
    }

    private ModifiablePropertyValueModel<Boolean> buildSpecifiedOptionalHolder() {
        return new PropertyAspectAdapter<OptionalMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedOptional"}){

            protected Boolean buildValue_() {
                return ((OptionalMapping)this.subject).getSpecifiedOptional();
            }

            protected void setValue_(Boolean value) {
                ((OptionalMapping)this.subject).setSpecifiedOptional(value);
            }
        };
    }

    private PropertyValueModel<String> buildOptionalStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultOptionalHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaUiDetailsMessages.BasicGeneralSection_optionalLabelDefault, (Object)defaultStringValue);
                }
                return JptJpaUiDetailsMessages.BasicGeneralSection_optionalLabel;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultOptionalHolder() {
        return new PropertyAspectAdapter<OptionalMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedOptional", "defaultOptional"}){

            protected Boolean buildValue_() {
                if (((OptionalMapping)this.subject).getSpecifiedOptional() != null) {
                    return null;
                }
                return ((OptionalMapping)this.subject).isDefaultOptional();
            }
        };
    }
}

