/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.node.AbstractNode;
import org.eclipse.jpt.common.utility.node.Node;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AddQueryStateObject
extends AbstractNode {
    private String name;
    private String queryType;
    private Node.Validator validator;
    private PersistenceUnit pUnit;
    static final String NAME_PROPERTY = "nameProperty";
    static final String QUERY_TYPE_PROPERTY = "queryTypeProperty";

    public AddQueryStateObject(PersistenceUnit pUnit) {
        super(null);
        this.pUnit = pUnit;
    }

    private void addNameProblemsTo(List<Node.Problem> currentProblems) {
        if (StringTools.isBlank((String)this.name)) {
            currentProblems.add(this.buildProblem(JptJpaUiDetailsMessages.QueryStateObject_nameMustBeSpecified, 3));
        } else if (this.names().contains(this.name)) {
            currentProblems.add(this.buildProblem(JptJpaUiDetailsMessages.AddQueryDialog_nameExists, 2));
        }
    }

    private void addQueryTypeProblemsTo(List<Node.Problem> currentProblems) {
        if (StringTools.isBlank((String)this.queryType)) {
            currentProblems.add(this.buildProblem(JptJpaUiDetailsMessages.QueryStateObject_typeMustBeSpecified, 3));
        }
    }

    protected void addProblemsTo(List<Node.Problem> currentProblems) {
        super.addProblemsTo(currentProblems);
        this.addNameProblemsTo(currentProblems);
        this.addQueryTypeProblemsTo(currentProblems);
    }

    private List<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        for (Query query : this.pUnit.getQueries()) {
            String name = query.getName();
            names.add(name);
        }
        return names;
    }

    protected void checkParent(Node parentNode) {
    }

    public String displayString() {
        return null;
    }

    String getName() {
        return this.name;
    }

    String getQueryType() {
        return this.queryType;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged(NAME_PROPERTY, oldName, newName);
    }

    public void setQueryType(String newQueryType) {
        String old = this.queryType;
        this.queryType = newQueryType;
        this.firePropertyChanged(QUERY_TYPE_PROPERTY, old, newQueryType);
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }
}

