/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.ArrayList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jpt.common.ui.internal.widgets.DialogPane;
import org.eclipse.jpt.common.ui.internal.widgets.ValidatingDialog;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.StaticListValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.details.AddQueryStateObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddQueryDialog
extends ValidatingDialog<AddQueryStateObject> {
    public static final String NAMED_QUERY = "namedQuery";
    public static final String NAMED_NATIVE_QUERY = "namedNativeQuery";
    private final PersistenceUnit pUnit;

    public AddQueryDialog(Shell parentShell, ResourceManager resourceManager, PersistenceUnit pUnit) {
        super(parentShell, resourceManager, JptJpaUiDetailsMessages.AddQueryDialog_title);
        this.pUnit = pUnit;
    }

    protected AddQueryStateObject buildStateObject() {
        return new AddQueryStateObject(this.pUnit);
    }

    protected String getDescriptionTitle() {
        return JptJpaUiDetailsMessages.AddQueryDialog_descriptionTitle;
    }

    protected String getDescription() {
        return JptJpaUiDetailsMessages.AddQueryDialog_description;
    }

    protected DialogPane<AddQueryStateObject> buildLayout(Composite container) {
        return new QueryDialogPane((PropertyValueModel<AddQueryStateObject>)this.getSubjectHolder(), container, this.resourceManager);
    }

    public void create() {
        super.create();
        QueryDialogPane pane = (QueryDialogPane)this.getPane();
        pane.selectAll();
        this.getButton(0).setEnabled(false);
    }

    public String getName() {
        return ((AddQueryStateObject)this.getSubject()).getName();
    }

    public String getQueryType() {
        return ((AddQueryStateObject)this.getSubject()).getQueryType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class QueryDialogPane
    extends DialogPane<AddQueryStateObject> {
        private Text nameText;

        public QueryDialogPane(PropertyValueModel<AddQueryStateObject> subjectModel, Composite parentComposite, ResourceManager resourceManager) {
            super(subjectModel, parentComposite, resourceManager);
        }

        protected Composite addComposite(Composite container) {
            return this.addSubPane(container, 2, 0, 0, 0, 0);
        }

        protected void initializeLayout(Composite container) {
            this.addLabel(container, JptJpaUiDetailsMessages.AddQueryDialog_name);
            this.nameText = this.addText(container, this.buildNameHolder());
            this.addLabel(container, JptJpaUiDetailsMessages.AddQueryDialog_queryType);
            this.addCombo(container, this.buildQueryTypeListHolder(), this.buildQueryTypeHolder(), this.buildStringConverter(), null);
        }

        public ListValueModel<String> buildQueryTypeListHolder() {
            ArrayList<String> queryTypes = new ArrayList<String>();
            queryTypes.add(AddQueryDialog.NAMED_QUERY);
            queryTypes.add(AddQueryDialog.NAMED_NATIVE_QUERY);
            return new StaticListValueModel(queryTypes);
        }

        public Transformer<String, String> buildStringConverter() {
            return new QueryTypeLabelTransformer();
        }

        private ModifiablePropertyValueModel<String> buildNameHolder() {
            return new PropertyAspectAdapter<AddQueryStateObject, String>(this.getSubjectHolder(), new String[]{"nameProperty"}){

                protected String buildValue_() {
                    return ((AddQueryStateObject)((Object)this.subject)).getName();
                }

                protected void setValue_(String value) {
                    ((AddQueryStateObject)((Object)this.subject)).setName(value);
                }
            };
        }

        private ModifiablePropertyValueModel<String> buildQueryTypeHolder() {
            return new PropertyAspectAdapter<AddQueryStateObject, String>(this.getSubjectHolder(), new String[]{"queryTypeProperty"}){

                protected String buildValue_() {
                    return ((AddQueryStateObject)((Object)this.subject)).getQueryType();
                }

                protected void setValue_(String value) {
                    ((AddQueryStateObject)((Object)this.subject)).setQueryType(value);
                }
            };
        }

        void selectAll() {
            this.nameText.selectAll();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class QueryTypeLabelTransformer
        extends TransformerAdapter<String, String> {
            QueryTypeLabelTransformer() {
            }

            public String transform(String value) {
                if (value == AddQueryDialog.NAMED_QUERY) {
                    return JptJpaUiDetailsMessages.AddQueryDialog_namedQuery;
                }
                if (value == AddQueryDialog.NAMED_NATIVE_QUERY) {
                    return JptJpaUiDetailsMessages.AddQueryDialog_namedNativeQuery;
                }
                return value;
            }
        }
    }
}

