/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.commands;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.ServiceLocator;
import org.eclipse.epp.internal.mpc.core.service.Catalog;
import org.eclipse.epp.internal.mpc.core.service.CatalogService;
import org.eclipse.epp.internal.mpc.core.service.Category;
import org.eclipse.epp.internal.mpc.core.service.Market;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.commands.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.ComboTagFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizardDialog;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogFilter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceWizardCommand
extends AbstractHandler
implements IHandler {
    private List<CatalogDescriptor> catalogDescriptors;
    private CatalogDescriptor selectedCatalogDescriptor;
    private String wizardState;
    private Map<String, Operation> operationByNodeId;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final MarketplaceCatalog catalog = new MarketplaceCatalog();
        catalog.setEnvironment(DiscoveryCore.createEnvironment());
        catalog.setVerifyUpdateSiteAvailability(false);
        MarketplaceCatalogConfiguration configuration = new MarketplaceCatalogConfiguration();
        configuration.setVerifyUpdateSiteAvailability(false);
        if (this.catalogDescriptors == null || this.catalogDescriptors.isEmpty()) {
            IStatus remoteCatalogStatus = this.installRemoteCatalogs();
            configuration.getCatalogDescriptors().addAll(CatalogRegistry.getInstance().getCatalogDescriptors());
            if (configuration.getCatalogDescriptors().isEmpty()) {
                Object cause = !remoteCatalogStatus.isOK() ? remoteCatalogStatus : new Status(4, "org.eclipse.epp.mpc.ui", Messages.MarketplaceWizardCommand_noRemoteCatalogs);
                Status exitStatus = new Status(4, "org.eclipse.epp.mpc.ui", cause.getCode(), Messages.MarketplaceWizardCommand_cannotOpenMarketplace, (Throwable)new CoreException(cause));
                StatusManager.getManager().handle((IStatus)exitStatus, 7);
                return null;
            }
            if (!remoteCatalogStatus.isOK()) {
                StatusManager.getManager().handle(remoteCatalogStatus, 1);
            }
        } else {
            configuration.getCatalogDescriptors().addAll(this.catalogDescriptors);
        }
        if (this.selectedCatalogDescriptor != null) {
            if (this.selectedCatalogDescriptor.getLabel().equals("org.eclipse.epp.mpc.descriptorHint")) {
                CatalogDescriptor resolvedDescriptor = CatalogRegistry.getInstance().findCatalogDescriptor(this.selectedCatalogDescriptor.getUrl().toExternalForm());
                if (resolvedDescriptor == null) {
                    Status status = new Status(4, "org.eclipse.epp.mpc.ui", Messages.MarketplaceWizardCommand_CouldNotFindMarketplaceForSolution, (Throwable)new ExecutionException(this.selectedCatalogDescriptor.getUrl().toExternalForm()));
                    StatusManager.getManager().handle((IStatus)status, 7);
                    return null;
                }
                configuration.setCatalogDescriptor(resolvedDescriptor);
            } else {
                configuration.setCatalogDescriptor(this.selectedCatalogDescriptor);
            }
        }
        configuration.getFilters().clear();
        final ComboTagFilter marketFilter = new ComboTagFilter(){

            public void catalogUpdated(boolean wasCancelled) {
                ArrayList<Tag> choices = new ArrayList<Tag>();
                for (CatalogCategory category : catalog.getCategories()) {
                    if (!(category instanceof MarketplaceCategory)) continue;
                    MarketplaceCategory marketplaceCategory = (MarketplaceCategory)category;
                    for (Market market : marketplaceCategory.getMarkets()) {
                        Tag marketTag = new Tag(Market.class, market.getId(), market.getName());
                        marketTag.setData((Object)market);
                        choices.add(marketTag);
                    }
                }
                this.setChoices(choices);
            }
        };
        marketFilter.setSelectAllOnNoSelection(true);
        marketFilter.setNoSelectionLabel(Messages.MarketplaceWizardCommand_allMarkets);
        marketFilter.setTagClassification(Category.class);
        marketFilter.setChoices(new ArrayList<Tag>());
        final ComboTagFilter marketCategoryTagFilter = new ComboTagFilter(){

            public void catalogUpdated(boolean wasCancelled) {
                MarketplaceWizardCommand.this.updateCategoryChoices(this, marketFilter);
            }
        };
        marketCategoryTagFilter.setSelectAllOnNoSelection(true);
        marketCategoryTagFilter.setNoSelectionLabel(Messages.MarketplaceWizardCommand_allCategories);
        marketCategoryTagFilter.setTagClassification(Category.class);
        marketCategoryTagFilter.setChoices(new ArrayList<Tag>());
        IPropertyChangeListener marketListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("selected".equals(property)) {
                    MarketplaceWizardCommand.this.updateCategoryChoices(marketCategoryTagFilter, marketFilter);
                }
            }
        };
        marketFilter.addPropertyChangeListener(marketListener);
        configuration.getFilters().add(marketFilter);
        configuration.getFilters().add(marketCategoryTagFilter);
        configuration.setInitialState(this.wizardState);
        if (this.operationByNodeId != null && !this.operationByNodeId.isEmpty()) {
            configuration.setInitialOperationByNodeId(this.operationByNodeId);
        }
        for (CatalogFilter filter : configuration.getFilters()) {
            ((MarketplaceFilter)filter).setCatalog(catalog);
        }
        MarketplaceWizard wizard = new MarketplaceWizard(catalog, configuration);
        wizard.setWindowTitle(Messages.MarketplaceWizardCommand_eclipseMarketplace);
        MarketplaceWizardDialog dialog = new MarketplaceWizardDialog(WorkbenchUtil.getShell(), wizard);
        dialog.open();
        return null;
    }

    private void updateCategoryChoices(ComboTagFilter marketCategoryTagFilter, ComboTagFilter marketFilter) {
        HashSet<Tag> newChoices = new HashSet<Tag>();
        ArrayList<Tag> choices = new ArrayList<Tag>();
        HashSet<Market> selectedMarkets = new HashSet<Market>();
        for (Tag marketTag : marketFilter.getSelected()) {
            selectedMarkets.add((Market)marketTag.getData());
        }
        MarketplaceCatalog catalog = (MarketplaceCatalog)marketCategoryTagFilter.getCatalog();
        for (CatalogCategory category : catalog.getCategories()) {
            if (!(category instanceof MarketplaceCategory)) continue;
            MarketplaceCategory marketplaceCategory = (MarketplaceCategory)category;
            for (Market market : marketplaceCategory.getMarkets()) {
                if (!selectedMarkets.isEmpty() && !selectedMarkets.contains(market)) continue;
                for (Category marketCategory : market.getCategory()) {
                    Tag categoryTag = new Tag(Category.class, marketCategory.getId(), marketCategory.getName());
                    categoryTag.setData((Object)marketCategory);
                    if (!newChoices.add(categoryTag)) continue;
                    choices.add(categoryTag);
                }
            }
        }
        Collections.sort(choices, new Comparator<Tag>(){

            @Override
            public int compare(Tag o1, Tag o2) {
                return o1.getLabel().compareTo(o2.getLabel());
            }
        });
        marketCategoryTagFilter.setChoices(choices);
    }

    public void setCatalogDescriptors(List<CatalogDescriptor> catalogDescriptors) {
        this.catalogDescriptors = catalogDescriptors;
    }

    public void setSelectedCatalogDescriptor(CatalogDescriptor selectedCatalogDescriptor) {
        this.selectedCatalogDescriptor = selectedCatalogDescriptor;
    }

    public void setWizardState(String wizardState) {
        this.wizardState = wizardState;
    }

    public void setOperationByNodeId(Map<String, Operation> operationByNodeId) {
        this.operationByNodeId = operationByNodeId;
    }

    public IStatus installRemoteCatalogs() {
        try {
            final AtomicReference result = new AtomicReference();
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CatalogService catalogService = ServiceLocator.getInstance().getCatalogService();
                        List catalogs = catalogService.listCatalogs(monitor);
                        result.set(catalogs);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            List catalogs = (List)result.get();
            for (Catalog catalog : catalogs) {
                CatalogDescriptor descriptor = new CatalogDescriptor();
                descriptor.setLabel(catalog.getName());
                descriptor.setUrl(new URL(catalog.getUrl()));
                descriptor.setIcon(ImageDescriptor.createFromURL((URL)new URL(catalog.getImageUrl())));
                descriptor.setDescription(catalog.getDescription());
                descriptor.setInstallFromAllRepositories(!catalog.isSelfContained());
                if (catalog.getDependencyRepository() != null) {
                    descriptor.setDependenciesRepository(new URL(catalog.getDependencyRepository()));
                }
                this.registerOrOverrideCatalog(descriptor);
                CatalogRegistry.getInstance().addCatalogBranding(descriptor, catalog.getBranding());
                if (catalog.getNews() == null) continue;
                CatalogRegistry.getInstance().addCatalogNews(descriptor, catalog.getNews());
            }
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception e) {
            IStatus status = MarketplaceClientUi.computeStatus(e, Messages.MarketplaceWizardCommand_CannotInstallRemoteLocations);
            return status;
        }
        return Status.OK_STATUS;
    }

    private void registerOrOverrideCatalog(CatalogDescriptor descriptor) {
        CatalogRegistry catalogRegistry = CatalogRegistry.getInstance();
        List<CatalogDescriptor> descriptors = catalogRegistry.getCatalogDescriptors();
        for (CatalogDescriptor catalogDescriptor : descriptors) {
            if (!catalogDescriptor.getUrl().toExternalForm().equals(descriptor.getUrl().toExternalForm())) continue;
            catalogRegistry.unregister(catalogDescriptor);
        }
        catalogRegistry.register(descriptor);
    }
}

