/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.util.ClassLoaderAwareObjectInputStream;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.classloader.MultiParentClassLoader;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class SerializationUtil {
    private static Object classloaderLock = new Object();
    private static MultiParentClassLoader classloader = null;
    private final ObjectOutputStream out;
    private final ObjectInputStream in;
    private IWorkspaceRoot wsRoot = null;

    public static SerializationUtil forInput(ObjectInputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("Input Stream is null.");
        }
        return new SerializationUtil(null, in);
    }

    public static SerializationUtil forOutput(ObjectOutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("Output Stream is null.");
        }
        return new SerializationUtil(out, null);
    }

    private SerializationUtil(ObjectOutputStream out, ObjectInputStream in) {
        this.out = out;
        this.in = in;
    }

    public void writeResource(IResource resource) throws IOException {
        String pathString = null;
        if (resource != null) {
            if (resource.getType() == 4) {
                this.out.writeObject(resource.getName());
                this.out.writeInt(resource.getType());
                return;
            }
            IPath path = null;
            path = resource.getFullPath();
            if (path != null && (pathString = path.toPortableString()) != null) {
                this.out.writeObject(pathString);
                this.out.writeInt(resource.getType());
                return;
            }
        }
        this.out.writeObject(null);
    }

    public IResource readResource() throws IOException, ClassNotFoundException {
        Object pathString = this.in.readObject();
        if (pathString == null) {
            return null;
        }
        int resourceType = this.in.readInt();
        if (pathString instanceof String) {
            switch (resourceType) {
                case 1: {
                    return this.getWorkspaceRoot().getFile((IPath)new Path((String)pathString));
                }
                case 2: {
                    return this.getWorkspaceRoot().getFolder((IPath)new Path((String)pathString));
                }
                case 4: {
                    return this.getWorkspaceRoot().getProject((String)pathString);
                }
                case 8: {
                    return this.getWorkspaceRoot();
                }
            }
            throw new IllegalStateException("Corrupted data stream.");
        }
        throw new IllegalStateException("Current data in stream is not of correct type.");
    }

    public IProject readProject() throws IOException, ClassNotFoundException {
        IResource resource = this.readResource();
        if (resource == null) {
            return null;
        }
        if (resource.getType() == 4) {
            IProject project = (IProject)resource;
            if (!project.isAccessible()) {
                throw new IllegalStateException("Stream refers to inaccessible project.");
            }
            return (IProject)resource;
        }
        throw new IllegalStateException("Deserialized resource was not a project.");
    }

    public IFile readFile() throws IOException, ClassNotFoundException {
        IResource resource = this.readResource();
        if (resource == null) {
            return null;
        }
        if (resource.getType() == 1) {
            return (IFile)resource;
        }
        throw new IllegalStateException("Deserialized resource was not a file.");
    }

    public void readFinalFieldFromStream(Object object, String fieldName, Class fieldType) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        Object streamObject = null;
        if (fieldType.isPrimitive()) {
            String typeClassName = fieldType.getName();
            if (typeClassName.equals(Boolean.TYPE.getName())) {
                streamObject = this.in.readBoolean();
            } else if (typeClassName.equals(Character.TYPE.getName())) {
                streamObject = Character.valueOf(this.in.readChar());
            } else if (typeClassName.equals(Byte.TYPE.getName())) {
                streamObject = this.in.readByte();
            } else if (typeClassName.equals(Short.TYPE.getName())) {
                streamObject = this.in.readShort();
            } else if (typeClassName.equals(Integer.TYPE.getName())) {
                streamObject = this.in.readInt();
            } else if (typeClassName.equals(Long.TYPE.getName())) {
                streamObject = this.in.readLong();
            } else if (typeClassName.equals(Float.TYPE.getName())) {
                streamObject = Float.valueOf(this.in.readFloat());
            } else if (typeClassName.equals(Double.TYPE.getName())) {
                streamObject = this.in.readDouble();
            }
        } else {
            streamObject = this.in.readObject();
        }
        this.setFinalField(object, fieldName, fieldType, streamObject);
    }

    public void readFinalResourceFromStream(Object object, String fieldName) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        IResource resource = this.readResource();
        this.setFinalField(object, fieldName, IResource.class, resource);
    }

    public void readFinalFileFromStream(Object object, String fieldName) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        IFile file = this.readFile();
        this.setFinalField(object, fieldName, IFile.class, file);
    }

    public void readFinalProjectFromStream(Object object, String fieldName) throws IOException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException {
        IProject project = this.readProject();
        this.setFinalField(object, fieldName, IProject.class, project);
    }

    private final synchronized IWorkspaceRoot getWorkspaceRoot() {
        if (this.wsRoot == null) {
            this.wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        }
        return this.wsRoot;
    }

    public void setFinalField(Object object, String fieldName, Class<?> fieldType, Object value) throws IllegalArgumentException, IllegalAccessException {
        Field finalField = this.getField(object.getClass(), fieldName);
        if (finalField == null) {
            throw new IllegalArgumentException("Program Error: No such Field, " + fieldName);
        }
        if (value != null && !fieldType.isPrimitive() && !fieldType.isAssignableFrom(value.getClass())) {
            throw new IllegalStateException("Current data in stream is not of correct type.");
        }
        finalField.set(object, value);
    }

    private Field getField(Class clazz, String fieldName) {
        Field field = null;
        Class classWithField = clazz;
        do {
            if ((field = this.searchFields(classWithField.getDeclaredFields(), fieldName)) == null) continue;
            field.setAccessible(true);
            return field;
        } while ((classWithField = classWithField.getSuperclass()) != null);
        return null;
    }

    private Field searchFields(Field[] fields, String name) {
        String internedName = name.intern();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName() == internedName) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    public static ObjectInputStream getInputStream(IProject project, String filePrefix) throws CoreException, IOException {
        File file = SerializationUtil.getSerializedFile(project, filePrefix, true);
        if (file == null || !file.exists() || !file.canRead()) {
            return null;
        }
        return SerializationUtil.getObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
    }

    public static ObjectOutputStream getOutputStream(IProject project, String filePrefix) throws CoreException, IOException {
        File serializedFile = SerializationUtil.getSerializedFile(project, filePrefix, true);
        if (serializedFile == null) {
            throw new CoreException((IStatus)new Status(4, "oracle.eclipse.tools.common.services", "Unalbe to retrieve serialized data location."));
        }
        return new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(serializedFile)));
    }

    public static void deleteSerializedState(IProject project) {
        File serializedDataFolder = SerializationUtil.getSerializedFolder(project);
        if (serializedDataFolder != null && serializedDataFolder.exists()) {
            if (serializedDataFolder.isDirectory()) {
                File[] files;
                File[] fileArray = files = serializedDataFolder.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
            serializedDataFolder.delete();
        }
    }

    private static IPath getSerializedPath(IProject project) {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        if (project == null) {
            return activator.getStateLocation();
        }
        return activator.getStateLocation().append(project.getName());
    }

    private static File getSerializedFolder(IProject project) {
        IPath serializedPath = SerializationUtil.getSerializedPath(project);
        return serializedPath == null ? null : serializedPath.toFile();
    }

    public static File getSerializedFile(IProject project, String fileName, boolean createDirs) {
        if (project == null) {
            return null;
        }
        File serializedDataFolder = SerializationUtil.getSerializedFolder(project);
        if (serializedDataFolder == null) {
            return null;
        }
        if (createDirs) {
            serializedDataFolder.mkdirs();
        } else if (!serializedDataFolder.exists()) {
            return null;
        }
        return new File(serializedDataFolder, fileName);
    }

    public static File getSerializedFile(String fileName, boolean createDirs) {
        File serializedDataFolder = SerializationUtil.getSerializedFolder(null);
        if (serializedDataFolder == null) {
            return null;
        }
        if (createDirs) {
            serializedDataFolder.mkdirs();
        } else if (!serializedDataFolder.exists()) {
            return null;
        }
        return new File(serializedDataFolder, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectInputStream getObjectInputStream(InputStream istream) throws IOException {
        ObjectInputStream ois = null;
        Object object = classloaderLock;
        synchronized (object) {
            Set<String> pluginIDs;
            if (classloader == null && !(pluginIDs = SerializationUtil.getDeserializePluginIds()).isEmpty()) {
                HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
                for (String curPlugin : pluginIDs) {
                    ClassLoader curLoader = SerializationUtil.getPluginClassLoader(curPlugin);
                    if (curLoader == null) continue;
                    classLoaders.add(curLoader);
                }
                classloader = new MultiParentClassLoader(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
            }
        }
        ois = classloader != null ? new ClassLoaderAwareObjectInputStream(istream, (ClassLoader)classloader) : new ObjectInputStream(istream);
        return ois;
    }

    private static Set<String> getDeserializePluginIds() {
        IConfigurationElement[] contributions;
        HashSet<String> pluginIds = new HashSet<String>();
        IExtensionRegistry extensionReg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = contributions = extensionReg.getConfigurationElementsFor("oracle.eclipse.tools.common.services.artifactContributor");
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement curElem = iConfigurationElementArray[n2];
            String nspace = curElem.getNamespaceIdentifier();
            pluginIds.add(nspace);
            ++n2;
        }
        return pluginIds;
    }

    private static ClassLoader getPluginClassLoader(String pluginID) {
        String activatorClassName;
        Class activatorClass;
        Object activatorHeader;
        ClassLoader pluginLoader = null;
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle != null && (activatorHeader = bundle.getHeaders().get("Bundle-Activator")) != null && (activatorClass = PluginUtil.loadClass((String)pluginID, (String)(activatorClassName = activatorHeader.toString()))) != null && (pluginLoader = activatorClass.getClassLoader()) == null) {
            LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("failed to get classloader for plugin:" + pluginID));
        }
        return pluginLoader;
    }

    public static enum MARKER {
        END;

    }
}

