/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.document.IDocument;
import oracle.eclipse.tools.common.services.documentservices.TechComposingDocumentService;
import oracle.eclipse.tools.common.services.util.INavigationCaseProvider;
import oracle.eclipse.tools.common.util.ObjectUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class NavigationCaseDocumentServiceFactory
extends TechComposingDocumentService<INavigationCaseProvider>
implements INavigationCaseProvider {
    public static INavigationCaseProvider getNavigationCaseProvider(IFile file) {
        IDocument document;
        if (file != null && (document = (IDocument)file.getAdapter(IDocument.class)) != null) {
            return (INavigationCaseProvider)document.getAdapter(INavigationCaseProvider.class);
        }
        return null;
    }

    public static Collection<? extends IArtifact> filterByName(Collection<? extends IArtifact> artifacts, String name) {
        ArrayList<IArtifact> namedArtifacts = new ArrayList<IArtifact>(artifacts.size() / 2);
        for (IArtifact iArtifact : artifacts) {
            if (!ObjectUtil.equals((Object)name, (Object)iArtifact.getName())) continue;
            namedArtifacts.add(iArtifact);
        }
        return namedArtifacts;
    }

    public NavigationCaseDocumentServiceFactory(IDocument doc) {
        super(doc);
    }

    @Override
    public Collection<? extends IArtifact> getFromNavigationCases() {
        List<INavigationCaseProvider> providers = this.createComposedServiceList(INavigationCaseProvider.class);
        HashSet<? extends IArtifact> artifacts = new HashSet<IArtifact>();
        for (INavigationCaseProvider provider : providers) {
            artifacts.addAll(provider.getFromNavigationCases());
        }
        return artifacts;
    }

    @Override
    public Collection<? extends IArtifact> getToNavigationCases() {
        List<INavigationCaseProvider> providers = this.createComposedServiceList(INavigationCaseProvider.class);
        HashSet<? extends IArtifact> artifacts = new HashSet<IArtifact>();
        for (INavigationCaseProvider provider : providers) {
            artifacts.addAll(provider.getToNavigationCases());
        }
        return artifacts;
    }

    @Override
    public IArtifact getToArtifact(IArtifact navigationCase) {
        List<INavigationCaseProvider> providers = this.createComposedServiceList(INavigationCaseProvider.class);
        for (INavigationCaseProvider provider : providers) {
            IArtifact artifact = provider.getToArtifact(navigationCase);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    @Override
    public IResource getToArtifactResource(IArtifact navigationCase, IArtifact toArtifact) {
        List<INavigationCaseProvider> providers = this.createComposedServiceList(INavigationCaseProvider.class);
        for (INavigationCaseProvider provider : providers) {
            IResource resource = provider.getToArtifactResource(navigationCase, toArtifact);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }
}

