/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.lang.reflect.Array;

public final class HashCodeUtil {
    private static final int SEED = 17;
    private static final int MULT = 37;
    private int hashCode = 17;

    public static HashCodeUtil newInstance() {
        return new HashCodeUtil();
    }

    private HashCodeUtil() {
    }

    public HashCodeUtil hash(int value) {
        this.hashCode = 37 * this.hashCode + value;
        return this;
    }

    public HashCodeUtil hash(char value) {
        return this.hash((int)value);
    }

    public HashCodeUtil hash(short value) {
        return this.hash((int)value);
    }

    public HashCodeUtil hash(byte value) {
        return this.hash((int)value);
    }

    public HashCodeUtil hash(boolean bool) {
        return this.hash(bool ? 0 : 1);
    }

    public HashCodeUtil hash(long value) {
        return this.hash((int)(value ^ value >>> 32));
    }

    public HashCodeUtil hash(float value) {
        return this.hash(Float.floatToIntBits(value));
    }

    public HashCodeUtil hash(double value) {
        return this.hash(Double.doubleToLongBits(value));
    }

    public HashCodeUtil hash(Object value) {
        if (value == null) {
            return this.hash(0);
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                return this.hash(0);
            }
            int i = 0;
            while (i < length) {
                this.hash(Array.get(value, i));
                ++i;
            }
            return this;
        }
        return this.hash(value.hashCode());
    }

    public int getHashCode() {
        return this.hashCode;
    }
}

