/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultUniqueIdGenerator {
    private static char[] badChars = new char[]{' ', '&', '$', '/', '-'};

    private static String cleanUpObjectId(String sValue) {
        String sNewValue = sValue;
        int i = 0;
        while (i < badChars.length) {
            if (sNewValue.indexOf(badChars[i]) != -1) {
                sNewValue = sNewValue.replace(badChars[i], '_');
            }
            ++i;
        }
        return sNewValue;
    }

    public String generateUniqueId(Collection<String> ids, String baseName) {
        int nIndex = 1;
        String sControlName = baseName;
        String sBaseControlName = DefaultUniqueIdGenerator.cleanUpObjectId(sControlName);
        String sValue = String.valueOf(sBaseControlName) + nIndex;
        while (ids.contains(sValue)) {
            sValue = nIndex > 0 ? String.valueOf(sBaseControlName) + nIndex : sBaseControlName;
            ++nIndex;
        }
        return sValue;
    }

    public Set<String> getIDs(Element element) {
        return this.getAttributes(element, "id");
    }

    public Set<String> getAttributes(Element element, String attr) {
        HashSet<String> ids = new HashSet<String>();
        if (element != null) {
            NodeList nodes = element.getElementsByTagName("*");
            int i = 0;
            int size = nodes.getLength();
            while (i < size) {
                String idValue;
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && (idValue = ((Element)node).getAttribute(attr)) != null && !idValue.isEmpty()) {
                    ids.add(idValue);
                }
                ++i;
            }
            return ids;
        }
        return Collections.emptySet();
    }
}

