/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ClassLoaderAwareObjectInputStream
extends ObjectInputStream {
    private final ClassLoader deserializationLoader;

    public ClassLoaderAwareObjectInputStream(InputStream in, ClassLoader cl) throws IOException {
        super(in);
        this.deserializationLoader = cl;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        if ("int".equals(name)) {
            return Integer.TYPE;
        }
        if ("double".equals(name)) {
            return Double.TYPE;
        }
        if ("boolean".equals(name)) {
            return Boolean.TYPE;
        }
        if ("float".equals(name)) {
            return Float.TYPE;
        }
        if ("byte".equals(name)) {
            return Byte.TYPE;
        }
        if ("long".equals(name)) {
            return Long.TYPE;
        }
        if ("short".equals(name)) {
            return Short.TYPE;
        }
        if ("char".equals(name)) {
            return Character.TYPE;
        }
        return Class.forName(name, false, this.deserializationLoader);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] intfClasses = new Class[interfaces.length];
        int i = 0;
        String[] stringArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            intfClasses[i++] = Class.forName(interfaceName, false, this.deserializationLoader);
            ++n2;
        }
        return Proxy.getProxyClass(this.deserializationLoader, intfClasses);
    }
}

