/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.transaction.DataSourceBuilder;
import oracle.eclipse.tools.common.services.transaction.IDataSource;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class DataSourceExtensionReader {
    public static final String EXT_PT = "dataSource";
    private static final List<DataSourceBuilder> sDATA_SOURCE_BUILDERS;

    static {
        ArrayList<DataSourceBuilder> dataSources = new ArrayList<DataSourceBuilder>(3);
        try {
            Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.common.services", (String)EXT_PT);
            for (IExtension extension : extensions) {
                IConfigurationElement[] elems;
                IConfigurationElement[] iConfigurationElementArray = elems = extension.getConfigurationElements();
                int n = elems.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement dataSourceElem = iConfigurationElementArray[n2];
                    DataSourceBuilder builder = new DataSourceBuilder(dataSourceElem.getContributor().getName());
                    builder.setDataSourceClass(PluginUtil.findRequiredAttribute((IConfigurationElement)dataSourceElem, (String)"class-name"));
                    builder.setIsfactory(PluginUtil.findRequiredAttribute((IConfigurationElement)dataSourceElem, (String)"is-factory"));
                    IConfigurationElement enablementElement = PluginUtil.findOptionalElement((IConfigurationElement)dataSourceElem, (String)"enablement");
                    Expression expression = null;
                    if (enablementElement != null) {
                        expression = ExpressionConverter.getDefault().perform(enablementElement);
                        builder.setEnablementExpression(expression);
                    }
                    dataSources.add(builder);
                    ++n2;
                }
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
        }
        catch (PluginUtil.InvalidExtensionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        sDATA_SOURCE_BUILDERS = Collections.unmodifiableList(dataSources);
    }

    public static Set<IDataSource> getDataSources() {
        LinkedHashSet<IDataSource> dataSources = new LinkedHashSet<IDataSource>(sDATA_SOURCE_BUILDERS.size());
        for (DataSourceBuilder builder : sDATA_SOURCE_BUILDERS) {
            try {
                if (!builder.isEnabled()) continue;
                dataSources.add(builder.build());
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
            }
        }
        return dataSources;
    }
}

