/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.transaction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.eclipse.tools.common.services.transaction.IDataSource;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;

public class DataSourceBuilder {
    private String dataSourceClassName = null;
    private Expression expression = null;
    private boolean isFactory = false;
    private final String pluginID;

    public DataSourceBuilder(String pluginID) {
        this.pluginID = pluginID;
    }

    public IDataSource build() {
        if (this.dataSourceClassName == null) {
            throw new IllegalStateException("Exactly one of class-name is required");
        }
        IDataSource dataSource = null;
        if (this.isFactory) {
            Class dataSourcefactoryClass = PluginUtil.loadClass((String)this.pluginID, (String)this.dataSourceClassName);
            if (dataSourcefactoryClass != null) {
                try {
                    Method getDataSourceMethod = dataSourcefactoryClass.getMethod("getDataSource", null);
                    Object dsObj = getDataSourceMethod.invoke(null, null);
                    if (dsObj instanceof IDataSource) {
                        dataSource = (IDataSource)dsObj;
                    }
                }
                catch (IllegalArgumentException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (SecurityException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
            }
            if (dataSource == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to invoke " + this.dataSourceClassName + "#getDataSource() for plugin " + this.pluginID));
            }
        } else {
            dataSource = (IDataSource)PluginUtil.instantiate((String)this.pluginID, (String)this.dataSourceClassName, IDataSource.class);
            if (dataSource == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to instantiate " + this.dataSourceClassName + " for plugin " + this.pluginID));
            }
        }
        return dataSource;
    }

    public DataSourceBuilder setDataSourceClass(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
        return this;
    }

    public DataSourceBuilder setEnablementExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public boolean isEnabled() throws CoreException {
        if (this.expression != null) {
            EvaluationContext evalContext = new EvaluationContext(null, Object.class);
            evalContext.setAllowPluginActivation(true);
            return EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
        }
        return true;
    }

    public void setIsfactory(String isFactoryString) {
        this.isFactory = Boolean.valueOf(isFactoryString);
    }
}

