/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.resources.EventType;
import oracle.eclipse.tools.common.services.resources.IElementChange;
import oracle.eclipse.tools.common.services.resources.IResourceChange;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import oracle.eclipse.tools.common.services.resources.internal.ResourceChange;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;

public class WorkspaceLoadEvent
implements ISequentialResourceChangeEvent {
    private final Set<IResourceChange> changes = new HashSet<IResourceChange>();
    private final ISequentialResourceChangeEvent source;
    private final int saveNumber;

    public WorkspaceLoadEvent(ISequentialResourceChangeEvent source, int saveNumber) {
        IProject[] projects;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            this.changes.add(new ResourceChange(project));
            ++n2;
        }
        this.source = source;
        this.saveNumber = saveNumber;
    }

    @Override
    public int compareTo(ISequentialResourceChangeEvent o) {
        if (o instanceof WorkspaceLoadEvent) {
            return 0;
        }
        return -1;
    }

    @Override
    public EventType getType() {
        return EventType.LOAD;
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    @Override
    public int getSequenceNumber() {
        return -1;
    }

    @Override
    public Set<IResourceChange> getResourceChanges() {
        return Collections.unmodifiableSet(this.changes);
    }

    @Override
    public ISequentialResourceChangeEvent getSource() {
        return this.source;
    }

    public int getSaveNumber() {
        return this.saveNumber;
    }

    @Override
    public Set<IElementChange> getElementChanges() {
        return Collections.emptySet();
    }

    @Override
    public boolean isResourceEvent() {
        return true;
    }

    @Override
    public boolean isJavaEvent() {
        return false;
    }
}

