/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.TraceOptions;
import oracle.eclipse.tools.common.services.dependency.model.DependencyModelEvent;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.dependency.model.internal.ResourceSetCommand;
import oracle.eclipse.tools.common.services.internal.SaveParticipant;
import oracle.eclipse.tools.common.services.resources.ICommand;
import oracle.eclipse.tools.common.services.resources.ISequentialEventManager;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEvent;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEventListener;
import oracle.eclipse.tools.common.services.resources.internal.CommandComparator;
import oracle.eclipse.tools.common.services.resources.internal.CommandSet;
import oracle.eclipse.tools.common.services.resources.internal.QueueManagerJob;
import oracle.eclipse.tools.common.services.resources.internal.ResourceChangeEventProcessor;
import oracle.eclipse.tools.common.services.resources.internal.ResourceChangeListener;
import oracle.eclipse.tools.common.services.resources.internal.SequentialEventListenerExtensionReader;
import oracle.eclipse.tools.common.services.resources.internal.WorkspaceLoadEvent;
import oracle.eclipse.tools.common.services.transaction.ITransactionContext;
import oracle.eclipse.tools.common.services.transaction.TransactionService;
import oracle.eclipse.tools.common.services.util.SerializationUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class SequentialEventManager
implements ISequentialEventManager {
    private final BlockingQueue<CommandSet> commandQueue = new LinkedBlockingQueue<CommandSet>();
    private final ResourceChangeListener listener = new ResourceChangeListener(this);
    private final AtomicInteger currentEventNumber = new AtomicInteger(-1);
    private final AtomicInteger lastProcessedEventNumber = new AtomicInteger(Integer.MIN_VALUE);
    private final QueueManagerJob queueJob = new QueueManagerJob(this);
    private final QueueManagerJobListener queueJobListener = new QueueManagerJobListener();
    private final SaveParticipant saveParticipant = new SaveParticipant();

    @Override
    public void start() {
        ISavedState savedState;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return;
        }
        if (activator.getPreferences().isDisabled()) {
            return;
        }
        if (activator.getBundle().getState() != 32) {
            return;
        }
        this.queueJob.addJobChangeListener((IJobChangeListener)this.queueJobListener);
        this.listener.startListening();
        this.queueJobListener.setRestart(true);
        int saveNumber = -1;
        final ISequentialResourceChangeEvent[] savedStateEvent = new ISequentialResourceChangeEvent[1];
        try {
            savedState = ResourcesPlugin.getWorkspace().addSaveParticipant("oracle.eclipse.tools.common.services", (ISaveParticipant)this.saveParticipant);
        }
        catch (CoreException e) {
            savedState = null;
            LoggingService.logException((Plugin)activator, (CoreException)e);
        }
        if (savedState != null && (saveNumber = savedState.getSaveNumber()) > 0) {
            savedState.processResourceChangeEvents(new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    ResourceChangeEventProcessor processor = new ResourceChangeEventProcessor(event, -1);
                    savedStateEvent[0] = processor.process();
                }
            });
        }
        if (saveNumber <= 0 || savedStateEvent[0] == null) {
            this.resourceChanged(new WorkspaceLoadEvent(null, -1));
        } else {
            this.resourceChanged(new WorkspaceLoadEvent(savedStateEvent[0], saveNumber));
        }
    }

    @Override
    public void shutDown() {
        this.listener.stopListening();
        ResourcesPlugin.getWorkspace().removeSaveParticipant("oracle.eclipse.tools.common.services");
        this.queueJobListener.setRestart(false);
        this.queueJob.shutDown();
    }

    @Override
    public void resourceChanged(ISequentialResourceChangeEvent event) {
        this.setCurrentEvent(event.getSequenceNumber());
        HashMap<IProject, PriorityBlockingQueue<ICommand>> commandMap = new HashMap<IProject, PriorityBlockingQueue<ICommand>>();
        Set<ISequentialResourceChangeEventListener> listeners = SequentialEventListenerExtensionReader.getListeners();
        if (listeners != null) {
            for (ISequentialResourceChangeEventListener listener : listeners) {
                Set<ICommand> commandSet = listener.resourceChanged(event);
                for (ICommand command : commandSet) {
                    IProject project = command.getProject();
                    if (Activator.getDefault().getPreferences().getProjectPreferences(project).isDisabled()) continue;
                    PriorityBlockingQueue<ICommand> commands = (PriorityBlockingQueue<ICommand>)commandMap.get(project);
                    if (commands == null) {
                        commands = new PriorityBlockingQueue<ICommand>(3, new CommandComparator());
                        commandMap.put(project, commands);
                    }
                    if (TraceOptions.APPXRAY_COMMANDSET && command instanceof ResourceSetCommand) {
                        TraceOptions.log("SequentialEventManager before adding command to command set");
                        ((ResourceSetCommand)command).printChangedResources();
                    }
                    commands.add(command);
                }
            }
        }
        if (!commandMap.isEmpty()) {
            CommandSet commandSet = new CommandSet(event.getSequenceNumber(), commandMap);
            this.commandQueue.add(commandSet);
            if (TraceOptions.APPXRAY_COMMANDSET) {
                TraceOptions.log("SequentialEventManager adding new commandSet " + commandSet);
            }
        }
    }

    public int getCurrentEvent() {
        return this.currentEventNumber.get();
    }

    public void pauseCommandExecutionNoWait() {
        boolean isExecutingLockAvail = this.queueJob.pauseNoWait();
        if (TraceOptions.APPXRAY_LOCKS) {
            TraceOptions.log("SequentialEventManager paused-no wait: executing lock was avail [" + String.valueOf(isExecutingLockAvail) + "]");
        }
    }

    public boolean safeControlledPause() {
        boolean lockAcquired = this.queueJob.safeControlledPause();
        if (TraceOptions.APPXRAY_LOCKS) {
            TraceOptions.log("SequentialEventManager safeControlledPause: executing lock was acquired [" + String.valueOf(lockAcquired) + "]");
        }
        return lockAcquired;
    }

    public void restartIfPaused() {
        this.queueJob.restartJobExecution();
    }

    public void executeCommands(IProgressMonitor monitor, int eventNumber) {
        block20: {
            if (this.isUpToDate(eventNumber)) {
                if (TraceOptions.APPXRAY_COMMANDSET) {
                    TraceOptions.log("SequentialEventManager's event number is uptodate " + eventNumber);
                }
                return;
            }
            try {
                this.queueJob.pauseJobExecution();
                if (this.isUpToDate(eventNumber)) break block20;
                CommandSet commandSet = this.queueJob.getPausedCommandSet();
                if (commandSet == null) {
                    if (TraceOptions.APPXRAY_LOCKS) {
                        TraceOptions.log("SequentialEventManager about to peek commandQueue");
                    }
                    commandSet = (CommandSet)this.commandQueue.poll();
                    if (TraceOptions.APPXRAY_COMMANDSET && commandSet != null) {
                        TraceOptions.log("SequentialEventManager removed initial commandSet from commandQueue:  " + commandSet);
                    }
                    if (TraceOptions.APPXRAY_LOCKS) {
                        TraceOptions.log("SequentialEventManager peeked commandQueue");
                    }
                }
                if (commandSet == null) break block20;
                do {
                    ITransactionContext txContext = TransactionService.getInstance().createTransaction();
                    try {
                        CommandSet.ProjectCommandSet pcs = null;
                        while ((pcs = commandSet.getNext()) != null) {
                            IProject project = pcs.getProject();
                            DependencyModelManager.getInstance().getModel().updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.BEFORE_UPDATE, project));
                            if (TraceOptions.APPXRAY_LOCKS) {
                                TraceOptions.log("SequentialEventManager about to iterate commands");
                            }
                            for (ICommand command : pcs.getCommands()) {
                                if (TraceOptions.APPXRAY_COMMANDSET) {
                                    TraceOptions.log("SequentialEventManager executing command " + command);
                                }
                                command.execute(monitor, txContext, true);
                            }
                            if (TraceOptions.APPXRAY_LOCKS) {
                                TraceOptions.log("SequentialEventManager done iterating commands");
                            }
                            DependencyModelManager.getInstance().getModel().updateListeners(new DependencyModelEvent(DependencyModelEvent.EVENT_TYPE.UPDATED, project));
                        }
                    }
                    finally {
                        TransactionService.getInstance().commit(txContext, monitor);
                    }
                    this.eventProcessed(commandSet.getSequenceNumber());
                    if (TraceOptions.APPXRAY_LOCKS) {
                        TraceOptions.log("SequentialEventManager about to poll commandQueue");
                    }
                    commandSet = (CommandSet)this.commandQueue.poll();
                    if (TraceOptions.APPXRAY_COMMANDSET && commandSet != null) {
                        TraceOptions.log("SequentialEventManager removed commandSet from the commandQueue: " + commandSet);
                    }
                    if (!TraceOptions.APPXRAY_LOCKS) continue;
                    TraceOptions.log("SequentialEventManager polled commandQueue");
                } while (commandSet != null);
            }
            finally {
                this.queueJob.restartJobExecution();
            }
        }
    }

    private boolean isUpToDate(int eventNumber) {
        return this.commandQueue.isEmpty() && this.queueJob.getPausedCommandSet() == null || this.lastProcessedEventNumber.get() >= eventNumber;
    }

    CommandSet takeCommandSet() throws InterruptedException {
        return this.commandQueue.poll(5L, TimeUnit.SECONDS);
    }

    public void commandCanceled(CommandSet commandSet) {
    }

    private void setCurrentEvent(int eventNumber) {
        boolean wasSet = false;
        while (!wasSet) {
            int snapshotEventNumber = this.currentEventNumber.get();
            int newEventNumber = Math.max(snapshotEventNumber, eventNumber);
            boolean bl = wasSet = newEventNumber == snapshotEventNumber || this.currentEventNumber.compareAndSet(snapshotEventNumber, newEventNumber);
        }
    }

    void eventProcessed(int eventNumber) {
        try {
            assert (eventNumber == -1 || eventNumber > this.lastProcessedEventNumber.get());
            assert (eventNumber <= this.currentEventNumber.get());
        }
        catch (AssertionError ae) {
            Activator.log(String.format("Invalid Event Number: %d, last: %d, current: %d", eventNumber, this.lastProcessedEventNumber.get(), this.currentEventNumber.get()), (Throwable)((Object)ae));
        }
        if (eventNumber != -1) {
            this.lastProcessedEventNumber.set(eventNumber);
        }
    }

    public IStatus storeCommands(ISaveContext context, IProject project) {
        int saveNumber = context.getSaveNumber();
        int prevSaveNumber = context.getPreviousSaveNumber();
        return this.storeCommands(saveNumber, prevSaveNumber, project);
    }

    public IStatus storeCommands(int saveNumber, int prevSaveNumber, IProject project) {
        ObjectOutputStream oos = null;
        try {
            try {
                this.deleteSaveNumberFile(project);
                this.deleteFile(prevSaveNumber, project);
                String currFileName = this.getFileName(saveNumber);
                oos = SerializationUtil.getOutputStream(project, currFileName);
                this.writeCommands(oos, project, this.queueJob.getPausedCommandSet());
                for (CommandSet commandSet : this.commandQueue) {
                    this.writeCommands(oos, project, commandSet);
                }
                oos.writeObject((Object)SerializationUtil.MARKER.END);
                oos.flush();
            }
            catch (IOException e) {
                this.deleteFile(saveNumber, project);
                this.deleteSaveNumberFile(project);
                Status status = new Status(4, "oracle.eclipse.tools.common.services", e.getMessage(), (Throwable)e);
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e2) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e2);
                }
                return status;
            }
            catch (CoreException e) {
                this.deleteFile(saveNumber, project);
                this.deleteSaveNumberFile(project);
                IStatus iStatus = e.getStatus();
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e3) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e3);
                }
                return iStatus;
            }
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
            }
        }
        this.writeSaveNumberFile(saveNumber, project);
        return Status.OK_STATUS;
    }

    /*
     * Exception decompiling
     */
    public IStatus loadCommands(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeCommands(ObjectOutputStream oos, IProject project, CommandSet commandSet) throws IOException {
        if (commandSet != null) {
            CommandSet.ProjectCommandSet pcs = null;
            while ((pcs = commandSet.getNext(project)) != null) {
                oos.writeObject(pcs);
            }
        }
    }

    private String getFileName(int saveNumber) {
        return saveNumber + ".command.sjo";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSaveNumberFile(int saveNumber, IProject project) {
        ObjectOutputStream oos = null;
        try {
            oos = SerializationUtil.getOutputStream(project, "command.num");
            oos.writeInt(saveNumber);
        }
        catch (IOException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
            if (oos == null) return;
            try {
                oos.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (CoreException e) {
            try {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
                if (oos == null) return;
            }
            catch (Throwable throwable) {
                if (oos == null) throw throwable;
                try {
                    oos.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                oos.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private void deleteFile(int saveNumber, IProject project) {
        if (saveNumber > 0) {
            String prevFileName = this.getFileName(saveNumber);
            try {
                boolean deleted;
                File projectSerializationFile = SerializationUtil.getSerializedFile(project, prevFileName, false);
                if (projectSerializationFile != null && projectSerializationFile.exists() && !(deleted = projectSerializationFile.delete())) {
                    LoggingService.logDebug((String)"oracle.eclipse.tools.common.services", (String)("Unable to delete " + projectSerializationFile.getName()));
                }
            }
            catch (RuntimeException re) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)re);
            }
        }
    }

    void deleteSaveNumberFile(IProject project) {
        try {
            boolean deleted;
            File commandSerializationFile = SerializationUtil.getSerializedFile(project, "command.num", false);
            if (commandSerializationFile != null && commandSerializationFile.exists() && !(deleted = commandSerializationFile.delete())) {
                LoggingService.logDebug((String)"oracle.eclipse.tools.common.services", (String)("Unable to delete " + commandSerializationFile.getName()));
            }
        }
        catch (RuntimeException re) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)re);
        }
    }

    /*
     * Loose catch block
     */
    private int getSaveNumber(IProject project) {
        ObjectInputStream ois;
        block18: {
            int n;
            block19: {
                ois = null;
                ois = SerializationUtil.getInputStream(project, "command.num");
                if (ois == null) break block18;
                n = ois.readInt();
                if (ois == null) break block19;
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            return n;
        }
        if (ois != null) {
            try {
                ois.close();
            }
            catch (IOException iOException) {}
        }
        return 0;
        catch (IOException e) {
            block20: {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                if (ois == null) break block20;
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            return 0;
        }
        catch (CoreException e2) {
            block21: {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e2);
                if (ois == null) break block21;
                {
                    catch (Throwable throwable) {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            return 0;
        }
    }

    @Override
    public String getId() {
        return "AppXRay Sequential Event Manager";
    }

    private class QueueManagerJobListener
    extends JobChangeAdapter {
        private boolean shouldRestart = false;
        private boolean jobComplete = true;

        private QueueManagerJobListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            QueueManagerJobListener queueManagerJobListener = this;
            synchronized (queueManagerJobListener) {
                if (this.shouldRestart) {
                    this.restart();
                } else {
                    this.jobComplete = true;
                }
            }
        }

        public synchronized void setRestart(boolean restart) {
            if (restart && this.jobComplete) {
                this.restart();
            } else {
                this.shouldRestart = restart;
            }
        }

        private void restart() {
            this.shouldRestart = false;
            this.jobComplete = false;
            SequentialEventManager.this.queueJob.schedule();
        }
    }
}

