/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEventListener;
import oracle.eclipse.tools.common.services.resources.internal.SequentialEventListenerBuilder;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class SequentialEventListenerExtensionReader {
    public static final String EXT_PT = "sequentialEventListener";
    private static final List<SequentialEventListenerBuilder> sLISTENERS;

    static {
        ArrayList<SequentialEventListenerBuilder> listeners = new ArrayList<SequentialEventListenerBuilder>(5);
        try {
            Collection extensions = PluginUtil.findExtensions((String)"oracle.eclipse.tools.common.services", (String)EXT_PT);
            block3: for (IExtension extension : extensions) {
                IConfigurationElement[] elems;
                IConfigurationElement[] iConfigurationElementArray = elems = extension.getConfigurationElements();
                int n = elems.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement listenerElem = iConfigurationElementArray[n2];
                    SequentialEventListenerBuilder builder = new SequentialEventListenerBuilder(listenerElem.getContributor().getName());
                    IConfigurationElement listenerClassElement = PluginUtil.findOptionalElement((IConfigurationElement)listenerElem, (String)"listener-class");
                    IConfigurationElement listenerFactoryElement = null;
                    if (listenerClassElement == null) {
                        listenerFactoryElement = PluginUtil.findOptionalElement((IConfigurationElement)listenerElem, (String)"listener-factory");
                        if (listenerFactoryElement == null) {
                            PluginUtil.reportInvalildElement((IExtension)extension, (IConfigurationElement)listenerElem);
                            continue block3;
                        }
                        builder.setListenerFactoryClass(PluginUtil.findRequiredAttribute((IConfigurationElement)listenerFactoryElement, (String)"factory-class"));
                    } else {
                        builder.setListenerClass(PluginUtil.findRequiredAttribute((IConfigurationElement)listenerClassElement, (String)"class-name"));
                    }
                    IConfigurationElement enablementElement = PluginUtil.findOptionalElement((IConfigurationElement)listenerElem, (String)"enablement");
                    Expression expression = null;
                    if (enablementElement != null) {
                        expression = ExpressionConverter.getDefault().perform(enablementElement);
                        builder.setEnablementExpression(expression);
                    }
                    listeners.add(builder);
                    ++n2;
                }
            }
        }
        catch (CoreException ce) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)ce);
        }
        catch (PluginUtil.InvalidExtensionException e) {
            LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
        }
        sLISTENERS = Collections.unmodifiableList(listeners);
    }

    public static Set<ISequentialResourceChangeEventListener> getListeners() {
        LinkedHashSet<ISequentialResourceChangeEventListener> listeners = new LinkedHashSet<ISequentialResourceChangeEventListener>(sLISTENERS.size());
        for (SequentialEventListenerBuilder builder : sLISTENERS) {
            try {
                if (!builder.isEnabled()) continue;
                listeners.add(builder.build());
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)e);
            }
        }
        return listeners;
    }
}

