/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import oracle.eclipse.tools.common.services.resources.ISequentialResourceChangeEventListener;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;

public class SequentialEventListenerBuilder {
    private String listenerClassName = null;
    private String listenerFactoryClassName = null;
    private Expression expression = null;
    private final String pluginID;

    public SequentialEventListenerBuilder(String pluginID) {
        this.pluginID = pluginID;
    }

    public ISequentialResourceChangeEventListener build() {
        if (this.listenerClassName == null && this.listenerFactoryClassName == null) {
            throw new IllegalStateException("Exactly one of listener-class or listener-factory is allowed");
        }
        ISequentialResourceChangeEventListener lc = null;
        if (this.listenerClassName != null) {
            lc = (ISequentialResourceChangeEventListener)PluginUtil.instantiate((String)this.pluginID, (String)this.listenerClassName, ISequentialResourceChangeEventListener.class);
            if (lc == null) {
                LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)("Unable to instantiate " + this.listenerClassName + " for plugin " + this.pluginID));
            }
        } else {
            Class listenerFactoryClass = PluginUtil.loadClass((String)this.pluginID, (String)this.listenerFactoryClassName);
            if (listenerFactoryClass != null) {
                try {
                    Method getListenerMethod = listenerFactoryClass.getMethod("getListener", null);
                    Object listener = getListenerMethod.invoke(null, null);
                    if (listener instanceof ISequentialResourceChangeEventListener) {
                        lc = (ISequentialResourceChangeEventListener)listener;
                    } else {
                        LoggingService.logError((String)"oracle.eclipse.tools.common.services", (String)(String.valueOf(this.listenerFactoryClassName) + "#getListener() did not return an instance of ISequentialResourceChangeEventListener"));
                    }
                }
                catch (NoSuchMethodException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (Throwable)e);
                }
            }
        }
        return lc;
    }

    public SequentialEventListenerBuilder setListenerClass(String listenerClassName) {
        if (this.listenerFactoryClassName != null) {
            throw new IllegalStateException("Exactly one of listener-class or listener-factory is allowed");
        }
        this.listenerClassName = listenerClassName;
        return this;
    }

    public SequentialEventListenerBuilder setListenerFactoryClass(String listenerFactoryClassName) {
        if (this.listenerClassName != null) {
            throw new IllegalStateException("Exactly one of comamnd-class or listener-factory is allowed");
        }
        this.listenerFactoryClassName = listenerFactoryClassName;
        return this;
    }

    public SequentialEventListenerBuilder setEnablementExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public boolean isEnabled() throws CoreException {
        if (this.expression != null) {
            EvaluationContext evalContext = new EvaluationContext(null, Object.class);
            evalContext.setAllowPluginActivation(true);
            return EvaluationResult.TRUE == this.expression.evaluate((IEvaluationContext)evalContext);
        }
        return true;
    }
}

