/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.resources;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;

public interface IElementChange {
    public IJavaElement getElement();

    public Set<FLAG> getFlags();

    public KIND getKind();

    public IJavaElement getMovedFroElement();

    public IJavaElement getMovedToElement();

    public IJavaElementDelta getDelta();

    public static enum FLAG {
        F_CONTENT,
        F_MODIFIERS,
        F_CHILDREN,
        F_MOVED_FROM,
        F_MOVED_TO,
        F_ADDED_TO_CLASSPATH,
        F_REMOVED_FROM_CLASSPATH,
        F_CLASSPATH_REORDER,
        F_REORDER,
        F_OPENED,
        F_CLOSED,
        F_SUPER_TYPES,
        F_SOURCEATTACHED,
        F_SOURCEDETACHED,
        F_FINE_GRAINED,
        F_ARCHIVE_CONTENT_CHANGED,
        F_PRIMARY_WORKING_COPY,
        F_CLASSPATH_CHANGED,
        F_PRIMARY_RESOURCE,
        F_AST_AFFECTED,
        F_CATEGORIES,
        F_RESOLVED_CLASSPATH_CHANGED,
        F_ANNOTATIONS;


        public static Set<FLAG> fromIJavaElementChangeEventFlags(int flagBits) {
            HashSet<FLAG> flags = new HashSet<FLAG>();
            if ((1 & flagBits) != 0) {
                flags.add(F_CONTENT);
            }
            if ((2 & flagBits) != 0) {
                flags.add(F_MODIFIERS);
            }
            if ((8 & flagBits) != 0) {
                flags.add(F_CHILDREN);
            }
            if ((0x10 & flagBits) != 0) {
                flags.add(F_MOVED_FROM);
            }
            if ((0x20 & flagBits) != 0) {
                flags.add(F_MOVED_TO);
            }
            if ((0x40 & flagBits) != 0) {
                flags.add(F_ADDED_TO_CLASSPATH);
            }
            if ((0x80 & flagBits) != 0) {
                flags.add(F_REMOVED_FROM_CLASSPATH);
            }
            if ((0x100 & flagBits) != 0) {
                flags.add(F_CLASSPATH_REORDER);
            }
            if ((0x100 & flagBits) != 0) {
                flags.add(F_REORDER);
            }
            if ((0x200 & flagBits) != 0) {
                flags.add(F_OPENED);
            }
            if ((0x400 & flagBits) != 0) {
                flags.add(F_CLOSED);
            }
            if ((0x800 & flagBits) != 0) {
                flags.add(F_SUPER_TYPES);
            }
            if ((0x1000 & flagBits) != 0) {
                flags.add(F_SOURCEATTACHED);
            }
            if ((0x2000 & flagBits) != 0) {
                flags.add(F_SOURCEDETACHED);
            }
            if ((0x4000 & flagBits) != 0) {
                flags.add(F_FINE_GRAINED);
            }
            if ((0x8000 & flagBits) != 0) {
                flags.add(F_ARCHIVE_CONTENT_CHANGED);
            }
            if ((0x10000 & flagBits) != 0) {
                flags.add(F_PRIMARY_WORKING_COPY);
            }
            if ((0x20000 & flagBits) != 0) {
                flags.add(F_CLASSPATH_CHANGED);
            }
            if ((0x40000 & flagBits) != 0) {
                flags.add(F_PRIMARY_RESOURCE);
            }
            if ((0x80000 & flagBits) != 0) {
                flags.add(F_AST_AFFECTED);
            }
            if ((0x100000 & flagBits) != 0) {
                flags.add(F_CATEGORIES);
            }
            if ((0x200000 & flagBits) != 0) {
                flags.add(F_RESOLVED_CLASSPATH_CHANGED);
            }
            if ((0x400000 & flagBits) != 0) {
                flags.add(F_ANNOTATIONS);
            }
            return flags;
        }
    }

    public static enum KIND {
        ADDED,
        REMOVED,
        CHANGED;


        public static KIND fromIJavaElementChangeEventKind(int kind) {
            switch (kind) {
                case 1: {
                    return ADDED;
                }
                case 2: {
                    return REMOVED;
                }
                case 4: {
                    return CHANGED;
                }
            }
            return null;
        }
    }
}

