/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring.internal;

import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import oracle.eclipse.tools.common.services.refactoring.internal.CommonArtifactRefactoringProcessor;
import oracle.eclipse.tools.common.services.refactoring.internal.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.common.project.facet.core.util.internal.DomUtil;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StructuredArtifactRefactoringProcessor
extends CommonArtifactRefactoringProcessor {
    private final IDOMNode node;

    public StructuredArtifactRefactoringProcessor(IFile file, IArtifact artifact, Range range, IDOMNode node) {
        super(file, artifact, range);
        this.node = node instanceof IDOMElement ? this.getTextNode((IDOMElement)node) : node;
        String nodeText = this.getTextFromNode(node);
        if (nodeText != null) {
            this.setNewText(nodeText);
        }
    }

    private IDOMText getTextNode(IDOMElement element) {
        NodeList children = element.getChildNodes();
        if (children != null && children.getLength() == 1 && children.item(0) instanceof IDOMText) {
            return (IDOMText)children.item(0);
        }
        return null;
    }

    @Override
    public Object[] getElements() {
        return new Object[]{this.node};
    }

    @Override
    public String getIdentifier() {
        return "oracle.eclipse.tools.common.services.RenameArtifactProcessor";
    }

    @Override
    public String getProcessorName() {
        return Messages.RenameArtifactProcessor_processorName;
    }

    @Override
    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        int length;
        int offset;
        CompositeChange change = new CompositeChange(Messages.RenameArtifactProcessor_changeName);
        if (this.node instanceof IDOMAttr) {
            IDOMAttr attr = (IDOMAttr)this.node;
            offset = attr.getValueRegionStartOffset() + 1;
            length = attr.getValue().length();
        } else if (this.node instanceof TextImpl) {
            offset = this.node.getStartOffset();
            length = this.node.getNodeValue().length();
        } else {
            return null;
        }
        TextChange fileChange = this.getRefactoring().getTextChange((Object)this.getFile());
        if (fileChange == null) {
            fileChange = new TextFileChange(this.getFile().getName(), this.getFile());
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            fileChange.setEdit((TextEdit)multiTextEdit);
            change.add((Change)fileChange);
        }
        fileChange.addEdit((TextEdit)new ReplaceEdit(offset, length, this.getArguments().getNewName()));
        return change;
    }

    private String getTextFromNode(IDOMNode node) {
        if (node instanceof IDOMElement) {
            return DomUtil.text((Element)((IDOMElement)node));
        }
        return node.getNodeValue();
    }

    @Override
    public RefactoringStatus validateNewText(String text) {
        return super.validateNewText(text);
    }
}

