/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.services.refactoring.internal.Messages;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ArtifactReferenceRenameParticipant
extends RenameParticipant {
    private Set<IArtifactReference> referenceToRenamedArtifact = new HashSet<IArtifactReference>();
    private String oldText = null;
    private String newText = null;

    protected boolean initialize(Object element) {
        Object adaptedArtifact = AdapterManager.getDefault().loadAdapter(element, IArtifact.class.getName());
        if (adaptedArtifact instanceof IArtifact) {
            this.newText = this.getArguments().getNewName();
            IArtifact artifactToRename = (IArtifact)adaptedArtifact;
            this.oldText = element instanceof IType ? ((IType)element).getElementName() : (element instanceof IResource ? ((IResource)element).getName() : artifactToRename.getName());
            ArtifactController controller = ArtifactControllerFactory.getController();
            this.referenceToRenamedArtifact.addAll(controller.getArtifactReferers(artifactToRename));
            return this.referenceToRenamedArtifact.size() > 0;
        }
        return false;
    }

    public String getName() {
        return Messages.ArtifactReferenceRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return RefactoringUtil.checkFileConditions(this.referenceToRenamedArtifact, context);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.ArtifactReferenceRenameParticipant_operation);
        RefactoringUtil.createChangesForArtifactReferences(this.getProcessor(), change, this.referenceToRenamedArtifact, this.oldText, this.newText, new HashMap<IFile, TextChange>());
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }
}

