/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactController;
import oracle.eclipse.tools.common.services.dependency.artifact.ArtifactControllerFactory;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifactReference;
import oracle.eclipse.tools.common.services.dependency.artifact.TypeArtifact;
import oracle.eclipse.tools.common.services.dependency.artifact.resource.ResourceArtifact;
import oracle.eclipse.tools.common.services.refactoring.RefactoringUtil;
import oracle.eclipse.tools.common.services.refactoring.internal.Messages;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;

public class ArtifactReferenceMoveHelper {
    private final List<MoveData> referencesToMovedArtifact = new ArrayList<MoveData>();

    boolean computeReferencesToMovedArtifact(Object element, Object destination) {
        block22: {
            String name;
            IFile file;
            Object adaptedArtifact = null;
            ICompilationUnit compilationUnit = null;
            if (element instanceof IFile && (file = (IFile)element).getFileExtension() != null && Util.isJavaLikeFileName((String)(name = file.getName()))) {
                compilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)element));
            }
            if (compilationUnit == null) {
                adaptedArtifact = AdapterManager.getDefault().loadAdapter(element, IArtifact.class.getName());
            }
            if (compilationUnit != null) {
                try {
                    IPackageDeclaration[] packages = compilationUnit.getPackageDeclarations();
                    String cuPackage = null;
                    String newCUPackage = null;
                    if (packages.length <= 1) {
                        IType[] types;
                        cuPackage = packages.length == 0 ? "" : packages[0].getElementName();
                        if (destination instanceof IPackageFragment) {
                            newCUPackage = ((IPackageFragment)destination).getElementName();
                        } else if (destination instanceof IFolder) {
                            newCUPackage = ArtifactReferenceMoveHelper.getPackageNameForContainer((IContainer)((IFolder)destination));
                        }
                        if ("".equals(newCUPackage)) {
                            cuPackage = String.valueOf(cuPackage) + ".";
                        }
                        ArtifactController controller = ArtifactControllerFactory.getController();
                        IType[] iTypeArray = types = compilationUnit.getAllTypes();
                        int n = types.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType type = iTypeArray[n2];
                            MoveData moveData = new MoveData();
                            if ("".equals(cuPackage)) {
                                moveData.oldText = type.getFullyQualifiedName();
                                moveData.newText = String.valueOf(newCUPackage) + '.' + moveData.oldText;
                            } else {
                                moveData.oldText = cuPackage;
                                moveData.newText = newCUPackage;
                            }
                            IArtifact typeArtifact = (IArtifact)type.getAdapter(IArtifact.class);
                            if (typeArtifact instanceof TypeArtifact) {
                                moveData.references = controller.getArtifactReferers(typeArtifact);
                                if (!moveData.references.isEmpty()) {
                                    this.referencesToMovedArtifact.add(moveData);
                                }
                            }
                            ++n2;
                        }
                        return !this.referencesToMovedArtifact.isEmpty();
                    }
                    break block22;
                }
                catch (JavaModelException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.common.services", (CoreException)((Object)e));
                    return false;
                }
            }
            if (adaptedArtifact instanceof ResourceArtifact && destination instanceof IContainer) {
                IResource resource;
                ArtifactController controller = ArtifactControllerFactory.getController();
                MoveData moveData = new MoveData();
                if (((ResourceArtifact)adaptedArtifact).getLocation() != null && (resource = ((ResourceArtifact)adaptedArtifact).getLocation().getResource()) != null && resource.exists() && resource.getProjectRelativePath().segmentCount() > 0) {
                    if (resource.getProjectRelativePath().segment(0).equalsIgnoreCase("adfmsrc")) {
                        return false;
                    }
                    IPath oldLocationPath = RefactoringUtil.getNormailizeToContainerPath(resource);
                    IPath newLocationPath = RefactoringUtil.getNormailizeToContainerPath((IResource)((IContainer)destination));
                    if (oldLocationPath != null && newLocationPath != null) {
                        newLocationPath = newLocationPath.append(resource.getName());
                        String propString = ".properties";
                        if (resource.getName().toLowerCase().endsWith(propString)) {
                            String oldPath = oldLocationPath.toString().replace('/', '.');
                            int index = oldPath.toLowerCase().indexOf(propString);
                            moveData.oldText = index != -1 ? oldPath.substring(0, index) : oldPath;
                            String newPath = newLocationPath.toString().replace('/', '.');
                            index = newPath.toLowerCase().indexOf(propString);
                            moveData.newText = index != -1 ? newPath.substring(0, index) : newPath;
                        } else {
                            moveData.oldText = oldLocationPath.toString();
                            moveData.newText = newLocationPath.toString();
                        }
                        moveData.references = controller.getArtifactReferers((ResourceArtifact)adaptedArtifact);
                        if (!moveData.references.isEmpty()) {
                            this.referencesToMovedArtifact.add(moveData);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    boolean hasReferencesToMovedArtifact() {
        return !this.referencesToMovedArtifact.isEmpty();
    }

    RefactoringStatus checkConditionsForMove(IProgressMonitor pm, CheckConditionsContext context) {
        RefactoringStatus status = new RefactoringStatus();
        for (MoveData moveData : this.referencesToMovedArtifact) {
            status.merge(RefactoringUtil.checkFileConditions(moveData.references, context));
        }
        return status;
    }

    Change createChangeForMove(IProgressMonitor pm, RefactoringProcessor refactoringProcessor) {
        CompositeChange change = new CompositeChange(Messages.ArtifactReferenceMoveParticipant_operation);
        HashMap<IFile, TextChange> fileToTextChangeMap = new HashMap<IFile, TextChange>();
        for (MoveData moveData : this.referencesToMovedArtifact) {
            RefactoringUtil.createChangesForArtifactReferences(refactoringProcessor, change, moveData.references, moveData.oldText, moveData.newText, fileToTextChangeMap);
        }
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }

    private static String getPackageNameForContainer(IContainer container) {
        IPath path = container.getProjectRelativePath();
        IProject project = container.getProject();
        IFolder folder = project.getFolder(path.segment(0));
        IJavaElement javaElem = JavaCore.create((IFolder)folder);
        if (!(javaElem instanceof IPackageFragmentRoot)) {
            return null;
        }
        path = path.removeFirstSegments(1);
        return path.toString().replace('/', '.');
    }

    static class FolderResourceProxyVisitor
    implements IResourceProxyVisitor {
        private List<IFile> files;
        private boolean visitSubfolders = true;

        public FolderResourceProxyVisitor(List<IFile> filesList) {
            this.files = filesList;
        }

        public void setVisitSubfolders(boolean b) {
            this.visitSubfolders = b;
        }

        protected void visitFolder(IFolder folder) {
            try {
                if (!this.visitSubfolders) {
                    IResource[] members = folder.members();
                    if (members != null) {
                        IResource[] iResourceArray = members;
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource resource = iResourceArray[n2];
                            if (resource.getType() == 1) {
                                this.files.add((IFile)resource);
                            }
                            ++n2;
                        }
                    }
                    return;
                }
                folder.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceProxy resource) {
            switch (resource.getType()) {
                case 2: {
                    return true;
                }
                case 1: {
                    this.files.add((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    private static final class MoveData {
        private String oldText = null;
        private String newText = null;
        Set<IArtifactReference> references = null;

        private MoveData() {
        }
    }
}

