/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring.internal;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.services.refactoring.internal.ArtifactReferenceMoveHelper;
import oracle.eclipse.tools.common.services.refactoring.internal.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenamePackageProcessor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ArtifactReferenceFolderRenameParticipant
extends RenameParticipant {
    private ArtifactReferenceMoveHelper artifactRefMoveHelper = new ArtifactReferenceMoveHelper();

    protected boolean initialize(Object element) {
        if (element instanceof IFolder) {
            if (this.getProcessor() instanceof RenamePackageProcessor) {
                return false;
            }
            IFolder folder = (IFolder)element;
            String newName = this.getArguments().getNewName();
            ArrayList<IFile> files = new ArrayList<IFile>();
            ArtifactReferenceMoveHelper.FolderResourceProxyVisitor folderVisitor = new ArtifactReferenceMoveHelper.FolderResourceProxyVisitor(files);
            folderVisitor.visitFolder(folder);
            IFolder newContainer = folder.getParent().getFolder((IPath)new Path(newName));
            ArtifactReferenceFolderRenameParticipant.determineReferencesToMovedArtifacts(files, folder, (IContainer)newContainer, false, this.artifactRefMoveHelper);
            return this.artifactRefMoveHelper.hasReferencesToMovedArtifact();
        }
        return false;
    }

    public String getName() {
        return Messages.ArtifactReferenceFolderRenameParticipant_name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return this.artifactRefMoveHelper.checkConditionsForMove(pm, context);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.artifactRefMoveHelper.createChangeForMove(pm, this.getProcessor());
    }

    static void determineReferencesToMovedArtifacts(List<IFile> files, IFolder folderToBeRenamed, IContainer newContainer, boolean move, ArtifactReferenceMoveHelper artifactRefMoveHelper) {
        for (IFile file : files) {
            IPath relativePath = file.getFullPath().makeRelativeTo(move ? folderToBeRenamed.getParent().getFullPath() : folderToBeRenamed.getFullPath());
            IContainer newContainerForFile = newContainer;
            if (relativePath.segmentCount() > 1) {
                newContainerForFile = newContainer.getFolder(relativePath.removeLastSegments(1));
            }
            artifactRefMoveHelper.computeReferencesToMovedArtifact(file, newContainerForFile);
        }
    }
}

