/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring.internal;

import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.common.services.dependency.artifact.IArtifact;
import oracle.eclipse.tools.common.services.dependency.model.IDependencyModel;
import oracle.eclipse.tools.common.services.dependency.model.internal.DependencyModelManager;
import oracle.eclipse.tools.common.services.refactoring.IArtifactRenameValidator;
import oracle.eclipse.tools.common.services.refactoring.internal.Messages;
import org.eclipse.core.resources.IResource;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public abstract class AbstractArtifactRenameValidator
implements IArtifactRenameValidator {
    @Override
    public RefactoringStatus validateArtifactRename(IArtifact artifact, String newName) {
        RefactoringStatus status = new RefactoringStatus();
        if (artifact.getName().equals(newName)) {
            status.addFatalError(Messages.CommonArtifactRenameValidator_ProvideNewName);
            return status;
        }
        HashSet<IArtifact> resultSet = new HashSet<IArtifact>();
        if (artifact.getLocation() != null && artifact.getLocation().getResource() != null) {
            IResource resource = artifact.getLocation().getResource();
            IDependencyModel model = DependencyModelManager.getInstance().getModel();
            Set<String> set = this.getArtifactsTypeSet();
            Set<IArtifact> artifacts = model.queryArtifactsByTypes(set, resource.getProject());
            for (IArtifact a : artifacts) {
                if (!a.getName().equals(newName)) continue;
                resultSet.add(artifact);
            }
        }
        if (resultSet.size() > 0) {
            status.addFatalError(this.getErrorMessage());
        }
        return status;
    }

    protected abstract Set<String> getArtifactsTypeSet();

    protected abstract String getErrorMessage();
}

