/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.refactoring;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.dependency.artifact.Range;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;

public class BundleRefactoringUtil {
    public static final String JAVA_PROPERTIES = "org.eclipse.jdt.core.javaProperties";

    public static Range findPropertyKeyRangeAtOffset(IFile file, int offset) {
        String encoding;
        InputStream stream = null;
        LineReader lineReader = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {
            encoding = "ISO-8859-1";
        }
        try {
            stream = BundleRefactoringUtil.createInputStream(file);
            lineReader = new LineReader(stream, encoding);
        }
        catch (CoreException cex) {
            Activator.log(cex.getMessage(), cex);
            return null;
        }
        catch (IOException iOException) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ce) {
                    Activator.log(ce.getMessage(), ce);
                }
            }
            return null;
        }
        int start = 0;
        try {
            StringBuffer buf = new StringBuffer(80);
            int eols = lineReader.readLine(buf);
            while (eols > 0) {
                String line = buf.toString();
                int termInd = line.indexOf(61);
                if (termInd > 0 && start <= offset && offset < start + termInd) {
                    String keyString = line.substring(0, termInd).trim();
                    int startOnLine = line.indexOf(keyString);
                    startOnLine = startOnLine < 0 ? 0 : startOnLine;
                    Range range = new Range(start + startOnLine, keyString.length());
                    return range;
                }
                try {
                    start += line.length() + eols;
                    buf.setLength(0);
                    eols = lineReader.readLine(buf);
                    continue;
                }
                catch (IOException e) {
                    Activator.log(e.getMessage(), e);
                }
                break;
            }
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException ex) {
                Activator.log(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public static int findPropertyNameStartPosition(IFile file, String propertyName) {
        String encoding;
        InputStream stream = null;
        LineReader lineReader = null;
        try {
            encoding = file.getCharset();
        }
        catch (CoreException coreException) {
            encoding = "ISO-8859-1";
        }
        try {
            stream = BundleRefactoringUtil.createInputStream(file);
            lineReader = new LineReader(stream, encoding);
        }
        catch (CoreException cex) {
            Activator.log(cex.getMessage(), cex);
            return -1;
        }
        catch (IOException iOException) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ce) {
                    Activator.log(ce.getMessage(), ce);
                }
            }
            return -1;
        }
        int start = 0;
        try {
            try {
                StringBuffer buf = new StringBuffer(80);
                int eols = lineReader.readLine(buf);
                int keyLength = propertyName.length();
                while (eols > 0) {
                    boolean hasNoValue;
                    String line = buf.toString();
                    int i = line.indexOf(propertyName);
                    int charPos = i + keyLength;
                    char terminatorChar = '\u0000';
                    boolean bl = hasNoValue = charPos >= line.length();
                    if (i > -1 && !hasNoValue) {
                        terminatorChar = line.charAt(charPos);
                    }
                    if (line.trim().startsWith(propertyName) && (hasNoValue || Character.isWhitespace(terminatorChar) || terminatorChar == '=')) {
                        start += line.indexOf(propertyName);
                        eols = -17;
                        continue;
                    }
                    start += line.length() + eols;
                    buf.setLength(0);
                    eols = lineReader.readLine(buf);
                }
                if (eols != -17) {
                    start = -1;
                }
            }
            catch (IOException ex) {
                Activator.log(ex.getMessage(), ex);
                try {
                    lineReader.close();
                }
                catch (IOException ex2) {
                    Activator.log(ex2.getMessage(), ex2);
                }
                return -1;
            }
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException ex) {
                Activator.log(ex.getMessage(), ex);
            }
        }
        return start;
    }

    public static InputStream createInputStream(IFile propertiesFile) throws CoreException {
        ITextFileBuffer buffer;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager != null && (buffer = manager.getTextFileBuffer(propertiesFile.getFullPath(), LocationKind.IFILE)) != null) {
            return new ByteArrayInputStream(buffer.getDocument().get().getBytes(StandardCharsets.UTF_8));
        }
        return propertiesFile.getContents();
    }

    public static boolean isBundleFile(IResource resource) {
        if (resource instanceof IFile) {
            IContentDescription contentDescription;
            block4: {
                contentDescription = ((IFile)resource).getContentDescription();
                if (contentDescription != null) break block4;
                return false;
            }
            try {
                IContentType fileContentType = contentDescription.getContentType();
                return fileContentType != null && fileContentType.getId().equals(JAVA_PROPERTIES);
            }
            catch (CoreException e) {
                Activator.log("Cannot get the conent type of " + resource, e);
            }
        }
        return false;
    }

    static class LineReader {
        protected static final int LF = 10;
        protected static final int CR = 13;
        private BufferedReader fReader;
        protected int fPushbackChar;
        protected boolean fPushback = false;

        public LineReader(InputStream in, String encoding) throws IOException {
            this(new InputStreamReader(in, encoding));
        }

        public LineReader(Reader reader) {
            this.fReader = new BufferedReader(reader);
        }

        public int readLine(StringBuffer sb) throws IOException {
            int ch = -1;
            sb.setLength(0);
            if (this.fPushback) {
                ch = this.fPushbackChar;
                this.fPushback = false;
            } else {
                ch = this.fReader.read();
            }
            while (ch >= 0) {
                if (ch == 10) {
                    return 1;
                }
                if (ch == 13) {
                    ch = this.fReader.read();
                    if (ch == 10) {
                        return 2;
                    }
                    this.fPushbackChar = ch;
                    this.fPushback = true;
                    return 1;
                }
                sb.append((char)ch);
                ch = this.fReader.read();
            }
            return -1;
        }

        public void close() throws IOException {
            this.fReader.close();
        }
    }
}

