/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyDiscoveryProvider;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtensionIdentifier;
import oracle.eclipse.tools.common.services.project.technology.Identifier;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class TechnologyToFacetMap {
    private static final boolean DEBUG = false;
    private static final String TECH_FACET_MAP_EXT_PT = "oracle.eclipse.tools.common.services.TechnologyToFacetMap";
    private Map<Identifier, Set<Identifier>> _techToFacetMap;
    private Map<Identifier, Set<Identifier>> _facetToTechMap;
    private final IProject _project;
    private final AbstractTechnologyDiscoveryProvider _discProvider;

    public TechnologyToFacetMap(IProject project, AbstractTechnologyDiscoveryProvider discProvider) {
        this._project = project;
        this._discProvider = discProvider;
        this.buildMaps();
    }

    public boolean isActiveFacet(ITechnologyExtensionIdentifier techId) {
        boolean isActive = false;
        Identifier techIdent = this.createTechnologyIdentifier(techId);
        Set<Identifier> facetIdentiers = this._techToFacetMap.get(techIdent);
        if (facetIdentiers != null) {
            for (Identifier facetId : facetIdentiers) {
                try {
                    boolean accessible = FacetedProjectFramework.isFacetedProject((IProject)this._project);
                    if (!accessible) {
                        TechnologyToFacetMap.debugPrint(String.format("Project %s is not a faceted project for facet check %s", this._project.getName(), facetId));
                    }
                    if (FacetedProjectFramework.hasProjectFacet((IProject)this._project, (String)facetId.getId(), (String)facetId.getVersion())) {
                        isActive = true;
                        break;
                    }
                    if (accessible) continue;
                    TechnologyToFacetMap.debugPrint(String.format("Facet %s not found on project %s\n", facetId, this._project.getName()));
                }
                catch (CoreException e) {
                    LoggingService.logException((Plugin)Activator.getDefault(), (CoreException)e);
                }
            }
        }
        return isActive;
    }

    private static void debugPrint(String msg) {
    }

    public Set<IProjectFacetVersion> getExpectedFacets(ITechnologyExtensionIdentifier techId) {
        Set<Identifier> facetIdent;
        HashSet<IProjectFacetVersion> expectedFacets = new HashSet<IProjectFacetVersion>();
        Identifier techIdent = this.createTechnologyIdentifier(techId);
        if (techIdent != null && (facetIdent = this._techToFacetMap.get(techIdent)) != null) {
            for (Identifier id : facetIdent) {
                IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)id.getId());
                IProjectFacetVersion facetVersion = projectFacet.getVersion(id.getVersion());
                expectedFacets.add(facetVersion);
            }
        }
        return Collections.unmodifiableSet(expectedFacets);
    }

    private final Identifier createTechnologyIdentifier(ITechnologyExtensionIdentifier technologyId) {
        return new Identifier(technologyId.getId(), technologyId.getVersion());
    }

    private void buildMaps() {
        IConfigurationElement[] elems;
        HashMap<Identifier, Set<Identifier>> techToFacetMap = new HashMap<Identifier, Set<Identifier>>();
        HashMap<Identifier, Set<Identifier>> facetToTechMap = new HashMap<Identifier, Set<Identifier>>();
        IConfigurationElement[] iConfigurationElementArray = elems = this.getConfigElements();
        int n = elems.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            IConfigurationElement tech = elem.getChildren("technology")[0];
            Identifier ti = new Identifier(tech.getAttribute("id"), tech.getAttribute("version"));
            IConfigurationElement facet = elem.getChildren("facet")[0];
            Identifier fi = new Identifier(facet.getAttribute("id"), facet.getAttribute("version"));
            this.addToMap(techToFacetMap, ti, fi);
            this.addToMap(facetToTechMap, fi, ti);
            ++n2;
        }
        this._techToFacetMap = Collections.unmodifiableMap(techToFacetMap);
        this._facetToTechMap = Collections.unmodifiableMap(facetToTechMap);
    }

    private ITechnologyExtensionIdentifier getTechIdent(Identifier ti) {
        for (ITechnologyExtensionIdentifier id : this._discProvider.getAllTechnologyProviderExtensions()) {
            if (!id.getId().equals(ti.getId()) || !id.getVersion().equals(ti.getVersion())) continue;
            return id;
        }
        return null;
    }

    private void addToMap(Map<Identifier, Set<Identifier>> map, Identifier key, Identifier ident) {
        Set<Identifier> idSet = map.get(key);
        if (idSet == null) {
            idSet = new HashSet<Identifier>();
            map.put(key, idSet);
        }
        idSet.add(ident);
    }

    private IConfigurationElement[] getConfigElements() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(TECH_FACET_MAP_EXT_PT);
    }

    Set<ITechnologyExtensionIdentifier> getTechnologyIdentifiers(IProjectFacetVersion projectFacetVersion) {
        Set<Identifier> ids = this._facetToTechMap.get(new Identifier(projectFacetVersion.getProjectFacet().getId(), projectFacetVersion.getVersionString()));
        HashSet<ITechnologyExtensionIdentifier> tids = new HashSet<ITechnologyExtensionIdentifier>();
        if (ids != null) {
            for (Identifier id : ids) {
                ITechnologyExtensionIdentifier tid = this.getTechIdent(id);
                if (tid == null) continue;
                tids.add(tid);
            }
        }
        return tids;
    }

    public ITechnologyExtensionIdentifier getTechnologyIDForFacet(IProjectFacetVersion version, String techIdentifier) {
        Set<ITechnologyExtensionIdentifier> ids = this.getTechnologyIdentifiers(version);
        if (ids.size() > 0) {
            for (ITechnologyExtensionIdentifier id : ids) {
                if (!id.getId().equals(techIdentifier)) continue;
                return id;
            }
        }
        return null;
    }
}

