/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import java.lang.reflect.Constructor;
import oracle.eclipse.tools.common.services.Activator;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.AbstractTechnologyExtension;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyDescriptor;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import oracle.eclipse.tools.common.util.PluginUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import org.eclipse.core.runtime.Plugin;

public class TechnologyExtensionsFactory {
    private static TechnologyExtensionsFactory _factory;

    public static synchronized TechnologyExtensionsFactory getInstance() {
        if (_factory == null) {
            _factory = new TechnologyExtensionsFactory();
        }
        return _factory;
    }

    private TechnologyExtensionsFactory() {
    }

    public ITechnologyExtension create(Project project, ITechnologyDescriptor desc) {
        ITechnologyExtension ext = null;
        Class klass = PluginUtil.loadClass((String)desc.getTechnologyIdentifier().getBundleId(), (String)desc.getTechnologyIdentifier().getImplementationClassName(), AbstractTechnologyExtension.class);
        if (klass != null) {
            Class[] paramTypes = new Class[]{Project.class, ITechnologyDescriptor.class};
            try {
                Constructor constructor = klass.getConstructor(paramTypes);
                ext = (ITechnologyExtension)constructor.newInstance(project, desc);
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        return ext;
    }
}

