/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.common.services.project.technology;

import java.util.Set;
import oracle.eclipse.tools.common.services.project.Project;
import oracle.eclipse.tools.common.services.project.technology.ITechnologyExtension;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;

public final class TechnologyExtensionPropertyTester
extends PropertyTester {
    private static final String TECH_EXT_PROP_NAME = "technologyExtension";

    public boolean test(Object receiver, String property, Object[] args, Object value) {
        if (!property.equals(TECH_EXT_PROP_NAME)) {
            throw new IllegalStateException();
        }
        if (!(receiver instanceof IProject)) {
            return false;
        }
        return this.isTechExtensionEnabled(value.toString(), (IProject)receiver);
    }

    private boolean isTechExtensionEnabled(String formattedString, IProject project) {
        String id = null;
        String version = null;
        int colonIndex = formattedString.indexOf(58);
        if (colonIndex == -1) {
            id = formattedString;
        } else {
            id = formattedString.substring(0, colonIndex - 1);
            version = formattedString.substring(colonIndex);
        }
        Project prj = (Project)Platform.getAdapterManager().loadAdapter((Object)project, Project.class.getName());
        Set<ITechnologyExtension> activeExtensions = prj.getTechnologyExtensions();
        for (ITechnologyExtension ext : activeExtensions) {
            if (!ext.getId().equals(id) || version != null && !ext.getVersion().equals(version)) continue;
            return true;
        }
        return false;
    }
}

